/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.tileentity;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.oredict.OreDictionary;
import twilightforest.block.BlockTFCinderFurnace;
import twilightforest.block.BlockTFCinderLog;
import twilightforest.block.TFBlocks;

public class TileEntityTFCinderFurnace
extends TileEntityFurnace {
    private static final int SMELT_LOG_FACTOR = 10;

    public void func_73660_a() {
        boolean flag = this.func_145950_i();
        boolean flag1 = false;
        if (this.func_145950_i()) {
            --this.field_145956_a;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.field_145957_n.get(1);
            if (this.func_145950_i() || !itemstack.func_190926_b() && !((ItemStack)this.field_145957_n.get(0)).func_190926_b()) {
                if (!this.func_145950_i() && this.canSmelt()) {
                    this.field_145963_i = this.field_145956_a = TileEntityTFCinderFurnace.func_145952_a((ItemStack)itemstack);
                    if (this.func_145950_i()) {
                        flag1 = true;
                        if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(itemstack);
                                this.field_145957_n.set(1, (Object)item1);
                            }
                        }
                    }
                }
                if (this.func_145950_i() && this.canSmelt()) {
                    this.field_174906_k += this.getCurrentSpeedMultiplier();
                    if (this.field_174906_k >= this.field_174905_l) {
                        this.field_174906_k = 0;
                        this.field_174905_l = this.func_174904_a((ItemStack)this.field_145957_n.get(0));
                        this.func_145949_j();
                        flag1 = true;
                    }
                } else {
                    this.field_174906_k = 0;
                }
            } else if (!this.func_145950_i() && this.field_174906_k > 0) {
                this.field_174906_k = MathHelper.func_76125_a((int)(this.field_174906_k - 2), (int)0, (int)this.field_174905_l);
            }
            if (flag != this.func_145950_i()) {
                flag1 = true;
                BlockTFCinderFurnace.setState(this.func_145950_i(), this.field_145850_b, this.field_174879_c);
            }
            if (this.func_145950_i() && this.field_145956_a % 5 == 0) {
                this.cinderizeNearbyLog();
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private void cinderizeNearbyLog() {
        Block nearbyBlock;
        Random rand = this.func_145831_w().field_73012_v;
        int dx = rand.nextInt(2) - rand.nextInt(2);
        int dy = rand.nextInt(2) - rand.nextInt(2);
        int dz = rand.nextInt(2) - rand.nextInt(2);
        BlockPos pos = this.func_174877_v().func_177982_a(dx, dy, dz);
        if (this.field_145850_b.func_175667_e(pos) && (nearbyBlock = this.func_145831_w().func_180495_p(pos).func_177230_c()) != TFBlocks.cinderLog && this.isLog(nearbyBlock)) {
            this.func_145831_w().func_180501_a(pos, TFBlocks.cinderLog.func_176223_P().func_177226_a((IProperty)BlockTFCinderLog.field_176299_a, (Comparable)this.getCinderFacing(dx, dy, dz)), 2);
            this.func_145831_w().func_175718_b(2004, pos, 0);
            this.func_145831_w().func_175718_b(2004, pos, 0);
            this.func_145831_w().func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private BlockLog.EnumAxis getCinderFacing(int dx, int dy, int dz) {
        if (dz == 0 && dx != 0) {
            return dy == 0 ? BlockLog.EnumAxis.X : BlockLog.EnumAxis.Z;
        }
        if (dx == 0 && dz != 0) {
            return dy == 0 ? BlockLog.EnumAxis.Z : BlockLog.EnumAxis.X;
        }
        if (dx == 0 && dz == 0) {
            return BlockLog.EnumAxis.Y;
        }
        return dy == 0 ? BlockLog.EnumAxis.Y : BlockLog.EnumAxis.NONE;
    }

    private boolean isLog(Block nearbyBlock) {
        int[] oreIDs;
        for (int id : oreIDs = OreDictionary.getOreIDs((ItemStack)new ItemStack(nearbyBlock))) {
            if (id != OreDictionary.getOreID((String)"logWood")) continue;
            return true;
        }
        return false;
    }

    private int getCurrentSpeedMultiplier() {
        return this.getCurrentMultiplier(2);
    }

    private int getCurrentMultiplier(int factor) {
        int logs = this.countNearbyLogs();
        if (logs < factor) {
            return 1;
        }
        return logs / factor + (this.field_145850_b.field_73012_v.nextInt(factor) >= logs % factor ? 0 : 1);
    }

    private int countNearbyLogs() {
        int count = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos pos = this.func_174877_v().func_177982_a(dx, dy, dz);
                    if (!this.field_145850_b.func_175667_e(pos) || this.func_145831_w().func_180495_p(pos).func_177230_c() != TFBlocks.cinderLog) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private boolean canSmelt() {
        if (((ItemStack)this.field_145957_n.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.field_145957_n.get(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.field_145957_n.get(2);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        int result = itemstack1.func_190916_E() + this.getMaxOutputStacks((ItemStack)this.field_145957_n.get(0), itemstack);
        return result <= this.func_70297_j_() && result <= itemstack1.func_77976_d();
    }

    public int getMaxOutputStacks(ItemStack input, ItemStack output) {
        if (this.canMultiply(input, output)) {
            return output.func_190916_E() * this.getCurrentMaxSmeltMultiplier();
        }
        return output.func_190916_E();
    }

    public void func_145949_j() {
        if (this.canSmelt()) {
            ItemStack itemstack = (ItemStack)this.field_145957_n.get(0);
            ItemStack itemstack1 = FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
            itemstack1.func_190920_e(itemstack1.func_190916_E() * this.getCurrentSmeltMultiplier());
            ItemStack itemstack2 = (ItemStack)this.field_145957_n.get(2);
            if (itemstack2.func_190926_b()) {
                this.field_145957_n.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && itemstack.func_77960_j() == 1 && !((ItemStack)this.field_145957_n.get(1)).func_190926_b() && ((ItemStack)this.field_145957_n.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.field_145957_n.set(1, (Object)new ItemStack(Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    private boolean canMultiply(ItemStack input, ItemStack output) {
        int[] oreIDs;
        for (int id : oreIDs = OreDictionary.getOreIDs((ItemStack)input)) {
            if (!OreDictionary.getOreName((int)id).startsWith("ore") && id != OreDictionary.getOreID((String)"logWood")) continue;
            return true;
        }
        return false;
    }

    private int getCurrentSmeltMultiplier() {
        return this.getCurrentMultiplier(10);
    }

    private int getCurrentMaxSmeltMultiplier() {
        return (int)Math.ceil((float)this.countNearbyLogs() / 10.0f);
    }
}

