/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import twilightforest.world.TFGenerator;
import twilightforest.world.TFTreeGenerator;

public class TFGenCanopyMushroom
extends TFTreeGenerator {
    public TFGenCanopyMushroom() {
        this(false);
    }

    public TFGenCanopyMushroom(boolean par1) {
        super(par1);
        this.treeState = Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM);
        this.branchState = Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.ALL_STEM);
        this.leafState = Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.CENTER);
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        Block blockUnder;
        int treeHeight = 12;
        if (random.nextInt(3) == 0) {
            treeHeight += random.nextInt(5);
            if (random.nextInt(8) == 0) {
                treeHeight += random.nextInt(5);
            }
        }
        if ((blockUnder = world.func_180495_p(pos.func_177977_b()).func_177230_c()) != Blocks.field_150349_c && blockUnder != Blocks.field_150346_d && blockUnder != Blocks.field_150391_bh || pos.func_177956_o() >= 256 - treeHeight - 1) {
            return false;
        }
        this.treeState = random.nextInt(3) == 0 ? Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM) : Blocks.field_150420_aW.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM);
        this.leafState = this.treeState.func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.CENTER);
        this.buildBranch(world, pos, 0, treeHeight, 0.0, 0.0, true, random);
        int numBranches = 3 + random.nextInt(2);
        double offset = random.nextDouble();
        for (int b = 0; b < numBranches; ++b) {
            this.buildBranch(world, pos, treeHeight - 5 + b, 9.0, 0.3 * (double)b + offset, 0.2, false, random);
        }
        return true;
    }

    private void buildBranch(World world, BlockPos pos, int height, double length, double angle, double tilt, boolean trunk, Random treeRNG) {
        BlockPos src = pos.func_177981_b(height);
        BlockPos dest = TFGenerator.translate(src, length, angle, tilt);
        if (world.func_175697_a(dest, 5)) {
            if (src.func_177958_n() != dest.func_177958_n() || src.func_177952_p() != dest.func_177952_p()) {
                TFGenerator.drawBresehnam(this, world, src, new BlockPos(dest.func_177958_n(), src.func_177956_o(), dest.func_177952_p()), this.branchState);
                TFGenerator.drawBresehnam(this, world, new BlockPos(dest.func_177958_n(), src.func_177956_o() + 1, dest.func_177952_p()), dest.func_177977_b(), this.treeState);
            } else {
                TFGenerator.drawBresehnam(this, world, src, dest.func_177977_b(), this.treeState);
            }
            if (trunk) {
                this.addFirefly(world, pos, 3 + treeRNG.nextInt(7), treeRNG.nextDouble());
            }
            this.drawMushroomCircle(world, dest, 4, this.leafState);
        }
    }

    private void drawMushroomCircle(World world, BlockPos pos, int rad, IBlockState baseState) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                int dist = (int)((double)Math.max(dx, dz) + (double)Math.min(dx, dz) * 0.5);
                if (dx == 3 && dz == 3) {
                    dist = 6;
                }
                if (dx == 0) {
                    if (dz < rad) {
                        this.func_175903_a(world, pos.func_177982_a(0, 0, dz), baseState);
                        this.func_175903_a(world, pos.func_177982_a(0, 0, -dz), baseState);
                        continue;
                    }
                    this.func_175903_a(world, pos.func_177982_a(0, 0, dz), baseState.func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.SOUTH));
                    this.func_175903_a(world, pos.func_177982_a(0, 0, -dz), baseState.func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.NORTH));
                    continue;
                }
                if (dz == 0) {
                    if (dx < rad) {
                        this.func_175903_a(world, pos.func_177982_a(dx, 0, 0), baseState);
                        this.func_175903_a(world, pos.func_177982_a(-dx, 0, 0), baseState);
                        continue;
                    }
                    this.func_175903_a(world, pos.func_177982_a(dx, 0, 0), baseState.func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.EAST));
                    this.func_175903_a(world, pos.func_177982_a(-dx, 0, 0), baseState.func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.WEST));
                    continue;
                }
                if (dist < rad) {
                    this.func_175903_a(world, pos.func_177982_a(dx, 0, dz), baseState);
                    this.func_175903_a(world, pos.func_177982_a(dx, 0, -dz), baseState);
                    this.func_175903_a(world, pos.func_177982_a(-dx, 0, dz), baseState);
                    this.func_175903_a(world, pos.func_177982_a(-dx, 0, -dz), baseState);
                    continue;
                }
                if (dist != rad) continue;
                this.func_175903_a(world, pos.func_177982_a(dx, 0, dz), baseState.func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.SOUTH_EAST));
                this.func_175903_a(world, pos.func_177982_a(dx, 0, -dz), baseState.func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.NORTH_EAST));
                this.func_175903_a(world, pos.func_177982_a(-dx, 0, dz), baseState.func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.SOUTH_WEST));
                this.func_175903_a(world, pos.func_177982_a(-dx, 0, -dz), baseState.func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.NORTH_WEST));
            }
        }
    }
}

