/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import twilightforest.world.IBlockSettable;

public abstract class TFGenerator
extends WorldGenerator
implements IBlockSettable {
    public TFGenerator() {
        this(false);
    }

    public TFGenerator(boolean par1) {
        super(par1);
    }

    @Override
    public final void setBlockAndNotify(World worldIn, BlockPos pos, IBlockState state) {
        this.func_175903_a(worldIn, pos, state);
    }

    public static BlockPos translate(BlockPos pos, double distance, double angle, double tilt) {
        double rangle = angle * 2.0 * Math.PI;
        double rtilt = tilt * Math.PI;
        return pos.func_177963_a((double)Math.round(Math.sin(rangle) * Math.sin(rtilt) * distance), (double)Math.round(Math.cos(rtilt) * distance), (double)Math.round(Math.cos(rangle) * Math.sin(rtilt) * distance));
    }

    protected static void drawBresehnam(IBlockSettable generator, World world, BlockPos from, BlockPos to, IBlockState state) {
        for (BlockPos pixel : TFGenerator.getBresehnamArrays(from, to)) {
            generator.setBlockAndNotify(world, pixel, state);
        }
    }

    public static BlockPos[] getBresehnamArrays(BlockPos src, BlockPos dest) {
        return TFGenerator.getBresehnamArrays(src.func_177958_n(), src.func_177956_o(), src.func_177952_p(), dest.func_177958_n(), dest.func_177956_o(), dest.func_177952_p());
    }

    public static BlockPos[] getBresehnamArrays(int x1, int y1, int z1, int x2, int y2, int z2) {
        BlockPos[] lineArray;
        BlockPos pixel = new BlockPos(x1, y1, z1);
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int x_inc = dx < 0 ? -1 : 1;
        int absDx = Math.abs(dx);
        int y_inc = dy < 0 ? -1 : 1;
        int absDy = Math.abs(dy);
        int z_inc = dz < 0 ? -1 : 1;
        int absDz = Math.abs(dz);
        int doubleAbsDx = absDx << 1;
        int doubleAbsDy = absDy << 1;
        int doubleAbsDz = absDz << 1;
        if (absDx >= absDy && absDx >= absDz) {
            int err_1 = doubleAbsDy - absDx;
            int err_2 = doubleAbsDz - absDx;
            lineArray = new BlockPos[absDx + 1];
            for (int i = 0; i < absDx; ++i) {
                lineArray[i] = pixel;
                if (err_1 > 0) {
                    pixel = pixel.func_177981_b(y_inc);
                    err_1 -= doubleAbsDx;
                }
                if (err_2 > 0) {
                    pixel = pixel.func_177970_e(z_inc);
                    err_2 -= doubleAbsDx;
                }
                err_1 += doubleAbsDy;
                err_2 += doubleAbsDz;
                pixel = pixel.func_177965_g(x_inc);
            }
        } else if (absDy >= absDx && absDy >= absDz) {
            int err_1 = doubleAbsDx - absDy;
            int err_2 = doubleAbsDz - absDy;
            lineArray = new BlockPos[absDy + 1];
            for (int i = 0; i < absDy; ++i) {
                lineArray[i] = pixel;
                if (err_1 > 0) {
                    pixel = pixel.func_177965_g(x_inc);
                    err_1 -= doubleAbsDy;
                }
                if (err_2 > 0) {
                    pixel = pixel.func_177970_e(z_inc);
                    err_2 -= doubleAbsDy;
                }
                err_1 += doubleAbsDx;
                err_2 += doubleAbsDz;
                pixel = pixel.func_177981_b(y_inc);
            }
        } else {
            int err_1 = doubleAbsDy - absDz;
            int err_2 = doubleAbsDx - absDz;
            lineArray = new BlockPos[absDz + 1];
            for (int i = 0; i < absDz; ++i) {
                lineArray[i] = pixel;
                if (err_1 > 0) {
                    pixel = pixel.func_177981_b(y_inc);
                    err_1 -= doubleAbsDz;
                }
                if (err_2 > 0) {
                    pixel = pixel.func_177965_g(x_inc);
                    err_2 -= doubleAbsDz;
                }
                err_1 += doubleAbsDy;
                err_2 += doubleAbsDx;
                pixel = pixel.func_177970_e(z_inc);
            }
        }
        lineArray[lineArray.length - 1] = pixel;
        return lineArray;
    }

    public static void makeLeafCircle(IBlockSettable generator, World world, BlockPos pos, int rad, IBlockState state, boolean useHack) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                int dist = Math.max(dx, dz) + (Math.min(dx, dz) >> 1);
                if (useHack && dx == 3 && dz == 3) {
                    dist = 6;
                }
                if (dist > rad) continue;
                TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(dx, 0, dz), state);
                TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(dx, 0, -dz), state);
                TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(-dx, 0, dz), state);
                TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(-dx, 0, -dz), state);
            }
        }
    }

    public static void makeLeafCircle2(IBlockSettable generator, World world, BlockPos pos, int rad, IBlockState state, boolean useHack) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                if (dx * dx + dz * dz > rad * rad) continue;
                TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(1 + dx, 0, 1 + dz), state);
                TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(1 + dx, 0, -dz), state);
                TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(-dx, 0, 1 + dz), state);
                TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(-dx, 0, -dz), state);
            }
        }
    }

    public static void putLeafBlock(IBlockSettable generator, World world, BlockPos pos, IBlockState state) {
        IBlockState whatsThere = world.func_180495_p(pos);
        if (whatsThere.func_177230_c().canBeReplacedByLeaves(whatsThere, (IBlockAccess)world, pos) && whatsThere.func_177230_c() != state.func_177230_c()) {
            generator.setBlockAndNotify(world, pos, state);
        }
    }

    protected static IBlockState randStone(Random rand, int howMuch) {
        return rand.nextInt(howMuch) >= 1 ? Blocks.field_150347_e.func_176223_P() : Blocks.field_150341_Y.func_176223_P();
    }

    protected static boolean isAreaSuitable(World world, Random rand, BlockPos pos, int width, int height, int depth) {
        boolean flag = true;
        for (int cx = 0; cx < width; ++cx) {
            for (int cz = 0; cz < depth; ++cz) {
                BlockPos pos_ = pos.func_177982_a(cx, 0, cz);
                if (world.func_175667_e(pos_)) {
                    Material m = world.func_180495_p(pos_.func_177977_b()).func_185904_a();
                    if (m != Material.field_151578_c && m != Material.field_151577_b && m != Material.field_151576_e) {
                        flag = false;
                    }
                    for (int cy = 0; cy < height; ++cy) {
                        if (world.func_175623_d(pos_.func_177981_b(cy))) continue;
                        flag = false;
                    }
                    continue;
                }
                flag = false;
            }
        }
        return flag;
    }

    public static void drawBlob(IBlockSettable generator, World world, BlockPos pos, int rad, IBlockState state) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    int dist = 0;
                    dist = dx >= dy && dx >= dz ? dx + (Math.max(dy, dz) >> 1) + (Math.min(dy, dz) >> 2) : (dy >= dx && dy >= dz ? dy + (Math.max(dx, dz) >> 1) + (Math.min(dx, dz) >> 2) : dz + (Math.max(dx, dy) >> 1) + (Math.min(dx, dy) >> 2));
                    if (dist > rad) continue;
                    generator.setBlockAndNotify(world, pos.func_177982_a(dx, dy, dz), state);
                    generator.setBlockAndNotify(world, pos.func_177982_a(dx, dy, -dz), state);
                    generator.setBlockAndNotify(world, pos.func_177982_a(-dx, dy, dz), state);
                    generator.setBlockAndNotify(world, pos.func_177982_a(-dx, dy, -dz), state);
                    generator.setBlockAndNotify(world, pos.func_177982_a(dx, -dy, dz), state);
                    generator.setBlockAndNotify(world, pos.func_177982_a(dx, -dy, -dz), state);
                    generator.setBlockAndNotify(world, pos.func_177982_a(-dx, -dy, dz), state);
                    generator.setBlockAndNotify(world, pos.func_177982_a(-dx, -dy, -dz), state);
                }
            }
        }
    }

    public static void drawLeafBlob(IBlockSettable generator, World world, BlockPos pos, int rad, IBlockState state) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    int dist = 0;
                    dist = dx >= dy && dx >= dz ? dx + (Math.max(dy, dz) >> 1) + (Math.min(dy, dz) >> 2) : (dy >= dx && dy >= dz ? dy + (Math.max(dx, dz) >> 1) + (Math.min(dx, dz) >> 2) : dz + (Math.max(dx, dy) >> 1) + (Math.min(dx, dy) >> 2));
                    if (dist > rad) continue;
                    TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(dx, dy, dz), state);
                    TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(dx, dy, -dz), state);
                    TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(-dx, dy, dz), state);
                    TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(-dx, dy, -dz), state);
                    TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(dx, -dy, dz), state);
                    TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(dx, -dy, -dz), state);
                    TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(-dx, -dy, dz), state);
                    TFGenerator.putLeafBlock(generator, world, pos.func_177982_a(-dx, -dy, -dz), state);
                }
            }
        }
    }

    protected static boolean surroundedByAir(IBlockAccess world, BlockPos pos) {
        for (EnumFacing e : EnumFacing.field_82609_l) {
            if (world.func_175623_d(pos.func_177972_a(e))) continue;
            return false;
        }
        return true;
    }

    protected static boolean hasAirAround(World world, BlockPos pos) {
        for (EnumFacing e : EnumFacing.field_82609_l) {
            if (e == EnumFacing.DOWN || !world.func_175667_e(pos.func_177972_a(e)) || !world.func_175623_d(pos.func_177972_a(e))) continue;
            return true;
        }
        return false;
    }

    protected static boolean isNearSolid(World world, BlockPos pos) {
        for (EnumFacing e : EnumFacing.field_176754_o) {
            if (!world.func_175667_e(pos.func_177972_a(e)) || !world.func_180495_p(pos.func_177972_a(e)).func_185904_a().func_76220_a()) continue;
            return true;
        }
        return false;
    }
}

