/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block;

import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.InventoryHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.block.TileAugmentableSecure;
import cofh.thermalexpansion.util.Utils;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileInventory
extends TileAugmentableSecure
implements IInventory {
    public ItemStack[] inventory = new ItemStack[0];

    public boolean extractItem(int slot, int amount, EnumFacing side) {
        if (slot > this.inventory.length) {
            return false;
        }
        ItemStack stack = this.inventory[slot];
        if (!stack.func_190926_b()) {
            amount = Math.min(amount, stack.func_77976_d() - stack.func_190916_E());
            stack = this.inventory[slot].func_77946_l();
        }
        int initialAmount = amount;
        TileEntity adjInv = BlockHelper.getAdjacentTileEntity((TileEntity)this, (EnumFacing)side);
        if (Utils.isAccessibleInput(adjInv, side)) {
            IItemHandler inv = InventoryHelper.getItemHandlerCap((TileEntity)adjInv, (EnumFacing)side.func_176734_d());
            if (inv == null) {
                return false;
            }
            for (int i = 0; i < inv.getSlots() && amount > 0; ++i) {
                int toExtract;
                ItemStack queryStack = inv.extractItem(i, amount, true);
                if (queryStack.func_190926_b()) continue;
                if (stack.func_190926_b()) {
                    if (!this.func_94041_b(slot, queryStack)) continue;
                    toExtract = Math.min(amount, queryStack.func_190916_E());
                    stack = inv.extractItem(i, toExtract, false);
                    amount -= toExtract;
                    continue;
                }
                if (!ItemHelper.itemsEqualWithMetadata((ItemStack)stack, (ItemStack)queryStack, (boolean)true)) continue;
                ItemStack extracted = inv.extractItem(i, toExtract = Math.min(stack.func_77976_d() - stack.func_190916_E(), Math.min(amount, queryStack.func_190916_E())), false);
                toExtract = Math.min(toExtract, extracted.func_190926_b() ? 0 : extracted.func_190916_E());
                stack.func_190917_f(toExtract);
                amount -= toExtract;
            }
            if (initialAmount != amount) {
                this.inventory[slot] = stack;
                adjInv.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public boolean transferItem(int slot, int amount, EnumFacing side) {
        if (this.inventory[slot].func_190926_b() || slot > this.inventory.length) {
            return false;
        }
        ItemStack initialStack = this.inventory[slot].func_77946_l();
        initialStack.func_190920_e(Math.min(amount, initialStack.func_190916_E()));
        TileEntity adjInv = BlockHelper.getAdjacentTileEntity((TileEntity)this, (EnumFacing)side);
        if (Utils.isAccessibleOutput(adjInv, side)) {
            ItemStack inserted = InventoryHelper.addToInventory((TileEntity)adjInv, (EnumFacing)side, (ItemStack)initialStack);
            if (inserted.func_190916_E() >= initialStack.func_190916_E()) {
                return false;
            }
            this.inventory[slot].func_190918_g(initialStack.func_190916_E() - inserted.func_190916_E());
            if (this.inventory[slot].func_190916_E() <= 0) {
                this.inventory[slot] = ItemStack.field_190927_a;
            }
            return true;
        }
        return false;
    }

    public int getInvSlotCount() {
        return this.inventory.length;
    }

    public boolean hasGui() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readInventoryFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeInventoryToNBT(nbt);
        return nbt;
    }

    public void readInventoryFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Inventory", 10);
        this.inventory = new ItemStack[this.inventory.length];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int slot = tag.func_74762_e("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = new ItemStack(tag);
        }
    }

    public void writeInventoryToNBT(NBTTagCompound nbt) {
        if (this.inventory.length <= 0) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i].func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Slot", i);
            this.inventory[i].func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        if (list.func_74745_c() > 0) {
            nbt.func_74782_a("Inventory", (NBTBase)list);
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public boolean func_191420_l() {
        return InventoryHelper.isEmpty((ItemStack[])this.inventory);
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot].func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.inventory[slot].func_190916_E() <= amount) {
            amount = this.inventory[slot].func_190916_E();
        }
        ItemStack stack = this.inventory[slot].func_77979_a(amount);
        if (this.inventory[slot].func_190916_E() <= 0) {
            this.inventory[slot] = ItemStack.field_190927_a;
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot].func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.inventory[slot];
        this.inventory[slot] = ItemStack.field_190927_a;
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        this.markChunkDirty();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.isUsable(player);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, from);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this instanceof ISidedInventory && facing != null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new SidedInvWrapper((ISidedInventory)this, facing));
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new InvWrapper((IInventory)this));
        }
        return (T)super.getCapability(capability, facing);
    }
}

