/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block;

import cofh.api.tileentity.IEnergyInfo;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.EnergyHelper;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.redstoneflux.api.IEnergyStorage;
import cofh.redstoneflux.impl.EnergyStorage;
import cofh.thermalexpansion.block.TileReconfigurable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TilePowered
extends TileReconfigurable
implements IEnergyInfo,
IEnergyReceiver {
    protected EnergyStorage energyStorage = new EnergyStorage(0);

    public boolean smallStorage() {
        return false;
    }

    protected boolean hasEnergy(int energy) {
        return this.energyStorage.getEnergyStored() >= energy;
    }

    protected int getEnergySpace() {
        return this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored();
    }

    protected boolean hasChargeSlot() {
        return true;
    }

    protected void chargeEnergy() {
        if (!this.hasChargeSlot()) {
            return;
        }
        int chargeSlot = this.getChargeSlot();
        if (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[chargeSlot])) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyContainerItem)this.inventory[chargeSlot].func_77973_b()).extractEnergy(this.inventory[chargeSlot], energyRequest, false), false);
            if (this.inventory[chargeSlot].func_190916_E() <= 0) {
                this.inventory[chargeSlot] = ItemStack.field_190927_a;
            }
        } else if (EnergyHelper.isEnergyHandler((ItemStack)this.inventory[chargeSlot])) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((net.minecraftforge.energy.IEnergyStorage)this.inventory[chargeSlot].getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(energyRequest, false), false);
            if (this.inventory[chargeSlot].func_190916_E() <= 0) {
                this.inventory[chargeSlot] = ItemStack.field_190927_a;
            }
        }
    }

    public int getChargeSlot() {
        return this.inventory.length - 1;
    }

    public final void setEnergyStored(int quantity) {
        this.energyStorage.setEnergyStored(quantity);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.energyStorage.writeToNBT(nbt);
        return nbt;
    }

    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.isActive);
        payload.addInt(this.energyStorage.getMaxEnergyStored());
        payload.addInt(this.energyStorage.getEnergyStored());
        return payload;
    }

    @Override
    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addInt(this.energyStorage.getEnergyStored());
        return payload;
    }

    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.isActive = payload.getBool();
        this.energyStorage.setCapacity(payload.getInt());
        this.energyStorage.setEnergyStored(payload.getInt());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.energyStorage.setEnergyStored(payload.getInt());
    }

    public int getInfoEnergyPerTick() {
        return 0;
    }

    public int getInfoMaxEnergyPerTick() {
        return 0;
    }

    public int getInfoEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored() > 0;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, from);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)new net.minecraftforge.energy.IEnergyStorage(){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    return TilePowered.this.receiveEnergy(from, maxReceive, simulate);
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    return 0;
                }

                public int getEnergyStored() {
                    return TilePowered.this.getEnergyStored(from);
                }

                public int getMaxEnergyStored() {
                    return TilePowered.this.getMaxEnergyStored(from);
                }

                public boolean canExtract() {
                    return false;
                }

                public boolean canReceive() {
                    return true;
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

