/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileReconfigurable;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.init.TETextures;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;

public abstract class TileDeviceBase
extends TileReconfigurable {
    public static final TileTEBase.SideConfig[] SIDE_CONFIGS = new TileTEBase.SideConfig[BlockDevice.Type.values().length];
    public static final TileTEBase.SlotConfig[] SLOT_CONFIGS = new TileTEBase.SlotConfig[BlockDevice.Type.values().length];
    public static final int[] LIGHT_VALUES = new int[BlockDevice.Type.values().length];
    private static boolean enableSecurity = true;

    public static void config() {
        String category = "Device";
        String comment = "If TRUE, Devices are securable.";
        enableSecurity = ThermalExpansion.CONFIG.get(category, "Securable", true, comment);
    }

    public TileDeviceBase() {
        this.sideConfig = SIDE_CONFIGS[this.getType()];
        this.slotConfig = SLOT_CONFIGS[this.getType()];
        this.setDefaultSides();
        this.hasRedstoneControl = true;
    }

    public String getTileName() {
        return "tile.thermalexpansion.device." + BlockDevice.Type.byMetadata(this.getType()).func_176610_l() + ".name";
    }

    public int getLightValue() {
        return this.isActive ? LIGHT_VALUES[this.getType()] : 0;
    }

    @Override
    public boolean isAugmentable() {
        return false;
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    @Override
    public boolean sendRedstoneUpdates() {
        return true;
    }

    @Override
    public void setDefaultSides() {
        this.sideCache = this.getDefaultSides();
        this.sideCache[this.facing] = 0;
    }

    @Override
    protected boolean setLevel(int level) {
        return false;
    }

    @Override
    protected void setLevelFlags() {
        this.level = 0;
        this.hasRedstoneControl = true;
    }

    protected void updateIfChanged(boolean curActive) {
        if (curActive != this.isActive) {
            if (LIGHT_VALUES[this.getType()] != 0) {
                this.updateLighting();
            }
            this.sendTilePacket(Side.CLIENT);
        }
    }

    @Override
    public boolean setFacing(int side, boolean alternate) {
        if (side < 2 || side > 5) {
            return false;
        }
        this.facing = (byte)side;
        this.sideCache[this.facing] = 0;
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public int getNumPasses() {
        return 2;
    }

    @Override
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.DEVICE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.DEVICE_TOP;
            }
            return side != this.facing ? TETextures.DEVICE_SIDE : (this.isActive ? TETextures.DEVICE_ACTIVE[this.getType()] : TETextures.DEVICE_FACE[this.getType()]);
        }
        if (side < 6) {
            return TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]];
        }
        return TETextures.DEVICE_SIDE;
    }

    public boolean hasFluidUnderlay() {
        return false;
    }

    public FluidStack getRenderFluid() {
        return null;
    }

    public int getColorMask(BlockRenderLayer layer, EnumFacing side) {
        return -1;
    }

    @Override
    public boolean canUpgrade(ItemStack upgrade) {
        return false;
    }

    @Override
    public boolean installUpgrade(ItemStack upgrade) {
        return false;
    }
}

