/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.block.device.TileLexicon;
import cofh.thermalexpansion.gui.client.device.GuiFactorizer;
import cofh.thermalexpansion.gui.container.device.ContainerFactorizer;
import cofh.thermalexpansion.util.managers.device.FactorizerManager;
import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileFactorizer
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.FACTORIZER.getMetadata();
    private int inputTracker;
    private int outputTracker;
    public boolean recipeMode;
    public boolean recipeFlag;
    private Map<String, ItemStack> preferredStacks = new THashMap();

    public static void initialize() {
        TileFactorizer.SIDE_CONFIGS[TileFactorizer.TYPE] = new TileTEBase.SideConfig();
        TileFactorizer.SIDE_CONFIGS[TileFactorizer.TYPE].numConfig = 5;
        TileFactorizer.SIDE_CONFIGS[TileFactorizer.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}, {0, 1}, {0, 1}};
        TileFactorizer.SIDE_CONFIGS[TileFactorizer.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileFactorizer.SIDE_CONFIGS[TileFactorizer.TYPE].defaultSides = new byte[]{2, 1, 1, 1, 1, 1};
        TileFactorizer.SLOT_CONFIGS[TileFactorizer.TYPE] = new TileTEBase.SlotConfig();
        TileFactorizer.SLOT_CONFIGS[TileFactorizer.TYPE].allowInsertionSlot = new boolean[]{true, false};
        TileFactorizer.SLOT_CONFIGS[TileFactorizer.TYPE].allowExtractionSlot = new boolean[]{false, true};
        TileFactorizer.LIGHT_VALUES[TileFactorizer.TYPE] = 4;
        GameRegistry.registerTileEntity(TileLexicon.class, (String)"thermalexpansion:device_factorizer");
        TileFactorizer.config();
    }

    public static void config() {
        String category = "Device.Lexicon";
        BlockDevice.enable[TileFactorizer.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    public TileFactorizer() {
        this.inventory = new ItemStack[2];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.hasAutoInput = true;
        this.hasAutoOutput = true;
        this.enableAutoInput = true;
        this.enableAutoOutput = true;
    }

    public int getType() {
        return TYPE;
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 16L != 0L) {
            return;
        }
        this.transferInput();
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.transmute();
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
            }
        } else if (this.redstoneControlOrDisable()) {
            this.isActive = true;
        }
        this.transferOutput();
        this.updateIfChanged(curActive);
    }

    protected void transmute() {
        if (this.inventory[0].func_190926_b()) {
            return;
        }
        FactorizerManager.FactorizerRecipe recipe = FactorizerManager.getRecipe(this.inventory[0], this.recipeMode);
        if (recipe == null) {
            return;
        }
        ItemStack input = recipe.getInput();
        if (this.inventory[0].func_190916_E() < input.func_190916_E()) {
            return;
        }
        ItemStack output = recipe.getOutput();
        if (this.inventory[1].func_190916_E() + output.func_190916_E() > this.inventory[1].func_77976_d()) {
            return;
        }
        if (this.inventory[1].func_190926_b()) {
            this.inventory[0].func_190918_g(input.func_190916_E());
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)output, (int)output.func_190916_E());
        } else if (this.inventory[1].func_77969_a(output)) {
            this.inventory[0].func_190918_g(input.func_190916_E());
            this.inventory[1].func_190917_f(output.func_190916_E());
        }
    }

    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, 64, EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(1, 64, EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiFactorizer(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerFactorizer(inventory, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        return nbt;
    }

    @Override
    public int func_70302_i_() {
        return 2;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0 || FactorizerManager.recipeExists(stack, this.recipeMode);
    }
}

