/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.network.PacketBase;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiFisher;
import cofh.thermalexpansion.gui.container.device.ContainerFisher;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.util.managers.device.FisherManager;
import java.util.Arrays;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class TileFisher
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.FISHER.getMetadata();
    private static final int[] TARGET_WATER = new int[]{10, 20, 30};
    private static final int TIME_CONSTANT = 7200;
    private static final int BOOST_TIME = 8;
    private int targetWater = -1;
    private int timeConstant = 7200;
    private boolean isOcean;
    private boolean isRiver;
    private boolean isRaining;
    private int inputTracker;
    private int outputTracker;
    private int boostMult;
    private int boostTime;
    private int offset;

    public static void initialize() {
        TileFisher.SIDE_CONFIGS[TileFisher.TYPE] = new TileTEBase.SideConfig();
        TileFisher.SIDE_CONFIGS[TileFisher.TYPE].numConfig = 5;
        TileFisher.SIDE_CONFIGS[TileFisher.TYPE].slotGroups = new int[][]{new int[0], {0}, {1, 2, 3, 4}, {0, 1, 2, 3, 4}, {0, 1, 2, 3, 4}};
        TileFisher.SIDE_CONFIGS[TileFisher.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileFisher.SIDE_CONFIGS[TileFisher.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileFisher.SLOT_CONFIGS[TileFisher.TYPE] = new TileTEBase.SlotConfig();
        TileFisher.SLOT_CONFIGS[TileFisher.TYPE].allowInsertionSlot = new boolean[]{true, false, false, false, false};
        TileFisher.SLOT_CONFIGS[TileFisher.TYPE].allowExtractionSlot = new boolean[]{false, true, true, true, true};
        GameRegistry.registerTileEntity(TileFisher.class, (String)"thermalexpansion:device_fisher");
        TileFisher.config();
    }

    public static void config() {
        String category = "Device.Fisher";
        BlockDevice.enable[TileFisher.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    public TileFisher() {
        this.inventory = new ItemStack[5];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.offset = MathHelper.RANDOM.nextInt(7200);
        this.hasAutoInput = true;
        this.hasAutoOutput = true;
        this.enableAutoInput = true;
        this.enableAutoOutput = true;
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void blockPlaced() {
        super.blockPlaced();
        if (this.redstoneControlOrDisable() && this.targetWater >= TARGET_WATER[0]) {
            this.isActive = true;
            this.sendTilePacket(Side.CLIENT);
        }
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateValidity();
    }

    public void func_73660_a() {
        if (!this.timeCheckOffset()) {
            return;
        }
        this.transferInput();
        boolean curActive = this.isActive;
        this.updateValidity();
        if (this.isActive) {
            if (this.targetWater >= TARGET_WATER[0]) {
                if (this.boostTime > 0) {
                    for (int i = 0; i < this.boostMult; ++i) {
                        this.catchFish();
                    }
                    --this.boostTime;
                } else {
                    this.boostMult = FisherManager.getBaitMultiplier(this.inventory[0]);
                    if (this.boostMult > 0) {
                        for (int i = 0; i < this.boostMult; ++i) {
                            this.catchFish();
                        }
                        this.boostTime = 7;
                        this.inventory[0].func_190918_g(1);
                        if (this.inventory[0].func_190916_E() <= 0) {
                            this.inventory[0] = ItemStack.field_190927_a;
                        }
                    } else {
                        this.catchFish();
                    }
                }
            }
            if (this.targetWater < TARGET_WATER[0] || !this.redstoneControlOrDisable()) {
                this.isActive = false;
            }
        } else if (this.targetWater >= TARGET_WATER[0] && this.redstoneControlOrDisable()) {
            this.isActive = true;
        }
        this.transferOutput();
        this.updateIfChanged(curActive);
    }

    protected void updateValidity() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        int adjacentSources = 0;
        this.targetWater = 0;
        if (TileFisher.isWater(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()))) {
            ++adjacentSources;
        }
        if (TileFisher.isWater(this.field_145850_b.func_180495_p(this.field_174879_c.func_177976_e()))) {
            ++adjacentSources;
        }
        if (TileFisher.isWater(this.field_145850_b.func_180495_p(this.field_174879_c.func_177974_f()))) {
            ++adjacentSources;
        }
        if (TileFisher.isWater(this.field_145850_b.func_180495_p(this.field_174879_c.func_177978_c()))) {
            ++adjacentSources;
        }
        if (TileFisher.isWater(this.field_145850_b.func_180495_p(this.field_174879_c.func_177968_d()))) {
            ++adjacentSources;
        }
        if (adjacentSources < 2) {
            return;
        }
        Iterable area = BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-2, -1, -2), (BlockPos)this.field_174879_c.func_177982_a(2, 0, 2));
        for (BlockPos query : area) {
            if (!TileFisher.isWater(this.field_145850_b.func_180495_p(query))) continue;
            ++this.targetWater;
        }
        this.isOcean = BiomeDictionary.hasType((Biome)this.field_145850_b.func_180494_b(this.field_174879_c), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN);
        this.isRiver = BiomeDictionary.hasType((Biome)this.field_145850_b.func_180494_b(this.field_174879_c), (BiomeDictionary.Type)BiomeDictionary.Type.RIVER);
        this.isRaining = this.field_145850_b.func_175727_C(this.field_174879_c);
        this.timeConstant = this.getTimeConstant();
    }

    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        boolean foundOutput = false;
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]])) continue;
            for (int j = 1; j < 5; ++j) {
                if (!this.transferItem(j, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                foundOutput = true;
            }
            if (!foundOutput) continue;
            this.outputTracker = side;
            break;
        }
    }

    protected void catchFish() {
        ItemStack fish = FisherManager.getFish();
        for (int j = 1; j < 5; ++j) {
            if (this.inventory[j].func_190926_b()) {
                this.inventory[j] = ItemHelper.cloneStack((ItemStack)fish);
                break;
            }
            if (this.inventory[j].func_190916_E() >= this.inventory[j].func_77976_d() || !ItemHelper.itemsIdentical((ItemStack)this.inventory[j], (ItemStack)fish)) continue;
            this.inventory[j].func_190917_f(1);
            break;
        }
    }

    protected static boolean isWater(IBlockState state) {
        return (state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
    }

    protected boolean timeCheckOffset() {
        return (this.field_145850_b.func_82737_E() + (long)this.offset) % (long)this.timeConstant == 0L;
    }

    protected int getTimeConstant() {
        int constant = 7200;
        if (this.isOcean) {
            constant /= 3;
        } else if (this.isRiver) {
            constant /= 2;
        }
        if (this.targetWater >= TARGET_WATER[2]) {
            return constant / (this.isRaining ? 4 : 3);
        }
        if (this.targetWater >= TARGET_WATER[1]) {
            return constant / (this.isRaining ? 3 : 2);
        }
        return constant / (this.isRaining ? 2 : 1);
    }

    public int getBoostMult() {
        return this.boostMult;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiFisher(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerFisher(inventory, (TileEntity)this);
    }

    @Override
    public int getScaledSpeed(int scale) {
        if (!this.isActive) {
            return 0;
        }
        return MathHelper.round((double)(scale * this.boostTime / 8));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.targetWater = nbt.func_74762_e("Water");
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.boostMult = nbt.func_74762_e("BoostMult");
        this.boostTime = nbt.func_74762_e("BoostTime");
        this.timeConstant = nbt.func_74762_e("TimeConstant");
        if (this.timeConstant <= 0) {
            this.timeConstant = 7200;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Water", this.targetWater);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74768_a("BoostMult", this.boostMult);
        nbt.func_74768_a("BoostTime", this.boostTime);
        nbt.func_74768_a("TimeConstant", this.timeConstant);
        return nbt;
    }

    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addInt(this.boostTime);
        payload.addInt(this.boostMult);
        return payload;
    }

    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.boostTime = payload.getInt();
        this.boostMult = payload.getInt();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return FisherManager.isValidBait(stack);
    }

    @Override
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.DEVICE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.DEVICE_TOP;
            }
            return side != this.facing ? TETextures.DEVICE_SIDE : (this.isActive ? RenderHelper.getFluidTexture((Fluid)FluidRegistry.WATER) : TETextures.DEVICE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.isActive ? TETextures.DEVICE_ACTIVE[TYPE] : TETextures.DEVICE_FACE[TYPE]);
        }
        return TETextures.DEVICE_SIDE;
    }

    @Override
    public boolean hasFluidUnderlay() {
        return true;
    }

    @Override
    public FluidStack getRenderFluid() {
        return new FluidStack(FluidRegistry.WATER, 1);
    }

    @Override
    public int getColorMask(BlockRenderLayer layer, EnumFacing side) {
        return layer == BlockRenderLayer.SOLID && side.ordinal() == this.facing && this.isActive ? FluidRegistry.WATER.getColor() << 8 | 0xFF : super.getColorMask(layer, side);
    }
}

