/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiFluidBuffer;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import javax.annotation.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileFluidBuffer
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.FLUID_BUFFER.getMetadata();
    private int inputTracker;
    private int outputTracker;
    private FluidTankCore[] tanks = new FluidTankCore[3];
    public boolean[] locks = new boolean[3];
    public int amountInput = 1000;
    public int amountOutput = 1000;

    public static void initialize() {
        TileFluidBuffer.SIDE_CONFIGS[TileFluidBuffer.TYPE] = new TileTEBase.SideConfig();
        TileFluidBuffer.SIDE_CONFIGS[TileFluidBuffer.TYPE].numConfig = 5;
        TileFluidBuffer.SIDE_CONFIGS[TileFluidBuffer.TYPE].slotGroups = new int[][]{new int[0], new int[0], new int[0], new int[0], new int[0]};
        TileFluidBuffer.SIDE_CONFIGS[TileFluidBuffer.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileFluidBuffer.SIDE_CONFIGS[TileFluidBuffer.TYPE].defaultSides = new byte[]{2, 1, 1, 1, 1, 1};
        TileFluidBuffer.SLOT_CONFIGS[TileFluidBuffer.TYPE] = new TileTEBase.SlotConfig();
        TileFluidBuffer.SLOT_CONFIGS[TileFluidBuffer.TYPE].allowInsertionSlot = new boolean[0];
        TileFluidBuffer.SLOT_CONFIGS[TileFluidBuffer.TYPE].allowExtractionSlot = new boolean[0];
        TileFluidBuffer.LIGHT_VALUES[TileFluidBuffer.TYPE] = 5;
        GameRegistry.registerTileEntity(TileFluidBuffer.class, (String)"thermalexpansion:device_fluid_buffer");
        TileFluidBuffer.config();
    }

    public static void config() {
        String category = "Device.FluidBuffer";
        BlockDevice.enable[TileFluidBuffer.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    public TileFluidBuffer() {
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTankCore(8000);
            this.locks[i] = false;
        }
        this.hasAutoInput = true;
        this.hasAutoOutput = true;
        this.enableAutoInput = true;
        this.enableAutoOutput = true;
    }

    public int getType() {
        return TYPE;
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 8L != 0L) {
            return;
        }
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.transferOutput();
            this.transferInput();
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
            }
        } else if (this.redstoneControlOrDisable()) {
            this.isActive = true;
        }
        this.updateIfChanged(curActive);
    }

    protected void transferInput() {
        if (!this.getTransferIn() || this.amountInput <= 0) {
            return;
        }
        block0: for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            FluidStack input;
            int side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !FluidHelper.isAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side]) || (input = FluidHelper.extractFluidFromAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (int)this.amountInput, (boolean)false)) == null) continue;
            for (int j = 0; j < this.tanks.length; ++j) {
                int toFill;
                if (this.tanks[j].getSpace() <= 0 || (toFill = this.tanks[j].fill(input, true)) <= 0) continue;
                FluidHelper.extractFluidFromAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (int)toFill, (boolean)true);
                this.inputTracker = side;
                continue block0;
            }
        }
    }

    protected void transferOutput() {
        if (!this.getTransferOut() || this.amountOutput <= 0) {
            return;
        }
        block0: for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]])) continue;
            for (int j = this.tanks.length - 1; j >= 0; --j) {
                FluidStack output;
                int toDrain;
                if (this.tanks[j].getFluidAmount() <= 0 || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)(output = new FluidStack(this.tanks[j].getFluid(), Math.min(this.tanks[j].getFluidAmount(), this.amountOutput))), (boolean)true)) <= 0) continue;
                this.tanks[j].drain(toDrain, true);
                this.outputTracker = side;
                continue block0;
            }
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiFluidBuffer(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTEBase(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank(int tankIndex) {
        return this.tanks[tankIndex % this.tanks.length];
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.amountInput = MathHelper.clamp((int)nbt.func_74762_e("AmountIn"), (int)0, (int)8000);
        this.amountOutput = MathHelper.clamp((int)nbt.func_74762_e("AmountOut"), (int)0, (int)8000);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt.func_74775_l("Tank" + i));
            this.locks[i] = this.tanks[i].isLocked();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74768_a("AmountIn", this.amountInput);
        nbt.func_74768_a("AmountOut", this.amountOutput);
        for (int i = 0; i < this.tanks.length; ++i) {
            nbt.func_74782_a("Tank" + i, (NBTBase)this.tanks[i].writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    public PacketBase getModePacket() {
        PacketBase payload = super.getModePacket();
        payload.addInt(MathHelper.clamp((int)this.amountInput, (int)0, (int)8000));
        payload.addInt(MathHelper.clamp((int)this.amountOutput, (int)0, (int)8000));
        for (boolean lock : this.locks) {
            payload.addBool(lock);
        }
        return payload;
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
        this.amountInput = payload.getInt();
        this.amountOutput = payload.getInt();
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = payload.getBool();
            if (this.locks[i]) {
                this.tanks[i].setLocked();
                continue;
            }
            this.tanks[i].clearLocked();
        }
    }

    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addInt(this.amountInput);
        payload.addInt(this.amountOutput);
        for (FluidTankCore tank : this.tanks) {
            payload.addFluidStack(tank.getFluid());
        }
        for (boolean lock : this.locks) {
            payload.addBool(lock);
        }
        return payload;
    }

    @Override
    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addInt(this.amountInput);
        payload.addInt(this.amountOutput);
        return payload;
    }

    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.amountInput = payload.getInt();
        this.amountOutput = payload.getInt();
        for (FluidTankCore tank : this.tanks) {
            tank.setFluid(payload.getFluidStack());
        }
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = payload.getBool();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.amountInput = payload.getInt();
        this.amountOutput = payload.getInt();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankProperties[] properties = new FluidTankProperties[TileFluidBuffer.this.tanks.length];
                    for (int i = 0; i < TileFluidBuffer.this.tanks.length; ++i) {
                        FluidTankInfo info = TileFluidBuffer.this.tanks[i].getInfo();
                        properties[i] = new FluidTankProperties(info.fluid, info.capacity);
                    }
                    return properties;
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from == null || TileFluidBuffer.this.allowInsertion(((TileFluidBuffer)TileFluidBuffer.this).sideConfig.sideTypes[TileFluidBuffer.this.sideCache[from.ordinal()]])) {
                        if (resource == null) {
                            return 0;
                        }
                        for (int j = 0; j < TileFluidBuffer.this.tanks.length && TileFluidBuffer.this.tanks[j].getSpace() > 0; ++j) {
                            int toFill = TileFluidBuffer.this.tanks[j].fill(resource, doFill);
                            if (toFill <= 0) continue;
                            return toFill;
                        }
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null || TileFluidBuffer.this.allowExtraction(((TileFluidBuffer)TileFluidBuffer.this).sideConfig.sideTypes[TileFluidBuffer.this.sideCache[from.ordinal()]])) {
                        if (resource == null) {
                            return null;
                        }
                        for (int j = TileFluidBuffer.this.tanks.length - 1; j >= 0 && TileFluidBuffer.this.tanks[j].getFluidAmount() > 0; --j) {
                            FluidStack toDrain = TileFluidBuffer.this.tanks[j].drain(resource, doDrain);
                            if (toDrain == null) continue;
                            return toDrain;
                        }
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null || TileFluidBuffer.this.allowExtraction(((TileFluidBuffer)TileFluidBuffer.this).sideConfig.sideTypes[TileFluidBuffer.this.sideCache[from.ordinal()]])) {
                        if (maxDrain <= 0) {
                            return null;
                        }
                        for (int j = TileFluidBuffer.this.tanks.length - 1; j >= 0 && TileFluidBuffer.this.tanks[j].getFluidAmount() > 0; --j) {
                            FluidStack toDrain = TileFluidBuffer.this.tanks[j].drain(maxDrain, doDrain);
                            if (toDrain == null) continue;
                            return toDrain;
                        }
                    }
                    return null;
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

