/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import cofh.api.core.IAccelerable;
import cofh.api.item.IAugmentItem;
import cofh.api.item.IUpgradeItem;
import cofh.api.tileentity.IEnergyInfo;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.ISteamInfo;
import cofh.core.fluid.FluidTankCore;
import cofh.core.init.CoreProps;
import cofh.core.network.PacketBase;
import cofh.core.render.TextureHelper;
import cofh.core.util.TimeTracker;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.redstoneflux.impl.EnergyStorage;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileInventory;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalfoundation.init.TFFluids;
import java.util.HashSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileDynamoBase
extends TileInventory
implements ITickable,
IAccelerable,
IEnergyProvider,
IReconfigurableFacing,
ISidedInventory,
IEnergyInfo,
ISteamInfo {
    protected static final TileTEBase.EnergyConfig[] ENERGY_CONFIGS = new TileTEBase.EnergyConfig[BlockDynamo.Type.values().length];
    protected static final HashSet<String>[] VALID_AUGMENTS = new HashSet[BlockDynamo.Type.values().length];
    public static final int MIN_BASE_POWER = 10;
    public static final int MAX_BASE_POWER = 200;
    public static int[] POWER_SCALING = new int[]{100, 150, 200, 250, 300};
    public static int[] CUSTOM_POWER_SCALING = new int[]{100, 150, 250, 400, 600};
    protected static boolean enableCreative = false;
    protected static boolean enableSecurity = true;
    protected static boolean customScaling = false;
    protected static boolean smallStorage = false;
    protected static final HashSet<String> VALID_AUGMENTS_BASE = new HashSet();
    protected static final int ENERGY_BASE = 100;
    protected static final int POWER_BASE = 100;
    public static final int[] COIL_LIGHT = new int[]{7, 0};
    public static final boolean[] COIL_UNDERLAY = new boolean[]{false, true};
    byte facing = 1;
    int fuelRF;
    int maxFuelRF;
    boolean hasModeAugment;
    int compareTracker;
    boolean cached = false;
    IEnergyReceiver adjacentReceiver = null;
    boolean adjacentHandler = false;
    EnergyStorage energyStorage;
    TileTEBase.EnergyConfig energyConfig;
    TimeTracker tracker = new TimeTracker();
    protected boolean augmentCoilDuct;
    protected boolean augmentThrottle;
    protected boolean augmentBoiler;
    protected int renderCoil = 0;
    protected int lastEnergy;
    int energyMod = 100;

    public static void config() {
        int i;
        String category = "Dynamo";
        String comment = "If TRUE, Dynamos are securable.";
        enableSecurity = ThermalExpansion.CONFIG.get(category, "Securable", enableSecurity, comment);
        comment = "If TRUE, 'Classic' Crafting is enabled - Non-Creative Upgrade Kits WILL NOT WORK in a Crafting Grid.";
        BlockDynamo.enableClassicRecipes = ThermalExpansion.CONFIG.get(category, "ClassicCrafting", BlockDynamo.enableClassicRecipes, comment);
        comment = "If TRUE, Dynamos can be upgraded in a Crafting Grid using Kits. If Classic Crafting is enabled, only the Creative Conversion Kit may be used in this fashion.";
        BlockDynamo.enableUpgradeKitCrafting = ThermalExpansion.CONFIG.get(category, "UpgradeKitCrafting", BlockDynamo.enableUpgradeKitCrafting, comment);
        comment = "If TRUE, Dynamo RF scaling will use a custom set of values rather than default behavior. The default custom configuration provides a reasonable alternate progression.";
        customScaling = ThermalExpansion.CONFIG.get(category, "CustomScaling", customScaling, comment);
        comment = "If TRUE, Dynamos will have much smaller internal energy (RF) storage. Generation speed will no longer scale with internal energy.";
        smallStorage = ThermalExpansion.CONFIG.get(category, "SmallStorage", smallStorage, comment);
        category = "Dynamo.CustomScaling";
        comment = "ADVANCED FEATURE - ONLY EDIT IF YOU KNOW WHAT YOU ARE DOING.\nValues are expressed as a percentage of Base Power; Base Scale Factor is 100 percent.\nValues will be checked for validity and rounded down to the nearest 10.";
        ThermalExpansion.CONFIG.getCategory(category).setComment(comment);
        boolean validScaling = true;
        for (i = 1; i <= 4; ++i) {
            TileDynamoBase.CUSTOM_POWER_SCALING[i] = ThermalExpansion.CONFIG.getConfiguration().getInt("Level" + i, category, CUSTOM_POWER_SCALING[i], 100 + 10 * i, 100 * ((i + 1) * (i + 1)), "Scale Factor for Level " + i + " Dynamos.");
        }
        for (i = 1; i < CUSTOM_POWER_SCALING.length; ++i) {
            int n = i;
            CUSTOM_POWER_SCALING[n] = CUSTOM_POWER_SCALING[n] / 10;
            int n2 = i;
            CUSTOM_POWER_SCALING[n2] = CUSTOM_POWER_SCALING[n2] * 10;
            if (CUSTOM_POWER_SCALING[i] > CUSTOM_POWER_SCALING[i - 1]) continue;
            validScaling = false;
        }
        if (customScaling) {
            if (!validScaling) {
                ThermalExpansion.LOG.error(category + " settings are invalid. They will not be used.");
            } else {
                System.arraycopy(CUSTOM_POWER_SCALING, 0, POWER_SCALING, 0, POWER_SCALING.length);
            }
        }
    }

    public TileDynamoBase() {
        this.energyConfig = ENERGY_CONFIGS[this.getType()].copy();
        this.energyStorage = new EnergyStorage(this.energyConfig.maxEnergy, this.energyConfig.maxPower * 2);
    }

    public String getTileName() {
        return "tile.thermalexpansion.dynamo." + BlockDynamo.Type.values()[this.getType()].func_176610_l() + ".name";
    }

    public int getComparatorInputOverride() {
        return this.compareTracker;
    }

    public int getLightValue() {
        return this.isActive ? COIL_LIGHT[this.getCoil()] : 0;
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    @Override
    public boolean canUpgrade(ItemStack upgrade) {
        if (!AugmentHelper.isUpgradeItem((ItemStack)upgrade)) {
            return false;
        }
        IUpgradeItem.UpgradeType uType = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeType(upgrade);
        byte uLevel = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeLevel(upgrade);
        switch (uType) {
            case INCREMENTAL: {
                if (uLevel != this.level + 1) break;
                return !BlockDynamo.enableClassicRecipes;
            }
            case FULL: {
                if (uLevel <= this.level) break;
                return !BlockDynamo.enableClassicRecipes;
            }
            case CREATIVE: {
                return !this.isCreative && enableCreative;
            }
        }
        return false;
    }

    public boolean smallStorage() {
        return smallStorage;
    }

    @Override
    protected boolean setLevel(int level) {
        if (super.setLevel(level)) {
            this.energyConfig.setDefaultParams(this.getBasePower(this.level), smallStorage);
            this.energyStorage.setCapacity(this.energyConfig.maxEnergy).setMaxTransfer(this.energyConfig.maxPower * 4);
            return true;
        }
        return false;
    }

    public boolean onWrench(EntityPlayer player, EnumFacing side) {
        return this.rotateBlock();
    }

    public void func_145843_s() {
        this.cached = false;
        super.func_145843_s();
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentHandlers();
    }

    public void onNeighborTileChange(BlockPos pos) {
        super.onNeighborTileChange(pos);
        this.updateAdjacentHandlers();
    }

    public final void setEnergyStored(int quantity) {
        this.energyStorage.setEnergyStored(quantity);
    }

    public void func_73660_a() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.processTick();
            if (this.canFinish()) {
                if (!this.redstoneControlOrDisable() || !this.canStart()) {
                    this.processOff();
                } else {
                    this.processStart();
                }
            }
        } else if (this.redstoneControlOrDisable() && this.timeCheck() && this.canStart()) {
            this.processStart();
            this.processTick();
            this.isActive = true;
        }
        if (this.timeCheck()) {
            int curScale;
            int n = curScale = this.energyStorage.getEnergyStored() > 0 ? 1 + this.getScaledEnergyStored(14) : 0;
            if (curScale != this.compareTracker) {
                this.compareTracker = curScale;
                this.callNeighborTileChange();
            }
            if (!this.cached) {
                this.updateAdjacentHandlers();
            }
            if (!this.isActive) {
                this.processIdle();
            }
        }
        this.updateIfChanged(curActive);
    }

    protected int getBasePower(int level) {
        return TileDynamoBase.ENERGY_CONFIGS[this.getType()].maxPower * POWER_SCALING[MathHelper.clamp((int)level, (int)0, (int)4)] / 100;
    }

    protected int calcEnergy() {
        if (this.energyStorage.getEnergyStored() <= this.energyConfig.minPowerLevel) {
            return this.energyConfig.maxPower;
        }
        if (this.energyStorage.getEnergyStored() > this.energyConfig.maxPowerLevel) {
            return this.energyConfig.minPower;
        }
        return (this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored()) / this.energyConfig.energyRamp;
    }

    protected int getScaledEnergyStored(int scale) {
        return this.energyStorage.getEnergyStored() * scale / this.energyStorage.getMaxEnergyStored();
    }

    protected abstract boolean canStart();

    protected boolean canFinish() {
        return this.fuelRF <= 0;
    }

    protected abstract void processStart();

    protected void processFinish() {
    }

    protected void processIdle() {
    }

    protected void processOff() {
        this.isActive = false;
        this.wasActive = true;
        this.tracker.markTime(this.field_145850_b);
    }

    protected int processTick() {
        this.lastEnergy = this.calcEnergy();
        this.energyStorage.modifyEnergyStored(this.lastEnergy);
        this.fuelRF -= this.lastEnergy;
        this.transferEnergy();
        return this.lastEnergy;
    }

    protected void transferSteam() {
        FluidHelper.insertFluidIntoAdjacentFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)EnumFacing.values()[this.facing], (FluidStack)new FluidStack(TFFluids.fluidSteam, this.energyConfig.maxPower), (boolean)true);
    }

    protected void transferEnergy() {
        if (this.adjacentReceiver == null) {
            if (this.adjacentHandler) {
                this.energyStorage.modifyEnergyStored(-EnergyHelper.insertEnergyIntoAdjacentEnergyReceiver((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[this.facing], (int)Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored()), (boolean)false));
            }
            return;
        }
        this.energyStorage.modifyEnergyStored(-this.adjacentReceiver.receiveEnergy(EnumFacing.field_82609_l[this.facing ^ 1], Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored()), false));
    }

    protected void updateAdjacentHandlers() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)this.facing);
        if (EnergyHelper.isEnergyReceiverFromSide((TileEntity)tile, (EnumFacing)EnumFacing.field_82609_l[this.facing ^ 1])) {
            this.adjacentReceiver = (IEnergyReceiver)tile;
            this.adjacentHandler = false;
        } else if (EnergyHelper.isEnergyHandler((TileEntity)tile, (EnumFacing)EnumFacing.field_82609_l[this.facing ^ 1])) {
            this.adjacentReceiver = null;
            this.adjacentHandler = true;
        } else {
            this.adjacentReceiver = null;
            this.adjacentHandler = false;
        }
        this.cached = true;
    }

    protected void updateIfChanged(boolean curActive) {
        if (curActive != this.isActive && !this.wasActive) {
            this.updateLighting();
            this.sendTilePacket(Side.CLIENT);
        } else if (this.wasActive && this.tracker.hasDelayPassed(this.field_145850_b, 160)) {
            this.wasActive = false;
            this.updateLighting();
            this.sendTilePacket(Side.CLIENT);
        }
    }

    public int getCoil() {
        return this.augmentBoiler ? 1 : 0;
    }

    public TextureAtlasSprite getCoilUnderlayTexture() {
        return TextureHelper.getTexture((ResourceLocation)TFFluids.fluidSteam.getStill());
    }

    public TextureAtlasSprite getBaseUnderlayTexture() {
        return TextureHelper.getTexture((ResourceLocation)FluidRegistry.WATER.getStill());
    }

    public int getScaledDuration(int scale) {
        return 0;
    }

    public cofh.redstoneflux.api.IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public FluidTankCore getTank(int tankIndex) {
        return null;
    }

    public boolean showEnergyTab() {
        return !this.augmentBoiler;
    }

    public boolean showSteamTab() {
        return this.augmentBoiler;
    }

    public boolean isSteamProducer() {
        return this.augmentBoiler;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStorage.readFromNBT(nbt);
        this.facing = (byte)(nbt.func_74771_c("Facing") % 6);
        this.fuelRF = nbt.func_74762_e("Fuel");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.energyStorage.writeToNBT(nbt);
        nbt.func_74774_a("Facing", this.facing);
        nbt.func_74768_a("Fuel", this.fuelRF);
        return nbt;
    }

    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addInt(this.energyStorage.getMaxEnergyStored());
        payload.addInt(this.energyStorage.getEnergyStored());
        payload.addInt(this.fuelRF);
        payload.addInt(this.lastEnergy);
        payload.addBool(this.augmentBoiler);
        return payload;
    }

    @Override
    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addByte(this.facing);
        payload.addBool(this.hasRedstoneControl);
        payload.addBool(this.augmentBoiler);
        return payload;
    }

    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.energyStorage.setCapacity(payload.getInt());
        this.energyStorage.setEnergyStored(payload.getInt());
        this.fuelRF = payload.getInt();
        this.lastEnergy = payload.getInt();
        this.augmentBoiler = payload.getBool();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.facing = payload.getByte();
        this.hasRedstoneControl = payload.getBool();
        this.augmentBoiler = payload.getBool();
    }

    @Override
    protected void preAugmentInstall() {
        this.energyConfig.setDefaultParams(this.getBasePower(this.level), smallStorage);
        this.energyMod = 100;
        this.hasModeAugment = false;
        this.augmentThrottle = false;
        this.augmentCoilDuct = false;
        this.augmentBoiler = false;
        this.renderCoil = this.getCoil();
    }

    @Override
    protected void postAugmentInstall() {
        if (this.augmentThrottle) {
            this.energyConfig.minPower = 0;
        }
        this.energyStorage.setCapacity(this.energyConfig.maxEnergy).setMaxTransfer(this.energyConfig.maxPower * 4);
        if (this.field_145850_b != null && ServerHelper.isServerWorld((World)this.field_145850_b) && this.renderCoil != this.getCoil()) {
            this.sendTilePacket(Side.CLIENT);
        }
    }

    @Override
    protected boolean isValidAugment(IAugmentItem.AugmentType type, String id) {
        if (type == IAugmentItem.AugmentType.CREATIVE && !this.isCreative) {
            return false;
        }
        if (type == IAugmentItem.AugmentType.MODE && this.hasModeAugment) {
            return false;
        }
        if (this.augmentCoilDuct && "dynamoCoilDuct".equals(id)) {
            return false;
        }
        if (this.augmentThrottle && "dynamoThrottle".equals(id)) {
            return false;
        }
        return VALID_AUGMENTS_BASE.contains(id) || VALID_AUGMENTS[this.getType()].contains(id) || super.isValidAugment(type, id);
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if ("dynamoPower".equals(id)) {
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + this.getBasePower(this.level), smallStorage);
            return true;
        }
        if ("dynamoEfficiency".equals(id)) {
            this.energyMod += 15;
            return true;
        }
        if (!this.augmentCoilDuct && "dynamoCoilDuct".equals(id)) {
            this.augmentCoilDuct = true;
            return true;
        }
        if (!this.augmentThrottle && "dynamoThrottle".equals(id)) {
            this.augmentThrottle = true;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public int updateAccelerable() {
        if (!this.isActive || this.canFinish()) {
            return 0;
        }
        return this.processTick();
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return from.ordinal() != this.facing ? 0 : this.energyStorage.extractEnergy(Math.min(this.energyConfig.maxPower * 2, maxExtract), simulate);
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int getInfoEnergyPerTick() {
        if (!this.isActive) {
            return 0;
        }
        return this.lastEnergy;
    }

    public int getInfoMaxEnergyPerTick() {
        return this.energyConfig.maxPower;
    }

    public int getInfoEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getInfoSteamPerTick() {
        if (!this.isActive) {
            return 0;
        }
        return this.augmentBoiler ? this.energyConfig.maxPower : this.lastEnergy;
    }

    public int getInfoMaxSteamPerTick() {
        return this.energyConfig.maxPower;
    }

    @Override
    public String getDataType() {
        return "tile.thermalexpansion.dynamo";
    }

    public int getFacing() {
        return this.facing;
    }

    public boolean allowYAxisFacing() {
        return true;
    }

    public boolean rotateBlock() {
        if (this.field_145850_b.func_72872_a(Entity.class, this.func_145838_q().func_185496_a(this.field_145850_b.func_180495_p(this.field_174879_c), (IBlockAccess)this.field_145850_b, this.field_174879_c)).size() != 0) {
            return false;
        }
        this.facing = (byte)(this.facing + 1);
        this.facing = (byte)(this.facing % 6);
        this.updateAdjacentHandlers();
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(int side, boolean alternate) {
        if (alternate) {
            this.facing = (byte)(side ^ 1);
            this.markChunkDirty();
            this.sendTilePacket(Side.CLIENT);
        }
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return CoreProps.EMPTY_INVENTORY;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return (this.augmentCoilDuct || side.ordinal() != this.facing) && this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return this.augmentCoilDuct || side.ordinal() != this.facing;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityEnergy.ENERGY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)new IEnergyStorage(){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    return 0;
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    return TileDynamoBase.this.extractEnergy(from, maxExtract, simulate);
                }

                public int getEnergyStored() {
                    return TileDynamoBase.this.getEnergyStored(from);
                }

                public int getMaxEnergyStored() {
                    return TileDynamoBase.this.getMaxEnergyStored(from);
                }

                public boolean canExtract() {
                    return true;
                }

                public boolean canReceive() {
                    return false;
                }
            });
        }
        return super.getCapability(capability, from);
    }

    static {
        VALID_AUGMENTS_BASE.add("dynamoPower");
        VALID_AUGMENTS_BASE.add("dynamoEfficiency");
        VALID_AUGMENTS_BASE.add("dynamoCoilDuct");
        VALID_AUGMENTS_BASE.add("dynamoThrottle");
    }
}

