/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import cofh.core.init.CoreProps;
import cofh.core.network.PacketBase;
import cofh.core.render.TextureHelper;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoNumismatic;
import cofh.thermalexpansion.gui.container.dynamo.ContainerDynamoNumismatic;
import cofh.thermalexpansion.util.managers.dynamo.NumismaticManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileDynamoNumismatic
extends TileDynamoBase {
    private static final int TYPE = BlockDynamo.Type.NUMISMATIC.getMetadata();
    public static int basePower = 40;
    protected boolean augmentGem;

    public static void initialize() {
        TileDynamoNumismatic.VALID_AUGMENTS[TileDynamoNumismatic.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("dynamoNumismaticGem");
        GameRegistry.registerTileEntity(TileDynamoNumismatic.class, (String)"thermalexpansion:dynamo_numismatic");
        TileDynamoNumismatic.config();
    }

    public static void config() {
        String category = "Dynamo.Numismatic";
        BlockDynamo.enable[TileDynamoNumismatic.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy generation (in RF/t) for a Numismatic Dynamo. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        TileDynamoNumismatic.ENERGY_CONFIGS[TileDynamoNumismatic.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileDynamoNumismatic() {
        this.inventory = new ItemStack[1];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        if (this.augmentGem) {
            return NumismaticManager.getGemFuelEnergy(this.inventory[0]) > this.energyConfig.maxPower;
        }
        return NumismaticManager.getFuelEnergy(this.inventory[0]) > this.energyConfig.maxPower;
    }

    @Override
    protected void processStart() {
        this.maxFuelRF = this.augmentGem ? NumismaticManager.getGemFuelEnergy(this.inventory[0]) * this.energyMod / 100 : NumismaticManager.getFuelEnergy(this.inventory[0]) * this.energyMod / 100;
        this.fuelRF += this.maxFuelRF;
        this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
    }

    @Override
    public TextureAtlasSprite getBaseUnderlayTexture() {
        return TextureHelper.getTexture((ResourceLocation)TFFluids.fluidMana.getStill());
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiDynamoNumismatic(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerDynamoNumismatic(inventory, (TileEntity)this);
    }

    @Override
    public int getScaledDuration(int scale) {
        if (this.maxFuelRF <= 0) {
            this.maxFuelRF = Math.max(this.fuelRF, NumismaticManager.DEFAULT_ENERGY);
        }
        return this.fuelRF * scale / this.maxFuelRF;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.maxFuelRF = nbt.func_74762_e("FuelMax");
        if (this.maxFuelRF <= 0) {
            this.maxFuelRF = Math.max(this.fuelRF, NumismaticManager.DEFAULT_ENERGY);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("FuelMax", this.maxFuelRF);
        return nbt;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addInt(this.maxFuelRF);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.maxFuelRF = payload.getInt();
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentGem = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentGem && "dynamoNumismaticGem".equals(id)) {
            this.augmentGem = true;
            this.hasModeAugment = true;
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + 4 * this.getBasePower(this.level), smallStorage);
            this.energyMod += 25;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.augmentGem ? NumismaticManager.getGemFuelEnergy(stack) > 0 : NumismaticManager.getFuelEnergy(stack) > 0;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == null || side.ordinal() != this.facing || this.augmentCoilDuct ? CoreProps.SINGLE_INVENTORY : CoreProps.EMPTY_INVENTORY;
    }
}

