/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.api.item.IAugmentItem;
import cofh.core.fluid.FluidTankCore;
import cofh.core.gui.container.ICustomInventory;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiExtruder;
import cofh.thermalexpansion.gui.container.machine.ContainerExtruder;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.util.managers.machine.ExtruderManager;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileExtruder
extends TileMachineBase
implements ICustomInventory {
    private static final int TYPE = BlockMachine.Type.EXTRUDER.getMetadata();
    public static int basePower = 20;
    private ItemStack[] outputItem = new ItemStack[2];
    private int outputTracker;
    private int index = 0;
    private byte direction = 0;
    private FluidTankCore hotTank = new FluidTankCore(4000);
    private FluidTankCore coldTank = new FluidTankCore(4000);
    protected boolean augmentNoWater;
    protected boolean flagNoWater;

    public static void initialize() {
        TileExtruder.SIDE_CONFIGS[TileExtruder.TYPE] = new TileTEBase.SideConfig();
        TileExtruder.SIDE_CONFIGS[TileExtruder.TYPE].numConfig = 5;
        TileExtruder.SIDE_CONFIGS[TileExtruder.TYPE].slotGroups = new int[][]{new int[0], new int[0], {0}, {0}, {0}};
        TileExtruder.SIDE_CONFIGS[TileExtruder.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileExtruder.SIDE_CONFIGS[TileExtruder.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileExtruder.SLOT_CONFIGS[TileExtruder.TYPE] = new TileTEBase.SlotConfig();
        TileExtruder.SLOT_CONFIGS[TileExtruder.TYPE].allowInsertionSlot = new boolean[]{false, false};
        TileExtruder.SLOT_CONFIGS[TileExtruder.TYPE].allowExtractionSlot = new boolean[]{true, false};
        TileExtruder.VALID_AUGMENTS[TileExtruder.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineExtruderNoWater");
        TileExtruder.LIGHT_VALUES[TileExtruder.TYPE] = 14;
        GameRegistry.registerTileEntity(TileExtruder.class, (String)"thermalexpansion:machine_extruder");
        TileExtruder.config();
    }

    public static void config() {
        String category = "Machine.Extruder";
        BlockMachine.enable[TileExtruder.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for an Igneous Extruder. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        TileExtruder.ENERGY_CONFIGS[TileExtruder.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileExtruder() {
        this.inventory = new ItemStack[2];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.outputItem[0] = ExtruderManager.getOutput(this.index);
        this.outputItem[1] = this.outputItem[0].func_77946_l();
        this.hotTank.setLock(FluidRegistry.LAVA);
        this.coldTank.setLock(FluidRegistry.WATER);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected int getMaxInputSlot() {
        return -1;
    }

    @Override
    protected boolean canStart() {
        ExtruderManager.ExtruderRecipe recipe = ExtruderManager.getRecipe(this.outputItem[0]);
        if (recipe == null) {
            return false;
        }
        if (this.hotTank.getFluidAmount() < 1000) {
            return false;
        }
        if (!this.augmentNoWater && this.coldTank.getFluidAmount() < 1000) {
            return false;
        }
        if (this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        if (this.inventory[0].func_190926_b()) {
            return true;
        }
        if (!this.inventory[0].func_77969_a(this.outputItem[0])) {
            return false;
        }
        return this.inventory[0].func_190916_E() + this.outputItem[0].func_190916_E() <= this.outputItem[0].func_77976_d();
    }

    @Override
    protected boolean canFinish() {
        return this.processRem <= 0;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = ExtruderManager.getRecipe(this.outputItem[0]).getEnergy() * this.energyMod / 100;
        this.outputItem[1] = this.outputItem[0].func_77946_l();
    }

    @Override
    protected void processFinish() {
        ExtruderManager.ExtruderRecipe recipe = ExtruderManager.getRecipe(this.outputItem[1]);
        if (recipe == null) {
            this.processOff();
            return;
        }
        ItemStack output = recipe.getOutput();
        if (this.inventory[0].func_190926_b()) {
            this.inventory[0] = ItemHelper.cloneStack((ItemStack)output);
        } else {
            this.inventory[0].func_190917_f(output.func_190916_E());
        }
        this.hotTank.drain(recipe.getInputHot().amount, true);
        if (!this.augmentNoWater) {
            this.coldTank.drain(recipe.getInputCold().amount, true);
        }
        this.outputItem[1] = this.outputItem[0].func_77946_l();
    }

    @Override
    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        if (this.inventory[0].func_190926_b()) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.readPortableTagInternal(player, tag)) {
            return false;
        }
        if (tag.func_150297_b("OutputItem", 10)) {
            this.index = ExtruderManager.getIndex(new ItemStack(tag.func_74775_l("OutputItem")));
            this.outputItem[0] = ExtruderManager.getOutput(this.index);
            if (!this.isActive) {
                this.outputItem[1] = this.outputItem[0].func_77946_l();
            }
        }
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.writePortableTagInternal(player, tag)) {
            return false;
        }
        tag.func_74782_a("OutputItem", (NBTBase)this.outputItem[0].func_77955_b(new NBTTagCompound()));
        return true;
    }

    @Override
    protected void setLevelFlags() {
        super.setLevelFlags();
        this.hasAutoInput = false;
        this.enableAutoInput = false;
    }

    private void setOutput() {
        if (this.index >= ExtruderManager.getOutputListSize()) {
            this.index = 0;
        } else if (this.index < 0) {
            this.index = ExtruderManager.getOutputListSize() - 1;
        }
        this.outputItem[0] = ExtruderManager.getOutput(this.index);
        if (!this.isActive) {
            this.outputItem[1] = this.outputItem[0].func_77946_l();
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiExtruder(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerExtruder(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank(int tankIndex) {
        if (tankIndex == 0) {
            return this.hotTank;
        }
        return this.coldTank;
    }

    public FluidStack getTankFluid(int tankIndex) {
        if (tankIndex == 0) {
            return this.hotTank.getFluid();
        }
        return this.coldTank.getFluid();
    }

    public boolean augmentNoWater() {
        return this.augmentNoWater && this.flagNoWater;
    }

    public void setMode(byte direction) {
        this.direction = direction;
        this.sendModePacket();
        this.direction = 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.outputTracker = nbt.func_74762_e("TrackOut");
        if (nbt.func_150297_b("OutputItem", 10)) {
            this.index = ExtruderManager.getIndex(new ItemStack(nbt.func_74775_l("OutputItem")));
        }
        this.outputItem[0] = ExtruderManager.getOutput(this.index);
        this.outputItem[1] = this.outputItem[0].func_77946_l();
        this.hotTank.readFromNBT(nbt.func_74775_l("HotTank"));
        this.coldTank.readFromNBT(nbt.func_74775_l("ColdTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74782_a("OutputItem", (NBTBase)this.outputItem[0].func_77955_b(new NBTTagCompound()));
        nbt.func_74782_a("HotTank", (NBTBase)this.hotTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("ColdTank", (NBTBase)this.coldTank.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public PacketBase getModePacket() {
        PacketBase payload = super.getModePacket();
        payload.addByte(this.direction);
        return payload;
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
        this.direction = payload.getByte();
        this.index += this.direction;
        this.setOutput();
        this.direction = 0;
    }

    @Override
    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addBool(this.augmentNoWater);
        return payload;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addFluidStack(this.hotTank.getFluid());
        payload.addFluidStack(this.coldTank.getFluid());
        payload.addBool(this.augmentNoWater);
        return payload;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.flagNoWater = this.augmentNoWater = payload.getBool();
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.hotTank.setFluid(payload.getFluidStack());
        this.coldTank.setFluid(payload.getFluidStack());
        this.flagNoWater = this.augmentNoWater = payload.getBool();
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        if (this.field_145850_b != null && ServerHelper.isServerWorld((World)this.field_145850_b)) {
            this.flagNoWater = this.augmentNoWater;
        }
        this.augmentNoWater = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (!this.augmentNoWater && this.isActive && this.coldTank.getFluidAmount() < 1000) {
            this.processOff();
        }
        if (this.field_145850_b != null && ServerHelper.isServerWorld((World)this.field_145850_b) && this.flagNoWater != this.augmentNoWater) {
            this.sendTilePacket(Side.CLIENT);
        }
    }

    @Override
    protected boolean isValidAugment(IAugmentItem.AugmentType type, String id) {
        if (this.augmentNoWater && "machineExtruderNoWater".equals(id)) {
            return false;
        }
        return super.isValidAugment(type, id);
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentNoWater && "machineExtruderNoWater".equals(id)) {
            this.augmentNoWater = true;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public ItemStack[] getInventorySlots(int inventoryIndex) {
        return this.outputItem;
    }

    public int getSlotStackLimit(int slotIndex) {
        return 64;
    }

    public void onSlotUpdate(int slotIndex) {
        this.markChunkDirty();
    }

    @Override
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.MACHINE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.MACHINE_TOP;
            }
            return side != this.facing ? TETextures.MACHINE_SIDE : (this.isActive ? (this.augmentNoWater ? RenderHelper.getFluidTexture((Fluid)FluidRegistry.LAVA) : TETextures.MACHINE_ACTIVE_EXTRUDER_UNDERLAY) : TETextures.MACHINE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.isActive ? TETextures.MACHINE_ACTIVE[TYPE] : TETextures.MACHINE_FACE[TYPE]);
        }
        return TETextures.MACHINE_SIDE;
    }

    @Override
    public boolean hasFluidUnderlay() {
        return true;
    }

    @Override
    public FluidStack getRenderFluid() {
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo hotInfo = TileExtruder.this.hotTank.getInfo();
                    FluidTankInfo coldInfo = TileExtruder.this.coldTank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(hotInfo.fluid, hotInfo.capacity, true, false), new FluidTankProperties(coldInfo.fluid, coldInfo.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from == null || TileExtruder.this.allowInsertion(((TileExtruder)TileExtruder.this).sideConfig.sideTypes[TileExtruder.this.sideCache[from.ordinal()]])) {
                        int ret = TileExtruder.this.hotTank.fill(resource, doFill);
                        return ret > 0 ? ret : TileExtruder.this.coldTank.fill(resource, doFill);
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (TileExtruder.this.isActive) {
                        return null;
                    }
                    if (from == null || TileExtruder.this.allowExtraction(((TileExtruder)TileExtruder.this).sideConfig.sideTypes[TileExtruder.this.sideCache[from.ordinal()]])) {
                        FluidStack ret = TileExtruder.this.hotTank.drain(resource, doDrain);
                        return ret != null ? ret : TileExtruder.this.coldTank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (TileExtruder.this.isActive) {
                        return null;
                    }
                    if (from == null || TileExtruder.this.allowExtraction(((TileExtruder)TileExtruder.this).sideConfig.sideTypes[TileExtruder.this.sideCache[from.ordinal()]])) {
                        FluidStack ret = TileExtruder.this.hotTank.drain(maxDrain, doDrain);
                        return ret != null ? ret : TileExtruder.this.coldTank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

