/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import codechicken.lib.model.ModelRegistryHelper;
import cofh.core.init.CoreEnchantments;
import cofh.core.render.IModelRegister;
import cofh.core.util.helpers.RecipeHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.storage.ItemBlockStrongbox;
import cofh.thermalexpansion.block.storage.TileStrongbox;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.render.RenderStrongbox;
import cofh.thermalfoundation.item.ItemUpgrade;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockStrongbox
extends BlockTEBase
implements IModelRegister {
    public static boolean enable = true;
    public static boolean enableCreative = true;
    public static boolean enableSecurity = true;
    public static boolean enableClassicRecipes = false;
    public static boolean enableUpgradeKitCrafting = false;
    public static ItemStack[] strongbox;
    public static ItemStack strongboxCreative;
    public static ItemBlockStrongbox itemBlock;

    public BlockStrongbox() {
        super(Material.field_151573_f);
        this.func_149663_c("strongbox");
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (enable) {
            if (TEProps.creativeTabShowAllLevels) {
                for (int j = 0; j <= 4; ++j) {
                    items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this), j));
                }
            } else {
                items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this), TEProps.creativeTabLevel));
            }
            if (TEProps.creativeTabShowCreative) {
                items.add((Object)itemBlock.setCreativeTag(new ItemStack((Block)this)));
            }
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileStrongbox();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            TileStrongbox tile = (TileStrongbox)world.func_175625_s(pos);
            tile.isCreative = stack.func_77978_p().func_74767_n("Creative");
            tile.enchantHolding = (byte)EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
            tile.setLevel(stack.func_77978_p().func_74771_c("Level"));
            if (stack.func_77978_p().func_74764_b("Inventory")) {
                tile.readInventoryFromNBT(stack.func_77978_p());
            }
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public NBTTagCompound getItemStackTag(IBlockAccess world, BlockPos pos) {
        NBTTagCompound retTag = super.getItemStackTag(world, pos);
        TileStrongbox tile = (TileStrongbox)world.func_175625_s(pos);
        if (tile != null) {
            if (tile.enchantHolding > 0) {
                CoreEnchantments.addEnchantment((NBTTagCompound)retTag, (Enchantment)CoreEnchantments.holding, (int)tile.enchantHolding);
            }
            tile.writeInventoryToNBT(retTag);
        }
        return retTag;
    }

    public ArrayList<ItemStack> dismantleBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, boolean returnDrops) {
        NBTTagCompound retTag = this.getItemStackTag((IBlockAccess)world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileStrongbox) {
            TileStrongbox strongbox = (TileStrongbox)tile;
            strongbox.inventory = new ItemStack[strongbox.inventory.length];
            Arrays.fill(strongbox.inventory, ItemStack.field_190927_a);
        }
        return this.dismantleDelegate(retTag, world, pos, player, returnDrops, false);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelResourceLocation location = new ModelResourceLocation(this.getRegistryName(), "normal");
        ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)0, (ModelResourceLocation)location);
        ModelLoader.setCustomMeshDefinition((Item)itemBlock, stack -> location);
        ModelRegistryHelper.register((ModelResourceLocation)location, (IBakedModel)RenderStrongbox.INSTANCE);
    }

    public boolean initialize() {
        this.setRegistryName("strongbox");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        itemBlock = new ItemBlockStrongbox((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        TileStrongbox.initialize();
        ThermalExpansion.proxy.addIModelRegister(this);
        return true;
    }

    public boolean register() {
        strongbox = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            BlockStrongbox.strongbox[i] = itemBlock.setDefaultTag(new ItemStack((Block)this), i);
        }
        strongboxCreative = itemBlock.setCreativeTag(new ItemStack((Block)this));
        this.addRecipes();
        this.addUpgradeRecipes();
        this.addClassicRecipes();
        return true;
    }

    private void addRecipes() {
        if (enable) {
            RecipeHelper.addShapedRecipe((ItemStack)strongbox[0], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), "chestWood", Character.valueOf('I'), "ingotTin"});
        }
    }

    private void addUpgradeRecipes() {
        int j;
        if (!enableUpgradeKitCrafting || !enable) {
            return;
        }
        if (!enableClassicRecipes) {
            for (j = 0; j < 4; ++j) {
                RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)strongbox[j + 1], (Object[])new Object[]{strongbox[j], ItemUpgrade.upgradeIncremental[j]});
            }
            for (j = 1; j < 4; ++j) {
                for (int k = 0; k <= j; ++k) {
                    RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)strongbox[j + 1], (Object[])new Object[]{strongbox[k], ItemUpgrade.upgradeFull[j]});
                }
            }
        }
        for (j = 0; j < 5; ++j) {
            RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)strongboxCreative, (Object[])new Object[]{strongbox[j], ItemUpgrade.upgradeCreative});
        }
    }

    private void addClassicRecipes() {
        if (!enableClassicRecipes || !enable) {
            return;
        }
        RecipeHelper.addShapedRecipe((ItemStack)strongbox[1], (Object[])new Object[]{"YIY", "ICI", "YIY", Character.valueOf('C'), "chestWood", Character.valueOf('I'), "ingotTin", Character.valueOf('Y'), "ingotInvar"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)strongbox[1], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), strongbox[0], Character.valueOf('I'), "ingotInvar"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)strongbox[2], (Object[])new Object[]{"YIY", "ICI", "YIY", Character.valueOf('C'), strongbox[1], Character.valueOf('I'), "ingotElectrum", Character.valueOf('Y'), "blockGlassHardened"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)strongbox[3], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), strongbox[2], Character.valueOf('I'), "ingotSignalum"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)strongbox[4], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), strongbox[3], Character.valueOf('I'), "ingotEnderium"});
    }
}

