/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import cofh.api.item.IUpgradeItem;
import cofh.api.tileentity.IInventoryRetainer;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.ITileInfo;
import cofh.core.network.PacketBase;
import cofh.core.render.ISidedTexture;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileAugmentableSecure;
import cofh.thermalexpansion.block.storage.BlockCache;
import cofh.thermalexpansion.gui.client.storage.GuiCache;
import cofh.thermalexpansion.gui.container.storage.ContainerCache;
import cofh.thermalexpansion.init.TETextures;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileCache
extends TileAugmentableSecure
implements IReconfigurableFacing,
ISidedTexture,
ITileInfo,
IInventoryRetainer {
    public static final int CAPACITY_BASE = 20000;
    public static final int[] CAPACITY = new int[]{1, 4, 9, 16, 25};
    private int compareTracker;
    private int meterTracker;
    byte facing = (byte)3;
    public byte enchantHolding;
    boolean lock = false;
    private CacheItemHandler handler = new CacheItemHandler(this, TileCache.getCapacity(0, 0));

    public static void initialize() {
        GameRegistry.registerTileEntity(TileCache.class, (String)"thermalexpansion:storage_cache");
        TileCache.config();
    }

    public static void config() {
        String category = "Storage.Cache";
        String comment = "If TRUE, Caches are enabled.";
        BlockCache.enable = ThermalExpansion.CONFIG.get(category, "Enable", BlockCache.enable, comment);
        comment = "If TRUE, Caches may be turned into Creative versions using a Creative Conversion Kit.";
        BlockCache.enableCreative = ThermalExpansion.CONFIG.get(category, "Creative", BlockCache.enableCreative, comment);
        comment = "If TRUE, Caches are securable.";
        BlockCache.enableSecurity = ThermalExpansion.CONFIG.get(category, "Securable", BlockCache.enableSecurity, comment);
        comment = "If TRUE, 'Classic' Crafting is enabled - Non-Creative Upgrade Kits WILL NOT WORK in a Crafting Grid.";
        BlockCache.enableClassicRecipes = ThermalExpansion.CONFIG.get(category, "ClassicCrafting", BlockCache.enableClassicRecipes, comment);
        comment = "If TRUE, Caches can be upgraded in a Crafting Grid using Kits. If Classic Crafting is enabled, only the Creative Conversion Kit may be used in this fashion.";
        BlockCache.enableUpgradeKitCrafting = ThermalExpansion.CONFIG.get(category, "UpgradeKitCrafting", BlockCache.enableUpgradeKitCrafting, comment);
        int capacity = 20000;
        comment = "Adjust this value to change the amount of Items stored by a Basic Cache. This base value will scale with block level.";
        capacity = ThermalExpansion.CONFIG.getConfiguration().getInt("BaseCapacity", category, capacity, capacity / 5, capacity * 5, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i++;
            CAPACITY[n] = CAPACITY[n] * capacity;
        }
    }

    public String getTileName() {
        return "tile.thermalexpansion.storage.cache.name";
    }

    public int getType() {
        return 0;
    }

    public boolean onWrench(EntityPlayer player, EnumFacing side) {
        return this.rotateBlock();
    }

    public int getComparatorInputOverride() {
        return this.compareTracker;
    }

    @Override
    public boolean enableSecurity() {
        return BlockCache.enableSecurity;
    }

    @Override
    public boolean canUpgrade(ItemStack upgrade) {
        if (!AugmentHelper.isUpgradeItem((ItemStack)upgrade)) {
            return false;
        }
        IUpgradeItem.UpgradeType uType = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeType(upgrade);
        byte uLevel = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeLevel(upgrade);
        switch (uType) {
            case INCREMENTAL: {
                if (uLevel != this.level + 1) break;
                return !BlockCache.enableClassicRecipes;
            }
            case FULL: {
                if (uLevel <= this.level) break;
                return !BlockCache.enableClassicRecipes;
            }
            case CREATIVE: {
                return !this.isCreative && BlockCache.enableCreative;
            }
        }
        return false;
    }

    @Override
    protected boolean setLevel(int level) {
        if (super.setLevel(level)) {
            this.handler.setCapacity(TileCache.getCapacity(level, this.enchantHolding));
            return true;
        }
        return false;
    }

    @Override
    protected int getNumAugmentSlots(int level) {
        return 0;
    }

    public static int getCapacity(int level, int enchant) {
        return CAPACITY[MathHelper.clamp((int)level, (int)0, (int)4)] + CAPACITY[MathHelper.clamp((int)level, (int)0, (int)4)] * enchant / 2;
    }

    public CacheItemHandler getHandler() {
        return this.handler;
    }

    public ItemStack getStoredInstance() {
        return this.handler.storedInstance;
    }

    protected void updateTrackers() {
        int curScale;
        int n = curScale = this.getStoredCount() > 0 ? 1 + this.getScaledItemsStored(14) : 0;
        if (this.compareTracker != curScale) {
            this.compareTracker = curScale;
            this.callNeighborTileChange();
        }
        int n2 = curScale = this.getStoredCount() > 0 ? 1 + this.getScaledItemsStored(8) : 0;
        if (this.meterTracker != curScale) {
            this.meterTracker = curScale;
            this.sendTilePacket(Side.CLIENT);
        }
    }

    public void setLocked(boolean lock) {
        if (this.getStoredInstance().func_190926_b()) {
            lock = false;
        }
        this.lock = lock;
        this.handler.setLocked(lock);
        this.sendTilePacket(Side.CLIENT);
    }

    public boolean isLocked() {
        return this.lock;
    }

    public int getScaledItemsStored(int scale) {
        return MathHelper.round((double)((long)this.getStoredCount() * (long)scale / (long)TileCache.getCapacity(this.level, this.enchantHolding)));
    }

    public int getStoredCount() {
        return this.handler.storedStack.func_190916_E();
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        if (this.isCreative) {
            this.handler.setItem(ItemHelper.cloneStack((ItemStack)stack, (int)this.handler.getSlotLimit(0)));
            return stack;
        }
        return this.handler.insertItem(0, stack, simulate);
    }

    public ItemStack extractItem(int maxExtract, boolean simulate) {
        return this.handler.extractItem(0, maxExtract, this.isCreative || simulate);
    }

    public Object getConfigGuiClient(InventoryPlayer inventory) {
        return new GuiCache(inventory, (TileEntity)this);
    }

    public Object getConfigGuiServer(InventoryPlayer inventory) {
        return new ContainerCache(inventory, (TileEntity)this);
    }

    public boolean hasConfigGui() {
        return false;
    }

    public void toggleLock() {
        this.lock = !this.lock;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.enchantHolding = nbt.func_74771_c("EncHolding");
        super.func_145839_a(nbt);
        this.facing = nbt.func_74771_c("Facing");
        this.handler.readFromNBT(nbt);
        this.lock = this.handler.isLocked();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("EncHolding", this.enchantHolding);
        nbt.func_74774_a("Facing", this.facing);
        this.handler.writeToNBT(nbt);
        return nbt;
    }

    public PacketBase getModePacket() {
        PacketBase payload = super.getModePacket();
        payload.addBool(this.lock);
        return payload;
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
        this.setLocked(payload.getBool());
    }

    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.lock);
        payload.addInt(this.handler.capacity);
        return payload;
    }

    @Override
    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addByte(this.enchantHolding);
        payload.addByte(this.facing);
        payload.addBool(this.lock);
        payload.addItemStack(ItemHelper.cloneStack((ItemStack)this.getStoredInstance()));
        payload.addInt(this.handler.getCount());
        return payload;
    }

    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.lock = payload.getBool();
        this.handler.setCapacity(payload.getInt());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.enchantHolding = payload.getByte();
        this.facing = payload.getByte();
        this.lock = payload.getBool();
        this.handler.setItem(payload.getItemStack(), payload.getInt());
        this.callBlockUpdate();
    }

    public final int getFacing() {
        return this.facing;
    }

    public boolean allowYAxisFacing() {
        return false;
    }

    public boolean rotateBlock() {
        this.facing = BlockHelper.SIDE_LEFT[this.facing];
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(int side, boolean alternate) {
        if (side < 2 || side > 5) {
            return false;
        }
        this.facing = (byte)side;
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public int getNumPasses() {
        return 2;
    }

    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return this.isCreative ? TETextures.CACHE_BOTTOM_C : TETextures.CACHE_BOTTOM[this.level];
            }
            if (side == 1) {
                return this.isCreative ? TETextures.CACHE_TOP_C : TETextures.CACHE_TOP[this.level];
            }
            return side != this.facing ? (this.isCreative ? TETextures.CACHE_SIDE_C : TETextures.CACHE_SIDE[this.level]) : (this.isCreative ? TETextures.CACHE_FACE_C : TETextures.CACHE_FACE[this.level]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG_NONE : (this.isCreative ? TETextures.CACHE_METER_C : TETextures.CACHE_METER[MathHelper.clamp((int)(this.getStoredCount() > 0 ? 1 + this.getScaledItemsStored(8) : 0), (int)0, (int)8)]);
        }
        return this.isCreative ? TETextures.CACHE_SIDE_C : TETextures.CACHE_SIDE[this.level];
    }

    public void getTileInfo(List<ITextComponent> info, EnumFacing side, EntityPlayer player, boolean debug) {
        if (debug) {
            return;
        }
        if (!this.getStoredInstance().func_190926_b()) {
            info.add(new TextComponentTranslation("info.cofh.item", new Object[0]).func_150258_a(": " + StringHelper.getItemName((ItemStack)this.getStoredInstance())));
            info.add(new TextComponentTranslation("info.cofh.amount", new Object[0]).func_150258_a(": " + StringHelper.formatNumber((long)this.getStoredCount()) + "/" + StringHelper.formatNumber((long)TileCache.getCapacity(this.level, this.enchantHolding))));
            info.add((ITextComponent)new TextComponentTranslation(this.lock ? "info.cofh.locked" : "info.cofh.unlocked", new Object[0]));
        } else {
            info.add(new TextComponentTranslation("info.cofh.item", new Object[0]).func_150258_a(": ").func_150257_a((ITextComponent)new TextComponentTranslation("info.cofh.empty", new Object[0])));
        }
    }

    public boolean retainInventory() {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, from);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public static class CacheItemHandler
    implements IItemHandler {
        protected TileCache tile;
        protected ItemStack storedInstance = ItemStack.field_190927_a;
        protected ItemStack storedStack = ItemStack.field_190927_a;
        protected int capacity;
        protected boolean locked;

        CacheItemHandler(TileCache tile, int capacity) {
            this(tile, ItemStack.field_190927_a, capacity);
        }

        CacheItemHandler(TileCache tile, ItemStack stack, int capacity) {
            this.tile = tile;
            this.setItem(stack);
            this.capacity = capacity;
        }

        public CacheItemHandler readFromNBT(NBTTagCompound nbt) {
            this.locked = false;
            if (nbt.func_74764_b("Inventory")) {
                ItemStack[] inventory = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a};
                NBTTagList list = nbt.func_150295_c("Inventory", 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound tag = list.func_150305_b(i);
                    int slot = tag.func_74762_e("Slot");
                    if (slot < 0 || slot >= inventory.length) continue;
                    inventory[slot] = new ItemStack(tag);
                }
                if (!inventory[1].func_190926_b()) {
                    this.storedInstance = ItemHelper.cloneStack((ItemStack)inventory[1], (int)1);
                    int storedCount = nbt.func_74762_e("CacheCount");
                    storedCount += inventory[1].func_190916_E();
                    if (!inventory[0].func_190926_b()) {
                        storedCount += inventory[0].func_190916_E();
                    }
                    this.storedStack = ItemHelper.cloneStack((ItemStack)this.storedInstance, (int)storedCount);
                    this.locked = nbt.func_74767_n("Lock");
                }
            } else if (nbt.func_74764_b("Item")) {
                ItemStack stack = new ItemStack(nbt.func_74775_l("Item"));
                this.storedInstance = ItemHelper.cloneStack((ItemStack)stack, (int)1);
                int storedCount = nbt.func_74762_e("StoredCount");
                this.storedStack = ItemHelper.cloneStack((ItemStack)stack, (int)storedCount);
                this.locked = nbt.func_74767_n("Lock");
            }
            return this;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.func_74782_a("Item", (NBTBase)this.storedInstance.func_77955_b(new NBTTagCompound()));
            nbt.func_74768_a("StoredCount", this.storedStack.func_190916_E());
            nbt.func_74757_a("Lock", this.locked);
            return nbt;
        }

        public void setLocked(boolean lock) {
            if (lock) {
                this.setLocked();
            } else {
                this.clearLocked();
            }
        }

        public void setLocked() {
            if (this.locked || this.storedInstance.func_190926_b()) {
                return;
            }
            this.locked = true;
        }

        public void clearLocked() {
            this.locked = false;
            if (this.storedStack.func_190926_b()) {
                this.setItem(ItemStack.field_190927_a);
            }
        }

        public void setItem(ItemStack stack, int count) {
            this.storedInstance = ItemHelper.cloneStack((ItemStack)stack, (int)1);
            this.storedStack = ItemHelper.cloneStack((ItemStack)stack, (int)count);
        }

        public void setItem(ItemStack stack) {
            ItemStack curInstance = this.storedInstance.func_77946_l();
            this.storedInstance = ItemHelper.cloneStack((ItemStack)stack, (int)1);
            this.storedStack = stack;
            if (this.tile.field_145850_b != null) {
                this.tile.updateTrackers();
                if (!ItemHelper.itemsIdentical((ItemStack)curInstance, (ItemStack)this.storedInstance)) {
                    this.tile.markChunkDirty();
                }
            }
        }

        public void setCapacity(int capacity) {
            this.capacity = capacity;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public int getCount() {
            return this.storedStack.func_190916_E();
        }

        public int getSpace() {
            int ret = this.capacity - this.storedStack.func_190916_E();
            return ret < 0 ? 0 : ret;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.storedStack;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                return stack;
            }
            int toInsert = stack.func_190916_E();
            if (this.getSpace() < toInsert) {
                toInsert = this.getSpace();
            }
            ItemStack ret = ItemHelper.cloneStack((ItemStack)stack, (int)(stack.func_190916_E() - toInsert));
            if (this.storedInstance.func_190926_b()) {
                if (!simulate) {
                    this.setItem(ItemHelper.cloneStack((ItemStack)stack, (int)toInsert));
                }
                return ret;
            }
            if (!ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)this.storedInstance)) {
                return stack;
            }
            if (!simulate) {
                this.storedStack.func_190917_f(toInsert);
                this.tile.updateTrackers();
                this.tile.markChunkDirty();
            }
            return ret;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.storedStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            int toExtract = amount;
            if (this.storedStack.func_190916_E() < toExtract) {
                toExtract = this.storedStack.func_190916_E();
            }
            ItemStack ret = ItemHelper.cloneStack((ItemStack)this.storedStack, (int)toExtract);
            if (!(simulate |= this.tile.isCreative)) {
                this.storedStack.func_190918_g(toExtract);
                if (this.storedStack.func_190926_b() && !this.locked) {
                    this.setItem(ItemStack.field_190927_a);
                    this.tile.sendTilePacket(Side.CLIENT);
                }
                this.tile.updateTrackers();
                this.tile.markChunkDirty();
            }
            return ret;
        }

        public int getSlotLimit(int slot) {
            return this.capacity;
        }
    }
}

