/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.entity.projectile;

import cofh.core.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.item.ItemMorb;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class EntityMorb
extends EntityThrowable {
    private static DataParameter<Byte> TYPE = EntityDataManager.func_187226_a(EntityMorb.class, (DataSerializer)DataSerializers.field_187191_a);
    private static DataParameter<NBTTagCompound> ENTITY_DATA = EntityDataManager.func_187226_a(EntityMorb.class, (DataSerializer)DataSerializers.field_192734_n);
    protected static ItemStack blockCheck = new ItemStack(Blocks.field_150348_b);
    protected boolean drop = true;
    protected byte type = (byte)-1;
    protected NBTTagCompound entityData;

    public static void initialize(int id) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thermalexpansion:morb"), EntityMorb.class, (String)"morb", (int)id, (Object)ThermalExpansion.instance, (int)64, (int)10, (boolean)true);
    }

    public EntityMorb(World world) {
        super(world);
    }

    public EntityMorb(World world, EntityLivingBase thrower, byte type, NBTTagCompound entityData) {
        super(world, thrower);
        this.type = type;
        this.entityData = entityData;
        if (thrower instanceof EntityPlayer && ((EntityPlayer)thrower).field_71075_bZ.field_75098_d || entityData != null && entityData.func_74767_n("Generic")) {
            this.drop = false;
        }
        this.setManager();
    }

    public EntityMorb(World world, double x, double y, double z, byte type, NBTTagCompound entityData) {
        super(world, x, y, z);
        this.type = type;
        this.entityData = entityData;
        if (this.field_70192_c instanceof EntityPlayer && ((EntityPlayer)this.field_70192_c).field_71075_bZ.field_75098_d || entityData != null && entityData.func_74767_n("Generic")) {
            this.drop = false;
        }
        this.setManager();
    }

    private void setManager() {
        this.field_70180_af.func_187227_b(TYPE, (Object)this.type);
        this.field_70180_af.func_187227_b(ENTITY_DATA, (Object)this.entityData);
    }

    public int getType() {
        return this.type;
    }

    public NBTTagCompound getEntityData() {
        return this.entityData;
    }

    public void func_70030_z() {
        if (this.type < 0 && ServerHelper.isClientWorld((World)this.field_70170_p)) {
            this.type = (Byte)this.field_70180_af.func_187225_a(TYPE);
        }
        if ((this.entityData == null || !this.entityData.func_74764_b("id")) && ServerHelper.isClientWorld((World)this.field_70170_p)) {
            this.entityData = (NBTTagCompound)this.field_70180_af.func_187225_a(ENTITY_DATA);
        }
        super.func_70030_z();
    }

    protected void func_70184_a(RayTraceResult traceResult) {
        if (this.entityData == null || !this.entityData.func_74764_b("id")) {
            this.attemptCapture(traceResult);
        } else {
            this.attemptRelease(traceResult);
        }
    }

    private void attemptCapture(RayTraceResult traceResult) {
        BlockPos pos = new BlockPos(traceResult.field_72307_f);
        if (ServerHelper.isServerWorld((World)this.field_70170_p)) {
            boolean noAccess;
            boolean bl = noAccess = traceResult.field_178784_b != null && this.func_85052_h() instanceof EntityPlayer && !((EntityPlayer)this.func_85052_h()).func_175151_a(pos, traceResult.field_178784_b, blockCheck);
            if (traceResult.field_72308_g == null || EntityList.func_191301_a((Entity)traceResult.field_72308_g) == null || !ItemMorb.validMobs.contains(EntityList.func_191301_a((Entity)traceResult.field_72308_g).toString()) || noAccess) {
                ItemMorb.dropMorb(this.type, null, this.field_70170_p, pos);
                this.func_70106_y();
                return;
            }
            NBTTagCompound tag = traceResult.field_72308_g.serializeNBT();
            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.CLOUD, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5, 2, 0.0, 0.0, 0.0, 0.0, new int[]{0});
            ItemMorb.dropMorb(this.type, tag, this.field_70170_p, pos);
            traceResult.field_72308_g.func_70106_y();
            this.func_70106_y();
        }
    }

    private void attemptRelease(RayTraceResult traceResult) {
        BlockPos pos = new BlockPos(traceResult.field_72307_f);
        if (traceResult.field_72308_g != null) {
            pos = traceResult.field_72308_g.func_180425_c().func_177982_a(0, 1, 0);
            traceResult.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 0.0f);
        }
        if (ServerHelper.isServerWorld((World)this.field_70170_p)) {
            if (traceResult.field_178784_b != null && this.func_85052_h() instanceof EntityPlayer && !((EntityPlayer)this.func_85052_h()).func_175151_a(pos, traceResult.field_178784_b, blockCheck)) {
                ItemMorb.dropMorb(this.type, this.entityData, this.field_70170_p, pos);
                this.func_70106_y();
                return;
            }
            double x = traceResult.field_72307_f.field_72450_a;
            double y = traceResult.field_72307_f.field_72448_b;
            double z = traceResult.field_72307_f.field_72449_c;
            if (traceResult.field_178784_b != null) {
                x += (double)traceResult.field_178784_b.func_82601_c();
                z += (double)traceResult.field_178784_b.func_82599_e();
            }
            EntityMorb.spawnCreature(this.field_70170_p, this.entityData, x, y, z);
            if (this.drop && (this.field_70170_p.field_73012_v.nextInt(100) < 25 || this.type > 0)) {
                ItemMorb.dropMorb(this.type, null, this.field_70170_p, pos);
            }
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TYPE, (Object)this.type);
        this.field_70180_af.func_187214_a(ENTITY_DATA, (Object)new NBTTagCompound());
    }

    public NBTTagCompound getEntity() {
        return this.entityData;
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.drop = nbt.func_74767_n("Drop");
        this.type = nbt.func_74771_c("Type");
        this.entityData = nbt.func_74775_l("EntityData");
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("Drop", this.drop);
        nbt.func_74774_a("Type", this.type);
        nbt.func_74782_a("EntityData", (NBTBase)this.entityData);
    }

    public static Entity spawnCreature(World world, NBTTagCompound entityData, double x, double y, double z) {
        if (entityData.func_74767_n("Generic")) {
            ItemMonsterPlacer.func_77840_a((World)world, (ResourceLocation)new ResourceLocation(entityData.func_74779_i("id")), (double)x, (double)y, (double)z);
        } else {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)entityData, (World)world);
            if (entity == null) {
                return null;
            }
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            world.func_72838_d(entity);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70642_aH();
            }
        }
        return null;
    }
}

