/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.storage;

import cofh.api.core.ISecurable;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.gui.element.tab.TabInfo;
import cofh.core.gui.element.tab.TabSecurity;
import cofh.core.init.CoreProps;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.gui.container.storage.ContainerSatchel;
import cofh.thermalexpansion.item.ItemSatchel;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class GuiSatchel
extends GuiContainerCore {
    boolean isCreative;
    boolean isVoid;
    boolean secure;
    UUID playerName;
    int storageIndex;

    public GuiSatchel(InventoryPlayer inventory, ContainerSatchel container) {
        super((Container)container);
        this.isCreative = ItemSatchel.isCreative(container.getContainerStack());
        this.isVoid = ItemSatchel.isVoid(container.getContainerStack());
        this.secure = SecurityHelper.isSecure((ItemStack)container.getContainerStack());
        this.playerName = SecurityHelper.getID((EntityPlayer)inventory.field_70458_d);
        this.storageIndex = ItemSatchel.getStorageIndex(container.getContainerStack());
        this.texture = CoreProps.TEXTURE_STORAGE[this.storageIndex];
        this.name = container.getInventoryName();
        this.field_146291_p = false;
        this.field_146999_f = 14 + 18 * MathHelper.clamp((int)this.storageIndex, (int)9, (int)14);
        this.field_147000_g = 112 + 18 * MathHelper.clamp((int)this.storageIndex, (int)2, (int)9);
        if (this.isCreative) {
            this.generateInfo("tab.thermalexpansion.storage.satchel_c");
        } else if (this.isVoid) {
            this.generateInfo("tab.thermalexpansion.storage.satchel_v");
        } else {
            this.generateInfo("tab.thermalexpansion.storage.satchel");
        }
        if (container.getContainerStack().func_77956_u() && !ItemSatchel.hasHoldingEnchant(container.getContainerStack())) {
            this.myInfo = this.myInfo + "\n\n" + StringHelper.localize((String)"tab.thermalexpansion.storage.enchant");
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.myInfo.isEmpty()) {
            this.addTab((TabBase)new TabInfo((GuiContainerCore)this, this.myInfo));
        }
        if (ItemSatchel.enableSecurity && this.secure) {
            this.addTab((TabBase)new TabSecurity((GuiContainerCore)this, (ISecurable)this.field_147002_h, this.playerName));
        }
    }
}

