/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.item;

import cofh.api.core.IAugmentable;
import cofh.api.core.ISecurable;
import cofh.api.item.IAugmentItem;
import cofh.core.item.ItemMulti;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalfoundation.item.ItemFertilizer;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemAugment
extends ItemMulti
implements IInitializer,
IAugmentItem {
    private TIntObjectHashMap<AugmentEntry> augmentMap = new TIntObjectHashMap();
    public static ItemStack fluidStorage;
    public static ItemStack energyStorage;
    public static ItemStack enderReception;
    public static ItemStack enderTransmission;
    public static ItemStack machinePower;
    public static ItemStack machineSecondary;
    public static ItemStack machineSecondaryNull;
    public static ItemStack machineEssenceCrystals;
    public static ItemStack machineFurnaceFood;
    public static ItemStack machineFurnaceOre;
    public static ItemStack machineFurnacePyrolysis;
    public static ItemStack machinePulverizerGeode;
    public static ItemStack machinePulverizerPetrotheum;
    public static ItemStack machineSawmillTapper;
    public static ItemStack machineSmelterPyrotheum;
    public static ItemStack machineSmelterFlux;
    public static ItemStack machineInsolatorFertilizer;
    public static ItemStack machineInsolatorTree;
    public static ItemStack machineInsolatorMonoculture;
    public static ItemStack machineCompactorMint;
    public static ItemStack machineCompactorGear;
    public static ItemStack machineCrucibleLava;
    public static ItemStack machineCrucibleAlloy;
    public static ItemStack machineRefineryOil;
    public static ItemStack machineRefineryPotion;
    public static ItemStack machineChargerThroughput;
    public static ItemStack machineChargerRepair;
    public static ItemStack machineChargerWireless;
    public static ItemStack machineCentrifugeMobs;
    public static ItemStack machineCrafterInput;
    public static ItemStack machineCrafterTank;
    public static ItemStack machineBrewerReagent;
    public static ItemStack machineEnchanterEmpowered;
    public static ItemStack machineExtruderNoWater;
    public static ItemStack dynamoPower;
    public static ItemStack dynamoEfficiency;
    public static ItemStack dynamoCoilDuct;
    public static ItemStack dynamoThrottle;
    public static ItemStack dynamoBoiler;
    public static ItemStack dynamoSteamTurbine;
    public static ItemStack dynamoMagmaticCoolant;
    public static ItemStack dynamoCompressionCoolant;
    public static ItemStack dynamoCompressionFuel;
    public static ItemStack dynamoReactantElemental;
    public static ItemStack dynamoEnervationEnchant;
    public static ItemStack dynamoNumismaticGem;
    public static ItemStack apparatusDepth;
    public static ItemStack apparatusRadius;
    public static ItemStack apparatusBreakerFluid;
    public static ItemStack apparatusCollectorEntity;

    public ItemAugment() {
        super("thermalexpansion");
        this.func_77655_b("augment");
        this.func_77637_a(ThermalExpansion.tabItems);
    }

    public String func_77653_i(ItemStack stack) {
        return StringHelper.localize((String)"info.thermalexpansion.augment.0") + ": " + super.func_77653_i(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        IAugmentItem.AugmentType type = this.getAugmentType(stack);
        String id = this.getAugmentIdentifier(stack);
        if (id.isEmpty()) {
            return;
        }
        int i = 0;
        String line = "info.thermalexpansion.augment." + id + "." + i;
        while (StringHelper.canLocalize((String)line)) {
            tooltip.add(StringHelper.localize((String)line));
            line = "info.thermalexpansion.augment." + id + "." + ++i;
        }
        i = 0;
        line = "info.thermalexpansion.augment." + id + ".a." + i;
        while (StringHelper.canLocalize((String)line)) {
            tooltip.add("\u00a7a" + StringHelper.localize((String)line));
            line = "info.thermalexpansion.augment." + id + ".a." + ++i;
        }
        i = 0;
        line = "info.thermalexpansion.augment." + id + ".b." + i;
        while (StringHelper.canLocalize((String)line)) {
            tooltip.add("\u00a74" + StringHelper.localize((String)line));
            line = "info.thermalexpansion.augment." + id + ".b." + ++i;
        }
        i = 0;
        line = "info.thermalexpansion.augment." + id + ".c." + i;
        while (StringHelper.canLocalize((String)line)) {
            tooltip.add("\u00a7e" + StringHelper.localize((String)line));
            line = "info.thermalexpansion.augment." + id + ".c." + ++i;
        }
        switch (type) {
            case ADVANCED: {
                break;
            }
            case MODE: {
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.augment.noticeMode"));
                break;
            }
            case ENDER: {
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.augment.noticeEnder"));
                break;
            }
            case CREATIVE: {
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.augment.noticeCreative"));
                break;
            }
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!block.hasTileEntity(state)) {
            return EnumActionResult.PASS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISecurable && !((ISecurable)tile).canPlayerAccess(player)) {
            return EnumActionResult.PASS;
        }
        if (tile instanceof IAugmentable) {
            if (((IAugmentable)tile).getAugmentSlots().length <= 0) {
                return EnumActionResult.PASS;
            }
            if (ServerHelper.isServerWorld((World)world)) {
                if (((IAugmentable)tile).installAugment(stack)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187692_g, SoundCategory.PLAYERS, 0.4f, 0.8f);
                    ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.thermalfoundation.augment.install.success", new Object[0]));
                } else {
                    ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.thermalfoundation.augment.install.failure", new Object[0]));
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public IAugmentItem.AugmentType getAugmentType(ItemStack stack) {
        if (!this.augmentMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return IAugmentItem.AugmentType.CREATIVE;
        }
        return ((AugmentEntry)this.augmentMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).type;
    }

    public String getAugmentIdentifier(ItemStack stack) {
        if (!this.augmentMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return "";
        }
        return ((AugmentEntry)this.augmentMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).identifier;
    }

    public boolean initialize() {
        machinePower = this.addAugmentItem(128, "machinePower");
        machineSecondary = this.addAugmentItem(129, "machineSecondary");
        machineSecondaryNull = this.addAugmentItem(130, "machineSecondaryNull", IAugmentItem.AugmentType.ADVANCED);
        machineFurnaceFood = this.addAugmentItem(256, "machineFurnaceFood", IAugmentItem.AugmentType.MODE);
        machineFurnaceOre = this.addAugmentItem(257, "machineFurnaceOre", IAugmentItem.AugmentType.MODE);
        machineFurnacePyrolysis = this.addAugmentItem(258, "machineFurnacePyrolysis", IAugmentItem.AugmentType.MODE);
        machinePulverizerPetrotheum = this.addAugmentItem(273, "machinePulverizerPetrotheum", IAugmentItem.AugmentType.MODE);
        machineSawmillTapper = this.addAugmentItem(288, "machineSawmillTapper", IAugmentItem.AugmentType.MODE);
        machineSmelterFlux = this.addAugmentItem(303, "machineSmelterFlux");
        machineSmelterPyrotheum = this.addAugmentItem(304, "machineSmelterPyrotheum", IAugmentItem.AugmentType.MODE);
        machineInsolatorFertilizer = this.addAugmentItem(320, "machineInsolatorFertilizer");
        machineInsolatorTree = this.addAugmentItem(323, "machineInsolatorTree", IAugmentItem.AugmentType.ADVANCED);
        machineInsolatorMonoculture = this.addAugmentItem(324, "machineInsolatorMonoculture", IAugmentItem.AugmentType.MODE);
        machineCompactorMint = this.addAugmentItem(336, "machineCompactorMint", IAugmentItem.AugmentType.MODE);
        machineCompactorGear = this.addAugmentItem(337, "machineCompactorGear", IAugmentItem.AugmentType.MODE);
        machineCrucibleLava = this.addAugmentItem(352, "machineCrucibleLava", IAugmentItem.AugmentType.MODE);
        machineRefineryOil = this.addAugmentItem(368, "machineRefineryOil", IAugmentItem.AugmentType.MODE);
        machineRefineryPotion = this.addAugmentItem(369, "machineRefineryPotion", IAugmentItem.AugmentType.MODE);
        machineChargerThroughput = this.addAugmentItem(400, "machineChargerThroughput", IAugmentItem.AugmentType.MODE);
        machineChargerRepair = this.addAugmentItem(401, "machineChargerRepair", IAugmentItem.AugmentType.MODE);
        machineChargerWireless = this.addAugmentItem(402, "machineChargerWireless", IAugmentItem.AugmentType.MODE);
        machineCentrifugeMobs = this.addAugmentItem(416, "machineCentrifugeMobs", IAugmentItem.AugmentType.MODE);
        machineCrafterInput = this.addAugmentItem(432, "machineCrafterInput", IAugmentItem.AugmentType.ADVANCED);
        machineCrafterTank = this.addAugmentItem(433, "machineCrafterTank", IAugmentItem.AugmentType.ADVANCED);
        machineBrewerReagent = this.addAugmentItem(448, "machineBrewerReagent");
        machineExtruderNoWater = this.addAugmentItem(496, "machineExtruderNoWater", IAugmentItem.AugmentType.MODE);
        dynamoPower = this.addAugmentItem(512, "dynamoPower");
        dynamoEfficiency = this.addAugmentItem(513, "dynamoEfficiency");
        dynamoCoilDuct = this.addAugmentItem(514, "dynamoCoilDuct", IAugmentItem.AugmentType.ADVANCED);
        dynamoThrottle = this.addAugmentItem(515, "dynamoThrottle", IAugmentItem.AugmentType.ADVANCED);
        dynamoBoiler = this.addAugmentItem(576, "dynamoBoiler", IAugmentItem.AugmentType.MODE);
        dynamoSteamTurbine = this.addAugmentItem(640, "dynamoSteamTurbine", IAugmentItem.AugmentType.MODE);
        dynamoMagmaticCoolant = this.addAugmentItem(656, "dynamoMagmaticCoolant", IAugmentItem.AugmentType.MODE);
        dynamoCompressionCoolant = this.addAugmentItem(672, "dynamoCompressionCoolant", IAugmentItem.AugmentType.MODE);
        dynamoCompressionFuel = this.addAugmentItem(673, "dynamoCompressionFuel", IAugmentItem.AugmentType.MODE);
        dynamoReactantElemental = this.addAugmentItem(688, "dynamoReactantElemental", IAugmentItem.AugmentType.MODE);
        dynamoEnervationEnchant = this.addAugmentItem(704, "dynamoEnervationEnchant", IAugmentItem.AugmentType.MODE);
        dynamoNumismaticGem = this.addAugmentItem(720, "dynamoNumismaticGem", IAugmentItem.AugmentType.MODE);
        ThermalExpansion.proxy.addIModelRegister((IModelRegister)this);
        return true;
    }

    public boolean register() {
        RecipeHelper.addShapedRecipe((ItemStack)machinePower, (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), ItemMaterial.powerCoilGold, Character.valueOf('I'), "ingotGold"});
        RecipeHelper.addShapedRecipe((ItemStack)machineSecondary, (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('I'), "ingotBronze"});
        RecipeHelper.addShapedRecipe((ItemStack)machineSecondaryNull, (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), Items.field_151129_at, Character.valueOf('I'), "nuggetInvar"});
        RecipeHelper.addShapedRecipe((ItemStack)machineFurnaceFood, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearCopper", Character.valueOf('I'), "plateSilver", Character.valueOf('X'), Blocks.field_150336_V});
        RecipeHelper.addShapedRecipe((ItemStack)machineFurnaceOre, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearBronze", Character.valueOf('I'), "plateInvar", Character.valueOf('X'), "dustPyrotheum"});
        RecipeHelper.addShapedRecipe((ItemStack)machineFurnacePyrolysis, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearInvar", Character.valueOf('I'), "plateCopper", Character.valueOf('X'), Blocks.field_150385_bj});
        RecipeHelper.addShapedRecipe((ItemStack)machinePulverizerPetrotheum, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "plateBronze", Character.valueOf('X'), "dustPetrotheum"});
        RecipeHelper.addShapedRecipe((ItemStack)machineSawmillTapper, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearTin", Character.valueOf('I'), "plateCopper", Character.valueOf('X'), Items.field_151133_ar});
        RecipeHelper.addShapedRecipe((ItemStack)machineSmelterFlux, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearSilver", Character.valueOf('I'), ItemMaterial.crystalSlagRich, Character.valueOf('X'), "blockGlassHardened"});
        RecipeHelper.addShapedRecipe((ItemStack)machineSmelterPyrotheum, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "plateNickel", Character.valueOf('X'), "dustPyrotheum"});
        RecipeHelper.addShapedRecipe((ItemStack)machineInsolatorFertilizer, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearSilver", Character.valueOf('I'), ItemFertilizer.fertilizerRich, Character.valueOf('X'), "blockGlassHardened"});
        RecipeHelper.addShapedRecipe((ItemStack)machineInsolatorTree, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearInvar", Character.valueOf('I'), "plateLumium", Character.valueOf('X'), Blocks.field_150331_J});
        RecipeHelper.addShapedRecipe((ItemStack)machineInsolatorMonoculture, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "plateNickel", Character.valueOf('X'), ItemFertilizer.fertilizerFlux});
        RecipeHelper.addShapedRecipe((ItemStack)machineCompactorMint, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearInvar", Character.valueOf('I'), "plateElectrum", Character.valueOf('X'), "gemEmerald"});
        RecipeHelper.addShapedRecipe((ItemStack)machineCompactorGear, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearIron", Character.valueOf('I'), "plateLead", Character.valueOf('X'), Blocks.field_150331_J});
        RecipeHelper.addShapedRecipe((ItemStack)machineCrucibleLava, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearInvar", Character.valueOf('I'), Blocks.field_150331_J, Character.valueOf('X'), Blocks.field_150385_bj});
        RecipeHelper.addShapedRecipe((ItemStack)machineRefineryOil, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearConstantan", Character.valueOf('I'), "blockGlassHardened", Character.valueOf('X'), Items.field_151072_bj});
        RecipeHelper.addShapedRecipe((ItemStack)machineRefineryPotion, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "plateLead", Character.valueOf('X'), Items.field_151066_bu});
        RecipeHelper.addShapedRecipe((ItemStack)machineChargerThroughput, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearElectrum", Character.valueOf('I'), "plateSilver", Character.valueOf('X'), "ingotLead"});
        RecipeHelper.addShapedRecipe((ItemStack)machineChargerRepair, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearIron", Character.valueOf('I'), "blockGlassHardened", Character.valueOf('X'), "blockIron"});
        RecipeHelper.addShapedRecipe((ItemStack)machineChargerWireless, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearElectrum", Character.valueOf('I'), "plateSilver", Character.valueOf('X'), "blockGlassHardened"});
        RecipeHelper.addShapedRecipe((ItemStack)machineCentrifugeMobs, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearInvar", Character.valueOf('I'), Items.field_151048_u, Character.valueOf('X'), Blocks.field_150331_J});
        RecipeHelper.addShapedRecipe((ItemStack)machineCrafterInput, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearTin", Character.valueOf('I'), "ingotIron", Character.valueOf('X'), "blockGlass"});
        RecipeHelper.addShapedRecipe((ItemStack)machineCrafterTank, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), Items.field_151133_ar, Character.valueOf('I'), "ingotCopper", Character.valueOf('X'), "blockGlass"});
        RecipeHelper.addShapedRecipe((ItemStack)machineBrewerReagent, (Object[])new Object[]{" G ", "YCZ", " X ", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearSilver", Character.valueOf('X'), "blockGlass", Character.valueOf('Y'), "dustGlowstone", Character.valueOf('Z'), "dustRedstone"});
        RecipeHelper.addShapedRecipe((ItemStack)machineExtruderNoWater, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearCopper", Character.valueOf('I'), "plateInvar", Character.valueOf('X'), "dustCryotheum"});
        RecipeHelper.addShapedRecipe((ItemStack)dynamoPower, (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), ItemMaterial.powerCoilSilver, Character.valueOf('I'), "ingotSilver"});
        RecipeHelper.addShapedRecipe((ItemStack)dynamoEfficiency, (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('I'), "ingotLead"});
        RecipeHelper.addShapedRecipe((ItemStack)dynamoCoilDuct, (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "nuggetLead"});
        RecipeHelper.addShapedRecipe((ItemStack)dynamoThrottle, (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), "ingotElectrum", Character.valueOf('I'), "nuggetLead"});
        RecipeHelper.addShapedRecipe((ItemStack)dynamoBoiler, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), Items.field_151133_ar, Character.valueOf('G'), "gearIron", Character.valueOf('I'), "plateCopper", Character.valueOf('X'), "blockGlassHardened"});
        RecipeHelper.addShapedRecipe((ItemStack)dynamoSteamTurbine, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearIron", Character.valueOf('I'), "plateCopper", Character.valueOf('X'), "ingotIron"});
        RecipeHelper.addShapedRecipe((ItemStack)dynamoMagmaticCoolant, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "plateInvar", Character.valueOf('X'), "dustCryotheum"});
        RecipeHelper.addShapedRecipe((ItemStack)dynamoCompressionCoolant, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearInvar", Character.valueOf('I'), "plateTin", Character.valueOf('X'), "dustCryotheum"});
        RecipeHelper.addShapedRecipe((ItemStack)dynamoCompressionFuel, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "plateCopper", Character.valueOf('X'), "dustPyrotheum"});
        RecipeHelper.addShapedRecipe((ItemStack)dynamoReactantElemental, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "plateLead", Character.valueOf('X'), "dustAerotheum"});
        RecipeHelper.addShapedRecipe((ItemStack)dynamoEnervationEnchant, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "plateGold", Character.valueOf('X'), "gemLapis"});
        RecipeHelper.addShapedRecipe((ItemStack)dynamoNumismaticGem, (Object[])new Object[]{" G ", "ICI", " X ", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "plateElectrum", Character.valueOf('X'), "gemEmerald"});
        return true;
    }

    private void addAugmentEntry(int metadata, IAugmentItem.AugmentType type, String identifier) {
        this.augmentMap.put(metadata, (Object)new AugmentEntry(type, identifier));
    }

    private ItemStack addAugmentItem(int metadata, String name) {
        this.addAugmentEntry(metadata, IAugmentItem.AugmentType.BASIC, name);
        return this.addItem(metadata, name);
    }

    private ItemStack addAugmentItem(int metadata, String name, EnumRarity rarity) {
        this.addAugmentEntry(metadata, IAugmentItem.AugmentType.BASIC, name);
        return this.addItem(metadata, name, rarity);
    }

    private ItemStack addAugmentItem(int metadata, String name, IAugmentItem.AugmentType type) {
        EnumRarity rarity;
        switch (type) {
            case ADVANCED: 
            case MODE: {
                rarity = EnumRarity.UNCOMMON;
                break;
            }
            case ENDER: {
                rarity = EnumRarity.RARE;
                break;
            }
            case CREATIVE: {
                rarity = EnumRarity.EPIC;
                break;
            }
            default: {
                rarity = EnumRarity.COMMON;
            }
        }
        return this.addAugmentItem(metadata, name, type, rarity);
    }

    private ItemStack addAugmentItem(int metadata, String name, IAugmentItem.AugmentType type, EnumRarity rarity) {
        this.addAugmentEntry(metadata, type, name);
        return this.addItem(metadata, name, rarity);
    }

    public class AugmentEntry {
        public final IAugmentItem.AugmentType type;
        public final String identifier;

        AugmentEntry(IAugmentItem.AugmentType type, String identifier) {
            this.type = type;
            this.identifier = identifier;
        }
    }
}

