/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.item;

import baubles.api.cap.IBaublesItemHandler;
import cofh.api.item.IMultiModeItem;
import cofh.api.item.INBTCopyIngredient;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.ItemMulti;
import cofh.core.item.ItemMultiRF;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.render.IModelRegister;
import cofh.core.util.CoreUtils;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.util.EnergyContainerItemWrapper;
import cofh.thermalexpansion.ThermalExpansion;
import com.google.common.collect.Iterables;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCapacitor
extends ItemMultiRF
implements IInitializer,
IMultiModeItem,
IEnergyContainerItem,
IEnchantableItem,
INBTCopyIngredient {
    @CapabilityInject(value=IBaublesItemHandler.class)
    private static Capability<IBaublesItemHandler> CAPABILITY_BAUBLES = null;
    private static TIntObjectHashMap<TypeEntry> typeMap = new TIntObjectHashMap();
    public static final int HELD_ITEMS = 0;
    public static final int WORN_ITEMS = 1;
    public static final int CAPACITY_BASE = 1000000;
    public static final int XFER_BASE = 1000;
    public static final int CREATIVE = 32000;
    public static final int[] CAPACITY = new int[]{1, 4, 9, 16, 25};
    public static final int[] RECV = new int[]{1, 4, 9, 16, 25};
    public static final int[] SEND = new int[]{1, 4, 9, 16, 25};
    public static final int SEND_CREATIVE = 250000;
    public static boolean enable = true;
    public static ItemStack capacitorBasic;
    public static ItemStack capacitorHardened;
    public static ItemStack capacitorReinforced;
    public static ItemStack capacitorSignalum;
    public static ItemStack capacitorResonant;
    public static ItemStack capacitorCreative;
    public static ItemStack capacitorPotato;

    public ItemCapacitor() {
        super("thermalexpansion");
        this.func_77655_b("capacitor");
        this.func_77637_a(ThermalExpansion.tabItems);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.a.0"));
        if (this.isActive(stack)) {
            tooltip.add(StringHelper.getNoticeText((String)("info.thermalexpansion.capacitor.d." + this.getMode(stack))));
            tooltip.add(StringHelper.getDeactivationText((String)"info.thermalexpansion.capacitor.c.1"));
        } else {
            tooltip.add(StringHelper.getActivationText((String)"info.thermalexpansion.capacitor.c.0"));
        }
        tooltip.add(StringHelper.localizeFormat((String)"info.thermalexpansion.capacitor.b.0", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        if (ItemHelper.getItemDamage((ItemStack)stack) == 32000) {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": 1.21G RF");
            tooltip.add(StringHelper.localize((String)"info.cofh.send") + ": " + StringHelper.formatNumber((long)this.getSend(stack)) + " RF/t");
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF");
            tooltip.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + StringHelper.formatNumber((long)this.getSend(stack)) + "/" + StringHelper.formatNumber((long)this.getReceive(stack)) + " RF/t");
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            Iterator iterator = this.itemList.iterator();
            while (iterator.hasNext()) {
                int metadata = (Integer)iterator.next();
                if (metadata != 32000) {
                    items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, metadata), (int)0));
                    items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, metadata), (int)this.getBaseCapacity(metadata)));
                    continue;
                }
                items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, metadata), (int)this.getBaseCapacity(metadata)));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        Iterable equipment;
        if (ServerHelper.isClientWorld((World)world) || CoreUtils.isFakePlayer((Entity)entity) || !this.isActive(stack)) {
            return;
        }
        switch (this.getMode(stack)) {
            case 0: {
                equipment = entity.func_184214_aD();
                break;
            }
            case 1: {
                equipment = Iterables.concat((Iterable)entity.func_184193_aE(), ItemCapacitor.getBaubles(entity));
                break;
            }
            default: {
                equipment = Iterables.concat((Iterable)entity.func_184209_aF(), ItemCapacitor.getBaubles(entity));
            }
        }
        for (ItemStack equipmentStack : equipment) {
            IEnergyStorage handler;
            if (equipmentStack.equals(stack)) continue;
            if (EnergyHelper.isEnergyContainerItem((ItemStack)equipmentStack)) {
                this.extractEnergy(stack, ((IEnergyContainerItem)equipmentStack.func_77973_b()).receiveEnergy(equipmentStack, Math.min(this.getEnergyStored(stack), this.getSend(stack)), false), false);
                continue;
            }
            if (!EnergyHelper.isEnergyHandler((ItemStack)equipmentStack) || (handler = EnergyHelper.getEnergyHandler((ItemStack)equipmentStack)) == null) continue;
            this.extractEnergy(stack, handler.receiveEnergy(Math.min(this.getEnergyStored(stack), this.getSend(stack)), false), false);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0);
    }

    public int getItemEnchantability(ItemStack stack) {
        return 10;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (CoreUtils.isFakePlayer((Entity)player)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (player.func_70093_af() && this.setActiveState(stack, !this.isActive(stack))) {
            if (this.isActive(stack)) {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.8f);
            } else {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.5f);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.FAIL;
    }

    public boolean isActive(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("Active");
    }

    public boolean setActiveState(ItemStack stack, boolean state) {
        if (this.getEnergyStored(stack) > 0) {
            stack.func_77978_p().func_74757_a("Active", state);
            return true;
        }
        stack.func_77978_p().func_74757_a("Active", false);
        return false;
    }

    protected int getCapacity(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int capacity = ((TypeEntry)ItemCapacitor.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).capacity;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return capacity + capacity * enchant / 2;
    }

    protected int getReceive(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((TypeEntry)ItemCapacitor.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).recv;
    }

    public int getSend(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((TypeEntry)ItemCapacitor.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).send;
    }

    public int getBaseCapacity(int metadata) {
        if (!typeMap.containsKey(metadata)) {
            return 0;
        }
        return ((TypeEntry)ItemCapacitor.typeMap.get((int)metadata)).capacity;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> new ModelResourceLocation(this.getRegistryName(), String.format("mode=%s_%s,type=%s", this.getEnergyStored(stack) > 0 && this.isActive(stack) ? 1 : 0, this.getMode(stack), ((TypeEntry)ItemCapacitor.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).name)));
        for (Map.Entry entry : this.itemMap.entrySet()) {
            for (int active = 0; active < 2; ++active) {
                for (int mode = 0; mode < 3; ++mode) {
                    ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName(), String.format("mode=%s_%s,type=%s", active, mode, ((ItemMulti.ItemEntry)entry.getValue()).name))});
                }
            }
        }
    }

    public int getNumModes(ItemStack stack) {
        return 3;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 0.4f, (this.isActive(stack) ? 0.7f : 0.5f) + 0.1f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.thermalexpansion.capacitor.d." + this.getMode(stack), new Object[0]));
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        if (ItemHelper.getItemDamage((ItemStack)container) == 32000) {
            return maxExtract;
        }
        int stored = container.func_77978_p().func_74762_e("Energy");
        int extract = Math.min(maxExtract, Math.min(stored, this.getSend(container)));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this);
    }

    private static Iterable<ItemStack> getBaubles(Entity entity) {
        if (CAPABILITY_BAUBLES == null) {
            return Collections.emptyList();
        }
        IBaublesItemHandler handler = (IBaublesItemHandler)entity.getCapability(CAPABILITY_BAUBLES, null);
        if (handler == null) {
            return Collections.emptyList();
        }
        return IntStream.range(0, handler.getSlots()).mapToObj(arg_0 -> ((IBaublesItemHandler)handler).getStackInSlot(arg_0)).filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
    }

    public boolean initialize() {
        ItemCapacitor.config();
        capacitorBasic = this.addEntryItem(0, "standard0", EnumRarity.COMMON);
        capacitorHardened = this.addEntryItem(1, "standard1", EnumRarity.COMMON);
        capacitorReinforced = this.addEntryItem(2, "standard2", EnumRarity.UNCOMMON);
        capacitorSignalum = this.addEntryItem(3, "standard3", EnumRarity.UNCOMMON);
        capacitorResonant = this.addEntryItem(4, "standard4", EnumRarity.RARE);
        capacitorCreative = this.addEntryItem(32000, "creative", 250000, 0, CAPACITY[4], EnumRarity.EPIC);
        ThermalExpansion.proxy.addIModelRegister((IModelRegister)this);
        return true;
    }

    public boolean register() {
        if (!enable) {
            return false;
        }
        RecipeHelper.addShapedRecipe((ItemStack)capacitorBasic, (Object[])new Object[]{" R ", "IXI", "RYR", Character.valueOf('I'), "ingotLead", Character.valueOf('R'), "dustRedstone", Character.valueOf('X'), "ingotCopper", Character.valueOf('Y'), "dustSulfur"});
        return true;
    }

    private static void config() {
        String category = "Item.Capacitor";
        enable = ThermalExpansion.CONFIG.get(category, "Enable", true);
        int capacity = 1000000;
        String comment = "Adjust this value to change the amount of Energy (in RF) stored by a Basic Flux Capacitor. This base value will scale with item level.";
        capacity = ThermalExpansion.CONFIG.getConfiguration().getInt("BaseCapacity", category, capacity, capacity / 5, capacity * 5, comment);
        int recv = 2000;
        comment = "Adjust this value to change the amount of Energy (in RF/t) that can be received by a Basic Flux Capacitor. This base value will scale with item level.";
        recv = ThermalExpansion.CONFIG.getConfiguration().getInt("BaseReceive", category, recv, recv / 10, recv * 10, comment);
        int send = 1000;
        comment = "Adjust this value to change the amount of Energy (in RF/t) that can be sent by a Basic Flux Capacitor. This base value will scale with item level.";
        send = ThermalExpansion.CONFIG.getConfiguration().getInt("BaseSend", category, send, send / 10, send * 10, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i;
            CAPACITY[n] = CAPACITY[n] * capacity;
            int n2 = i;
            RECV[n2] = RECV[n2] * recv;
            int n3 = i++;
            SEND[n3] = SEND[n3] * send;
        }
    }

    private void addEntry(int metadata, String name, int send, int recv, int capacity) {
        typeMap.put(metadata, (Object)new TypeEntry(name, send, recv, capacity));
    }

    private ItemStack addEntryItem(int metadata, String name, EnumRarity rarity) {
        this.addEntry(metadata, name, SEND[metadata], RECV[metadata], CAPACITY[metadata]);
        return this.addItem(metadata, name, rarity);
    }

    private ItemStack addEntryItem(int metadata, String name, int send, int recv, int capacity, EnumRarity rarity) {
        this.addEntry(metadata, name, send, recv, capacity);
        return this.addItem(metadata, name, rarity);
    }

    public class TypeEntry {
        public final String name;
        public final int send;
        public final int recv;
        public final int capacity;

        TypeEntry(String name, int send, int recv, int capacity) {
            this.name = name;
            this.send = send;
            this.recv = recv;
            this.capacity = capacity;
        }
    }
}

