/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.core.util.ModPlugin;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.device.TapperManager;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;

public class PluginEvilCraft
extends ModPlugin {
    public static final String MOD_ID = "evilcraft";
    public static final String MOD_NAME = "EvilCraft";

    public PluginEvilCraft() {
        super(MOD_ID, MOD_NAME);
    }

    public boolean initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for EvilCraft is enabled.";
        boolean bl = this.enable = ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment) && Loader.isModLoaded((String)MOD_ID);
        if (!this.enable) {
            return false;
        }
        return !this.error;
    }

    public boolean register() {
        if (!this.enable) {
            return false;
        }
        try {
            ItemStack logUndead = this.getItemStack("undead_log", 1, 0);
            ItemStack saplingUndead = this.getItemStack("undead_sapling", 1, 0);
            Block blockLogUndead = this.getBlock("undead_log");
            Block blockLeavesUndead = this.getBlock("undead_leaves");
            Fluid fluidBlood = FluidRegistry.getFluid((String)"evilcraftblood");
            int energy = 2400;
            InsolatorManager.addDefaultTreeRecipe(energy * 2, saplingUndead, ItemHelper.cloneStack((ItemStack)logUndead, (int)6), new ItemStack((Block)Blocks.field_150330_I), 100);
            energy = 2400;
            if (fluidBlood != null) {
                TransposerManager.addExtractRecipe(energy, logUndead, this.getItemStack("hardened_blood_shard"), new FluidStack(fluidBlood, 100), 25, false);
            }
            if (fluidBlood != null) {
                TapperManager.addItemMapping(logUndead, new FluidStack(fluidBlood, 10));
                TapperManager.addBlockStateMapping(new ItemStack(blockLogUndead, 1, 1), new FluidStack(fluidBlood, 50));
                this.addLeafMapping(blockLogUndead, 1, blockLeavesUndead, 0);
            }
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: EvilCraft Plugin encountered an error:", t);
            this.error = true;
        }
        if (!this.error) {
            ThermalExpansion.LOG.info("Thermal Expansion: EvilCraft Plugin Enabled.");
        }
        return !this.error;
    }

    private void addLeafMapping(Block logBlock, int logMetadata, Block leafBlock, int leafMetadata) {
        IBlockState logState = logBlock.func_176203_a(logMetadata);
        for (Boolean check_decay : BlockLeaves.field_176236_b.func_177700_c()) {
            IBlockState leafState = leafBlock.func_176203_a(leafMetadata).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.TRUE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)check_decay);
            TapperManager.addLeafMapping(logState, leafState);
        }
    }
}

