/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.core.util.ModPlugin;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class PluginMysticalAgriculture
extends ModPlugin {
    public static final String MOD_ID = "mysticalagriculture";
    public static final String MOD_NAME = "Mystical Agriculture";
    public int secondaryChanceBase = 100;
    public int secondaryChanceRich = 105;
    public int secondaryChanceFlux = 110;

    public PluginMysticalAgriculture() {
        super(MOD_ID, MOD_NAME);
    }

    public boolean initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Mystical Agriculture is enabled.";
        this.enable = ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment) && Loader.isModLoaded((String)MOD_ID);
        ThermalExpansion.CONFIG.renameProperty(category, "BaseSecondaryChance", "Plugins.Mystical Agriculture", "BaseSecondaryChance", true);
        ThermalExpansion.CONFIG.renameProperty(category, "RichSecondaryChance", "Plugins.Mystical Agriculture", "RichSecondaryChance", true);
        ThermalExpansion.CONFIG.renameProperty(category, "FluxedSecondaryChance", "Plugins.Mystical Agriculture", "FluxedSecondaryChance", true);
        category = "Plugins.Mystical Agriculture";
        comment = "Secondary chance for seeds when using Phyto-Gro.";
        this.secondaryChanceBase = ThermalExpansion.CONFIG.getConfiguration().getInt("BaseSecondaryChance", category, this.secondaryChanceBase, 0, 150, comment);
        comment = "Secondary chance for seeds when using Rich Phyto-Gro.";
        this.secondaryChanceRich = ThermalExpansion.CONFIG.getConfiguration().getInt("RichSecondaryChance", category, this.secondaryChanceRich, 0, 150, comment);
        comment = "Secondary chance for seeds when using Fluxed Phyto-Gro.";
        this.secondaryChanceFlux = ThermalExpansion.CONFIG.getConfiguration().getInt("FluxedSecondaryChance", category, this.secondaryChanceFlux, 0, 150, comment);
        if (!this.enable) {
            return false;
        }
        return !this.error;
    }

    public boolean register() {
        if (!this.enable) {
            return false;
        }
        try {
            String[] names;
            for (String name : names = new String[]{"adamantine", "aluminum_brass", "aluminum", "amber", "apatite", "aquarium", "ardite", "basalt", "basalz", "blaze", "blitz", "blizz", "blue_topaz", "brass", "bronze", "certus_quartz", "chicken", "chimerite", "chrome", "coal", "cobalt", "cold_iron", "conductive_iron", "constantan", "copper", "cow", "creeper", "dark_steel", "desh", "diamond", "dirt", "draconium", "dye", "electrical_steel", "electrum", "emerald", "end", "ender_amethyst", "ender_biotite", "enderium", "enderman", "energetic_alloy", "experience", "fire", "fluix", "ghast", "glowstone_ingot", "glowstone", "gold", "guardian", "ice", "invar", "iridium", "iron", "knightslime", "lapis_lazuli", "lead", "limestone", "lumium", "malachite", "manasteel", "manyullyn", "marble", "meteoric_iron", "mithril", "moonstone", "mystical_flower", "nature", "nether_quartz", "nether", "nickel", "obsidian", "osmium", "peridot", "pig", "platinum", "pulsating_iron", "quartz_enriched_iron", "rabbit", "redstone_alloy", "redstone", "refined_obsidian", "rubber", "ruby", "saltpeter", "sapphire", "sheep", "signalum", "silicon", "silver", "skeleton", "slime", "soularium", "spider", "star_steel", "steel", "stone", "sulfur", "sunstone", "tanzanite", "terrasteel", "tin", "titanium", "topaz", "tungsten", "uranium", "vibrant_alloy", "vinteum", "water", "wither_skeleton", "wood", "yellorium", "zinc", "zombie"}) {
                ItemStack seeds = this.getSeeds(name);
                ItemStack essence = this.getEssence(name);
                InsolatorManager.addDefaultRecipe(4800, 1200, seeds, essence, seeds, this.secondaryChanceBase, this.secondaryChanceRich, this.secondaryChanceFlux, InsolatorManager.Type.STANDARD);
            }
            for (int i = 1; i <= 5; ++i) {
                ItemStack seeds = this.getSeeds("tier" + i + "_inferium");
                InsolatorManager.addDefaultRecipe(2400 * i, 2400, seeds, this.getItemStack("crafting", i, 0), seeds, this.secondaryChanceBase, this.secondaryChanceRich, this.secondaryChanceFlux, InsolatorManager.Type.STANDARD);
            }
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: Mystical Agriculture Plugin encountered an error:", t);
            this.error = true;
        }
        if (!this.error) {
            ThermalExpansion.LOG.info("Thermal Expansion: Mystical Agriculture Plugin Enabled.");
        }
        return !this.error;
    }

    protected ItemStack getSeeds(String name) {
        return this.getItemStack(this.modId, name + "_seeds", 1, 0);
    }

    protected ItemStack getEssence(String name) {
        return this.getItemStack(this.modId, name + "_essence", 1, 0);
    }
}

