/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.core.util.ModPlugin;
import cofh.core.util.helpers.ColorHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import cofh.thermalexpansion.util.managers.machine.PulverizerManager;
import cofh.thermalexpansion.util.managers.machine.SawmillManager;
import cofh.thermalexpansion.util.managers.machine.SmelterManager;
import cofh.thermalfoundation.item.ItemMaterial;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class PluginQuark
extends ModPlugin {
    public static final String MOD_ID = "quark";
    public static final String MOD_NAME = "Quark";

    public PluginQuark() {
        super(MOD_ID, MOD_NAME);
    }

    public boolean initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Quark is enabled.";
        boolean bl = this.enable = ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment) && Loader.isModLoaded((String)MOD_ID);
        if (!this.enable) {
            return false;
        }
        return !this.error;
    }

    public boolean register() {
        if (!this.enable) {
            return false;
        }
        try {
            int energy = 4000;
            PulverizerManager.addRecipe(energy, this.getItemStack("biotite_ore", 1), this.getItemStack("biotite", 3, 0), new ItemStack(Items.field_151079_bi), 5);
            PulverizerManager.addRecipe(energy, this.getItemStack("blaze_lantern", 1), new ItemStack(Items.field_151065_br, 16));
            PulverizerManager.addRecipe(energy, this.getItemStack("biome_cobblestone", 1, 0), new ItemStack(Blocks.field_150351_n), new ItemStack(Items.field_151065_br), 5);
            PulverizerManager.addRecipe(energy, this.getItemStack("biome_cobblestone", 1, 1), new ItemStack(Blocks.field_150351_n), ItemMaterial.dustBlizz, 5);
            energy = 3000;
            PulverizerManager.addRecipe(energy, this.getItemStack("soul_sandstone", 1), ItemHelper.cloneStack((Block)Blocks.field_150425_aM, (int)2), ItemMaterial.dustSulfur, 40);
            for (int i = 0; i < 2; ++i) {
                PulverizerManager.addRecipe(energy, this.getItemStack("biotite_block", 1, i), this.getItemStack("biotite", 4, 0));
                PulverizerManager.addRecipe(energy, this.getItemStack("sandstone_new", 1, i), new ItemStack((Block)Blocks.field_150354_m, 2), ItemMaterial.dustNiter, 40);
                PulverizerManager.addRecipe(energy, this.getItemStack("sandstone_new", 1, 2 + i), new ItemStack((Block)Blocks.field_150354_m, 2, 1), ItemMaterial.dustNiter, 40);
                PulverizerManager.addRecipe(energy, this.getItemStack("sandstone_new", 1, 4 + i), new ItemStack(Blocks.field_150425_aM, 2), ItemMaterial.dustSulfur, 40);
            }
            PulverizerManager.addRecipe(energy, this.getItemStack("soul_sandstone_stairs", 1), new ItemStack(Blocks.field_150425_aM, 2), ItemMaterial.dustSulfur, 20);
            PulverizerManager.addRecipe(energy, this.getItemStack("biotite_stairs", 1), this.getItemStack("biotite", 3, 0));
            PulverizerManager.addRecipe(energy, this.getItemStack("sandstone_bricks_stairs", 1), new ItemStack((Block)Blocks.field_150354_m, 2), ItemMaterial.dustNiter, 20);
            PulverizerManager.addRecipe(energy, this.getItemStack("red_sandstone_bricks_stairs", 1), new ItemStack((Block)Blocks.field_150354_m, 2, 1), ItemMaterial.dustNiter, 20);
            PulverizerManager.addRecipe(energy, this.getItemStack("soul_sandstone_bricks_stairs", 1), new ItemStack(Blocks.field_150425_aM, 2), ItemMaterial.dustSulfur, 20);
            PulverizerManager.addRecipe(energy / 2, this.getItemStack("soul_sandstone_slab", 1), new ItemStack(Blocks.field_150425_aM), ItemMaterial.dustSulfur, 20);
            PulverizerManager.addRecipe(energy / 2, this.getItemStack("biotite_slab", 1), this.getItemStack("biotite", 2, 0));
            PulverizerManager.addRecipe(energy / 2, this.getItemStack("sandstone_smooth_slab", 1), new ItemStack((Block)Blocks.field_150354_m), ItemMaterial.dustNiter, 20);
            PulverizerManager.addRecipe(energy / 2, this.getItemStack("sandstone_bricks_slab", 1), new ItemStack((Block)Blocks.field_150354_m), ItemMaterial.dustNiter, 20);
            PulverizerManager.addRecipe(energy / 2, this.getItemStack("red_sandstone_smooth_slab", 1), new ItemStack((Block)Blocks.field_150354_m, 1, 1), ItemMaterial.dustNiter, 20);
            PulverizerManager.addRecipe(energy / 2, this.getItemStack("red_sandstone_bricks_slab", 1), new ItemStack((Block)Blocks.field_150354_m, 1, 1), ItemMaterial.dustNiter, 20);
            PulverizerManager.addRecipe(energy / 2, this.getItemStack("soul_sandstone_smooth_slab", 1), new ItemStack(Blocks.field_150425_aM), ItemMaterial.dustSulfur, 20);
            PulverizerManager.addRecipe(energy / 2, this.getItemStack("soul_sandstone_bricks_slab", 1), new ItemStack(Blocks.field_150425_aM), ItemMaterial.dustSulfur, 20);
            int[] dyeChance = new int[ColorHelper.WOOL_COLOR_CONFIG.length];
            for (int i = 0; i < ColorHelper.WOOL_COLOR_CONFIG.length; ++i) {
                dyeChance[i] = 10;
            }
            dyeChance[EnumDyeColor.WHITE.func_176765_a()] = 0;
            dyeChance[EnumDyeColor.BROWN.func_176765_a()] = 0;
            dyeChance[EnumDyeColor.BLUE.func_176765_a()] = 0;
            dyeChance[EnumDyeColor.BLACK.func_176765_a()] = 0;
            ItemStack stringStack = ItemHelper.cloneStack((Item)Items.field_151007_F, (int)4);
            ItemStack brickStack = ItemHelper.cloneStack((Item)Items.field_151118_aC, (int)3);
            for (int i = 0; i < ColorHelper.WOOL_COLOR_CONFIG.length; ++i) {
                if (dyeChance[i] > 0) {
                    PulverizerManager.addRecipe(energy, this.getItemStack("quilted_wool", 1, i), stringStack, new ItemStack(Items.field_151100_aR, 1, 15 - i), dyeChance[i]);
                    PulverizerManager.addRecipe(energy / 2, this.getItemStack("colored_flowerpot_" + ColorHelper.WOOL_COLOR_CONFIG[i].toLowerCase(Locale.ENGLISH), 1), brickStack, new ItemStack(Items.field_151100_aR, 1, 15 - i), dyeChance[i]);
                    continue;
                }
                PulverizerManager.addRecipe(energy, this.getItemStack("quilted_wool", 1, i), stringStack);
                PulverizerManager.addRecipe(energy / 2, this.getItemStack("colored_flowerpot_" + ColorHelper.WOOL_COLOR_CONFIG[i].toLowerCase(Locale.ENGLISH), 1), brickStack);
            }
            energy = 2400;
            SawmillManager.addRecipe(energy, this.getItemStack("custom_chest", 1, 0), new ItemStack(Blocks.field_150344_f, 4, 1), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, this.getItemStack("custom_chest", 1, 1), new ItemStack(Blocks.field_150344_f, 4, 2), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, this.getItemStack("custom_chest", 1, 2), new ItemStack(Blocks.field_150344_f, 4, 3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, this.getItemStack("custom_chest", 1, 3), new ItemStack(Blocks.field_150344_f, 4, 4), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, this.getItemStack("custom_chest", 1, 4), new ItemStack(Blocks.field_150344_f, 4, 5), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, this.getItemStack("custom_chest_trap", 1, 0), new ItemStack(Blocks.field_150344_f, 4, 1), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, this.getItemStack("custom_chest_trap", 1, 1), new ItemStack(Blocks.field_150344_f, 4, 2), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, this.getItemStack("custom_chest_trap", 1, 2), new ItemStack(Blocks.field_150344_f, 4, 3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, this.getItemStack("custom_chest_trap", 1, 3), new ItemStack(Blocks.field_150344_f, 4, 4), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, this.getItemStack("custom_chest_trap", 1, 4), new ItemStack(Blocks.field_150344_f, 4, 5), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, this.getItemStack("custom_bookshelf", 1, 0), new ItemStack(Blocks.field_150344_f, 3, 1), new ItemStack(Items.field_151122_aG, 3), 25);
            SawmillManager.addRecipe(energy, this.getItemStack("custom_bookshelf", 1, 1), new ItemStack(Blocks.field_150344_f, 3, 2), new ItemStack(Items.field_151122_aG, 3), 25);
            SawmillManager.addRecipe(energy, this.getItemStack("custom_bookshelf", 1, 2), new ItemStack(Blocks.field_150344_f, 3, 3), new ItemStack(Items.field_151122_aG, 3), 25);
            SawmillManager.addRecipe(energy, this.getItemStack("custom_bookshelf", 1, 3), new ItemStack(Blocks.field_150344_f, 3, 4), new ItemStack(Items.field_151122_aG, 3), 25);
            SawmillManager.addRecipe(energy, this.getItemStack("custom_bookshelf", 1, 4), new ItemStack(Blocks.field_150344_f, 3, 5), new ItemStack(Items.field_151122_aG, 3), 25);
            SawmillManager.addRecipe(energy, this.getItemStack("spruce_trapdoor", 2), new ItemStack(Blocks.field_150344_f, 1, 1), ItemMaterial.dustWood, 75);
            SawmillManager.addRecipe(energy, this.getItemStack("birch_trapdoor", 2), new ItemStack(Blocks.field_150344_f, 1, 2), ItemMaterial.dustWood, 75);
            SawmillManager.addRecipe(energy, this.getItemStack("jungle_trapdoor", 2), new ItemStack(Blocks.field_150344_f, 1, 3), ItemMaterial.dustWood, 75);
            SawmillManager.addRecipe(energy, this.getItemStack("acacia_trapdoor", 2), new ItemStack(Blocks.field_150344_f, 1, 4), ItemMaterial.dustWood, 75);
            SawmillManager.addRecipe(energy, this.getItemStack("dark_oak_trapdoor", 2), new ItemStack(Blocks.field_150344_f, 1, 5), ItemMaterial.dustWood, 75);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_white_stairs", 2), this.getItemStack("stained_planks", 1, 0), ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_orange_stairs", 2), this.getItemStack("stained_planks", 1, 1), ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_magenta_stairs", 2), this.getItemStack("stained_planks", 1, 2), ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_light_blue_stairs", 2), this.getItemStack("stained_planks", 1, 3), ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_yellow_stairs", 2), this.getItemStack("stained_planks", 1, 4), ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_lime_stairs", 2), this.getItemStack("stained_planks", 1, 5), ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_pink_stairs", 2), this.getItemStack("stained_planks", 1, 6), ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_gray_stairs", 2), this.getItemStack("stained_planks", 1, 7), ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_silver_stairs", 2), this.getItemStack("stained_planks", 1, 8), ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_cyan_stairs", 2), this.getItemStack("stained_planks", 1, 9), ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_purple_stairs", 2), this.getItemStack("stained_planks", 1, 10), ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_blue_stairs", 2), this.getItemStack("stained_planks", 1, 11), ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_brown_stairs", 2), this.getItemStack("stained_planks", 1, 12), ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_green_stairs", 2), this.getItemStack("stained_planks", 1, 13), ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_red_stairs", 2), this.getItemStack("stained_planks", 1, 14), ItemMaterial.dustWood, 50);
            SawmillManager.addRecipe(energy, this.getItemStack("stained_planks_black_stairs", 2), this.getItemStack("stained_planks", 1, 15), ItemMaterial.dustWood, 50);
            energy = 1200;
            for (int i = 0; i < ColorHelper.WOOL_COLOR_CONFIG.length; ++i) {
                SawmillManager.addRecipe(energy, this.getItemStack("colored_item_frame", 1, i), new ItemStack(Items.field_151116_aA), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            }
            energy = 4000;
            SmelterManager.addRecycleRecipe(energy, this.getItemStack("iron_ladder", 1, 0), new ItemStack(Items.field_191525_da), 3);
            ItemStack glowshroom = this.getItemStack("glowshroom", 1, 0);
            InsolatorManager.addDefaultRecipe(glowshroom, ItemHelper.cloneStack((ItemStack)glowshroom, (int)2), ItemStack.field_190927_a, 0);
            ItemStack pirateHat = this.getItemStack("pirate_hat", 1, 0);
            ItemStack soulBead = this.getItemStack("soul_bead", 1, 0);
            CentrifugeManager.addDefaultMobRecipe("quark:ashen", Arrays.asList(new ItemStack(Items.field_151032_g, 2), new ItemStack(Items.field_151103_aS, 2)), Arrays.asList(50, 50), 5);
            CentrifugeManager.addDefaultMobRecipe("quark:dweller", Arrays.asList(new ItemStack(Items.field_151078_bh, 2), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151174_bG)), Arrays.asList(50, 2, 2), 5);
            CentrifugeManager.addDefaultMobRecipe("quark:pirate", Arrays.asList(new ItemStack(Items.field_151032_g, 2), new ItemStack(Items.field_151103_aS, 2), pirateHat), Arrays.asList(50, 50, 2), 5);
            CentrifugeManager.addDefaultMobRecipe("quark:wraith", Collections.singletonList(soulBead), Collections.singletonList(100), 5);
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: Quark Plugin encountered an error:", t);
            this.error = true;
        }
        if (!this.error) {
            ThermalExpansion.LOG.info("Thermal Expansion: Quark Plugin Enabled.");
        }
        return !this.error;
    }
}

