/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.forestry;

import cofh.core.util.ModPlugin;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import java.util.Arrays;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;

public class PluginForestry
extends ModPlugin {
    public static final String MOD_ID = "forestry";
    public static final String MOD_NAME = "Forestry";

    public PluginForestry() {
        super(MOD_ID, MOD_NAME);
    }

    public boolean initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Forestry is enabled.";
        boolean bl = this.enable = Loader.isModLoaded((String)MOD_ID) && ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!this.enable) {
            return false;
        }
        return !this.error;
    }

    public boolean register() {
        if (!this.enable) {
            return false;
        }
        try {
            ItemStack woodPile = this.getItemStack("wood_pile", 1);
            ItemStack combHoney = this.getItemStack("bee_combs", 1, 0);
            ItemStack combCocoa = this.getItemStack("bee_combs", 1, 1);
            ItemStack combSimmering = this.getItemStack("bee_combs", 1, 2);
            ItemStack combStringy = this.getItemStack("bee_combs", 1, 3);
            ItemStack combFrozen = this.getItemStack("bee_combs", 1, 4);
            ItemStack combDripping = this.getItemStack("bee_combs", 1, 5);
            ItemStack combSilky = this.getItemStack("bee_combs", 1, 6);
            ItemStack combParched = this.getItemStack("bee_combs", 1, 7);
            ItemStack combMysterious = this.getItemStack("bee_combs", 1, 8);
            ItemStack combIrradiated = this.getItemStack("bee_combs", 1, 9);
            ItemStack combPowdery = this.getItemStack("bee_combs", 1, 10);
            ItemStack combReddened = this.getItemStack("bee_combs", 1, 11);
            ItemStack combDarkened = this.getItemStack("bee_combs", 1, 12);
            ItemStack combOmega = this.getItemStack("bee_combs", 1, 13);
            ItemStack combWheat = this.getItemStack("bee_combs", 1, 14);
            ItemStack combMossy = this.getItemStack("bee_combs", 1, 15);
            ItemStack combMellow = this.getItemStack("bee_combs", 1, 16);
            ItemStack honeydew = this.getItemStack("honeydew");
            ItemStack dropHoney = this.getItemStack("honey_drop", 1, 0);
            ItemStack dropHoneyCharged = this.getItemStack("honey_drop", 1, 1);
            ItemStack dropHoneyOmega = this.getItemStack("honey_drop", 1, 2);
            ItemStack pollenCrystalline = this.getItemStack("pollen", 1, 1);
            ItemStack propolis = this.getItemStack("propolis", 1, 0);
            ItemStack propolisSticky = this.getItemStack("propolis", 1, 1);
            ItemStack propolisPulsating = this.getItemStack("propolis", 1, 2);
            ItemStack propolisSilky = this.getItemStack("propolis", 1, 3);
            ItemStack capsule = this.getItemStack("capsule", 1, 1);
            ItemStack capsuleRefactory = this.getItemStack("refractory", 1, 1);
            ItemStack wax = this.getItemStack("beeswax");
            ItemStack waxRefractory = this.getItemStack("refractory_wax");
            ItemStack silkWisp = this.getItemStack("crafting_material", 1, 2);
            ItemStack mulch = this.getItemStack("mulch");
            ItemStack phosphor = this.getItemStack("phosphor");
            Fluid biomass = FluidRegistry.getFluid((String)"biomass");
            Fluid ethanol = FluidRegistry.getFluid((String)"bio.ethanol");
            Fluid honey = FluidRegistry.getFluid((String)"for.honey");
            Fluid juice = FluidRegistry.getFluid((String)"juice");
            Fluid seed_oil = FluidRegistry.getFluid((String)"seed.oil");
            FurnaceManager.addRecipePyrolysis(4000, woodPile, new ItemStack(Items.field_151044_h, 6, 1), 600);
            if (biomass != null && ethanol != null) {
                RefineryManager.addRecipe(3000, new FluidStack(biomass, 100), new FluidStack(ethanol, 30));
            }
            int energy = 2400;
            if (honey != null) {
                TransposerManager.addExtractRecipe(energy, honeydew, ItemStack.field_190927_a, new FluidStack(honey, 100), 0, false);
                TransposerManager.addExtractRecipe(energy, dropHoney, propolis, new FluidStack(honey, 100), 5, false);
            }
            if (juice != null) {
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((Item)Items.field_151034_e, (int)1), mulch, new FluidStack(juice, 200), 20, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((Item)Items.field_151172_bF, (int)1), mulch, new FluidStack(juice, 200), 20, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropDate"), (int)1), mulch, new FluidStack(juice, 50), 20, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropLemon"), (int)1), mulch, new FluidStack(juice, 400), 10, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropPapaya"), (int)1), mulch, new FluidStack(juice, 600), 10, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropPlum"), (int)1), mulch, new FluidStack(juice, 100), 60, false);
            }
            if (seed_oil != null) {
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((Item)Items.field_151014_N, (int)1), ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((Item)Items.field_185163_cU, (int)1), ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((Item)Items.field_151080_bb, (int)1), ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((Item)Items.field_151081_bc, (int)1), ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropCherry"), (int)1), mulch, new FluidStack(seed_oil, 50), 5, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropChestnut"), (int)1), mulch, new FluidStack(seed_oil, 220), 2, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropWalnut"), (int)1), mulch, new FluidStack(seed_oil, 180), 5, false);
                PluginForestry.addSeedOilRecipes();
            }
            TransposerManager.addContainerOverride(capsule, wax, 10);
            TransposerManager.addContainerOverride(capsuleRefactory, waxRefractory, 10);
            energy = 2000;
            CentrifugeManager.addRecipe(energy, combHoney, Arrays.asList(wax, dropHoney), Arrays.asList(100, 40), null);
            CentrifugeManager.addRecipe(energy, combCocoa, Arrays.asList(wax, new ItemStack(Items.field_151100_aR, 1, 3)), Arrays.asList(100, 50), null);
            CentrifugeManager.addRecipe(energy, combSimmering, Arrays.asList(waxRefractory, ItemHelper.cloneStack((ItemStack)phosphor, (int)2)), Arrays.asList(100, 70), null);
            CentrifugeManager.addRecipe(energy, combStringy, Arrays.asList(propolis, dropHoney), Arrays.asList(100, 40), null);
            CentrifugeManager.addRecipe(energy, combFrozen, Arrays.asList(wax, dropHoney, new ItemStack(Items.field_151126_ay), pollenCrystalline), Arrays.asList(80, 70, 40, 20), null);
            CentrifugeManager.addRecipe(energy, combDripping, Arrays.asList(honeydew, dropHoney), Arrays.asList(100, 40), null);
            CentrifugeManager.addRecipe(energy, combSilky, Arrays.asList(dropHoney, propolisSilky), Arrays.asList(100, 80), null);
            CentrifugeManager.addRecipe(energy, combParched, Arrays.asList(wax, dropHoney), Arrays.asList(100, 90), null);
            CentrifugeManager.addRecipe(energy, combMysterious, Arrays.asList(propolisPulsating, dropHoney), Arrays.asList(100, 40), null);
            CentrifugeManager.addRecipe(energy, combPowdery, Arrays.asList(new ItemStack(Items.field_151016_H), wax, dropHoney), Arrays.asList(90, 20, 20), null);
            CentrifugeManager.addRecipe(energy, combWheat, Arrays.asList(new ItemStack(Items.field_151015_O), wax, dropHoney), Arrays.asList(80, 20, 20), null);
            CentrifugeManager.addRecipe(energy, combMossy, Arrays.asList(wax, dropHoney), Arrays.asList(100, 90), null);
            CentrifugeManager.addRecipe(energy, combMellow, Arrays.asList(honeydew, new ItemStack(Items.field_151128_bU), wax), Arrays.asList(60, 30, 20), null);
            CentrifugeManager.addRecipe(energy, propolisSilky, Arrays.asList(silkWisp, propolis), Arrays.asList(60, 10), null);
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: Forestry Plugin encountered an error:", t);
            this.error = true;
        }
        if (!this.error) {
            ThermalExpansion.LOG.info("Thermal Expansion: Forestry Plugin Enabled.");
        }
        return !this.error;
    }

    public static void addSeedOilRecipes() {
        String[] oreNameList;
        Fluid seed_oil = FluidRegistry.getFluid((String)"seed.oil");
        for (String name : oreNameList = OreDictionary.getOreNames()) {
            NonNullList seed;
            if (!name.startsWith("seed") || (seed = OreDictionary.getOres((String)name, (boolean)false)).isEmpty()) continue;
            TransposerManager.addExtractRecipe(2400, ItemHelper.cloneStack((ItemStack)((ItemStack)seed.get(0)), (int)1), ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
        }
    }
}

