/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.dynamo.enervation;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.dynamo.TileDynamoEnervation;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.dynamo.BaseFuelWrapper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class EnervationFuelWrapper
extends BaseFuelWrapper {
    protected List<ItemStack> inputs;
    protected int maxEnergy;

    public EnervationFuelWrapper(IGuiHelper guiHelper, ItemStack fuel, int energy) {
        this(guiHelper, fuel, energy, 0);
    }

    public EnervationFuelWrapper(IGuiHelper guiHelper, ItemStack fuel, int energy, int maxEnergy) {
        ArrayList<ItemStack> recipeInputs = new ArrayList<ItemStack>();
        recipeInputs.add(fuel);
        this.inputs = recipeInputs;
        this.energy = energy;
        this.maxEnergy = maxEnergy;
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getScaleFill(6);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        this.durationFill = guiHelper.createAnimatedDrawable(progressDrawable, energy / TileDynamoEnervation.basePower, IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.inputs);
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        if (this.maxEnergy > 0) {
            minecraft.field_71466_p.func_78276_b(StringHelper.formatNumber((long)this.maxEnergy) + " RF", 96, 10 + (recipeHeight - 9) / 2, 0xD00000);
        }
    }
}

