/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.refinery;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.TileRefinery;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.JEIPluginTE;
import cofh.thermalexpansion.plugins.jei.machine.BaseRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipeWrapper
extends BaseRecipeWrapper {
    protected List<FluidStack> inputFluids;
    protected List<FluidStack> outputFluids;
    protected List<ItemStack> outputItems;
    protected int chance;
    protected IDrawableAnimated fluid;
    protected IDrawableAnimated progress;
    protected IDrawableAnimated speed;

    public RefineryRecipeWrapper(IGuiHelper guiHelper, RefineryManager.RefineryRecipe recipe) {
        this(guiHelper, recipe, "thermalexpansion.refinery");
    }

    public RefineryRecipeWrapper(IGuiHelper guiHelper, RefineryManager.RefineryRecipe recipe, String uIdIn) {
        this.uId = uIdIn;
        ArrayList<FluidStack> recipeInputFluids = new ArrayList<FluidStack>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        recipeInputFluids.add(recipe.getInput());
        if (this.uId.equals("thermalexpansion.refinery_oil")) {
            recipeOutputFluids.add(new FluidStack(recipe.getOutputFluid(), recipe.getOutputFluid().amount + 50));
        } else {
            recipeOutputFluids.add(recipe.getOutputFluid());
        }
        recipeOutputItems.add(recipe.getOutputItem());
        this.inputFluids = recipeInputFluids;
        this.outputFluids = recipeOutputFluids;
        this.outputItems = recipeOutputItems;
        this.energy = recipe.getEnergy();
        this.chance = recipe.getChance();
        IDrawableStatic fluidDrawable = Drawables.getDrawables(guiHelper).getProgress(2);
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getProgressFill(2);
        IDrawableStatic speedDrawable = Drawables.getDrawables(guiHelper).getScaleFill(4);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        this.fluid = guiHelper.createAnimatedDrawable(fluidDrawable, this.energy / TileRefinery.basePower, IDrawableAnimated.StartDirection.LEFT, true);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, this.energy / TileRefinery.basePower, IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(speedDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(FluidStack.class, this.inputFluids);
        ingredients.setOutputs(ItemStack.class, this.outputItems);
        ingredients.setOutputs(FluidStack.class, this.outputFluids);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        JEIPluginTE.drawFluid(69, 23, this.inputFluids.get(0), 24, 16);
        this.fluid.draw(minecraft, 69, 23);
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 34, 40);
        this.energyMeter.draw(minecraft, 2, 8);
        if (this.chance > 0) {
            String dispChance = StringHelper.formatNumber((long)this.chance) + "%";
            minecraft.field_71466_p.func_78276_b(dispChance, 102 - 6 * dispChance.length(), 48, 0x808080);
        }
    }
}

