/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.device;

import cofh.core.inventory.ComparableItemStackSafe;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalfoundation.block.BlockStorage;
import cofh.thermalfoundation.block.BlockStorageAlloy;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;

public class FactorizerManager {
    private static Map<ComparableItemStackSafe, FactorizerRecipe> recipeMap = new THashMap();
    private static Map<ComparableItemStackSafe, FactorizerRecipe> recipeMapReverse = new THashMap();

    public static FactorizerRecipe getRecipe(ItemStack input, boolean reverse) {
        FactorizerRecipe recipe;
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackSafe query = new ComparableItemStackSafe(input);
        if (reverse) {
            recipe = recipeMapReverse.get(query);
            if (recipe == null) {
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapReverse.get(query);
            }
        } else {
            recipe = recipeMap.get(query);
            if (recipe == null) {
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMap.get(query);
            }
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input, boolean reverse) {
        return FactorizerManager.getRecipe(input, reverse) != null;
    }

    public static FactorizerRecipe[] getRecipeList(boolean reverse) {
        if (reverse) {
            return recipeMapReverse.values().toArray(new FactorizerRecipe[recipeMapReverse.size()]);
        }
        return recipeMap.values().toArray(new FactorizerRecipe[recipeMap.size()]);
    }

    public static void initialize() {
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotIron, new ItemStack(Blocks.field_150339_S));
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotGold, new ItemStack(Blocks.field_150340_R));
        FactorizerManager.addDefaultRecipe(ItemMaterial.gemDiamond, new ItemStack(Blocks.field_150484_ah));
        FactorizerManager.addDefaultRecipe(ItemMaterial.gemEmerald, new ItemStack(Blocks.field_150475_bE));
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotCopper, BlockStorage.blockCopper);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotTin, BlockStorage.blockTin);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotSilver, BlockStorage.blockSilver);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotLead, BlockStorage.blockLead);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotAluminum, BlockStorage.blockAluminum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotNickel, BlockStorage.blockNickel);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotPlatinum, BlockStorage.blockPlatinum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotIridium, BlockStorage.blockIridium);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotMithril, BlockStorage.blockMithril);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotSteel, BlockStorageAlloy.blockSteel);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotElectrum, BlockStorageAlloy.blockElectrum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotInvar, BlockStorageAlloy.blockInvar);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotBronze, BlockStorageAlloy.blockBronze);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotConstantan, BlockStorageAlloy.blockConstantan);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotSignalum, BlockStorageAlloy.blockSignalum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotLumium, BlockStorageAlloy.blockLumium);
        FactorizerManager.addDefaultRecipe(ItemMaterial.ingotEnderium, BlockStorageAlloy.blockEnderium);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetIron, ItemMaterial.ingotIron);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetGold, ItemMaterial.ingotGold);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetDiamond, ItemMaterial.gemDiamond);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetEmerald, ItemMaterial.gemEmerald);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetCopper, ItemMaterial.ingotCopper);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetTin, ItemMaterial.ingotTin);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetSilver, ItemMaterial.ingotSilver);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetLead, ItemMaterial.ingotLead);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetAluminum, ItemMaterial.ingotAluminum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetNickel, ItemMaterial.ingotNickel);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetPlatinum, ItemMaterial.ingotPlatinum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetIridium, ItemMaterial.ingotIridium);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetMithril, ItemMaterial.ingotMithril);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetSteel, ItemMaterial.ingotSteel);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetElectrum, ItemMaterial.ingotElectrum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetInvar, ItemMaterial.ingotInvar);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetBronze, ItemMaterial.ingotBronze);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetConstantan, ItemMaterial.ingotConstantan);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetSignalum, ItemMaterial.ingotSignalum);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetLumium, ItemMaterial.ingotLumium);
        FactorizerManager.addDefaultRecipe(ItemMaterial.nuggetEnderium, ItemMaterial.ingotEnderium);
        FactorizerManager.loadRecipes();
    }

    public static void loadRecipes() {
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            if (!(recipe instanceof ShapedRecipes)) continue;
            ShapedRecipes target = (ShapedRecipes)recipe;
            if (target.field_77574_d.size() != 9 || ((Ingredient)target.field_77574_d.get(0)).func_193365_a().length <= 0) continue;
            boolean match = true;
            for (int i = 1; i < target.field_77574_d.size(); ++i) {
                match &= ((Ingredient)target.field_77574_d.get(i)).func_193365_a().length > 0 && ItemHelper.itemsIdentical((ItemStack)((Ingredient)target.field_77574_d.get(0)).func_193365_a()[0], (ItemStack)((Ingredient)target.field_77574_d.get(i)).func_193365_a()[0]);
            }
            if (!match) continue;
            FactorizerManager.addDefaultRecipe(((Ingredient)target.field_77574_d.get(0)).func_193365_a()[0], target.func_77571_b(), target.field_77574_d.size());
        }
    }

    public static void refresh() {
        ComparableItemStackSafe input;
        FactorizerRecipe tempRecipe;
        THashMap tempMap = new THashMap(recipeMap.size());
        THashMap tempMapReverse = new THashMap(recipeMapReverse.size());
        for (Map.Entry<ComparableItemStackSafe, FactorizerRecipe> entry : recipeMap.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackSafe(tempRecipe.input);
            tempMap.put(input, tempRecipe);
        }
        for (Map.Entry<ComparableItemStackSafe, FactorizerRecipe> entry : recipeMapReverse.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackSafe(tempRecipe.input);
            tempMapReverse.put(input, tempRecipe);
        }
        recipeMap.clear();
        recipeMapReverse.clear();
        recipeMap = tempMap;
        recipeMapReverse = tempMapReverse;
    }

    public static FactorizerRecipe addRecipe(ItemStack input, ItemStack output, boolean reverse) {
        if (input.func_190926_b() || output.func_190926_b() || FactorizerManager.recipeExists(input, reverse)) {
            return null;
        }
        FactorizerRecipe recipe = new FactorizerRecipe(input, output);
        if (reverse) {
            recipeMapReverse.put(new ComparableItemStackSafe(input), recipe);
        } else {
            recipeMap.put(new ComparableItemStackSafe(input), recipe);
        }
        return recipe;
    }

    public static FactorizerRecipe removeRecipe(ItemStack input, boolean reverse) {
        if (reverse) {
            return recipeMapReverse.remove(new ComparableItemStackSafe(input));
        }
        return recipeMap.remove(new ComparableItemStackSafe(input));
    }

    public static void addDefaultRecipe(ItemStack input, ItemStack output) {
        FactorizerManager.addDefaultRecipe(input, output, 9);
    }

    public static void addDefaultRecipe(ItemStack input, ItemStack output, int count) {
        ItemStack inputStack = ItemHelper.cloneStack((ItemStack)input, (int)count);
        if (!FactorizerManager.recipeExists(inputStack, false)) {
            FactorizerManager.addRecipe(inputStack, output, false);
        }
        if (!FactorizerManager.recipeExists(output, true)) {
            FactorizerManager.addRecipe(output, inputStack, true);
        }
    }

    public static class FactorizerRecipe {
        final ItemStack input;
        final ItemStack output;

        FactorizerRecipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }
    }
}

