/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.dynamo;

import cofh.core.inventory.ComparableItemStack;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalfoundation.item.ItemCoin;
import com.google.common.collect.ImmutableSet;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collection;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class NumismaticManager {
    private static TObjectIntHashMap<ComparableItemStack> fuelMap = new TObjectIntHashMap();
    private static TObjectIntHashMap<ComparableItemStack> gemFuelMap = new TObjectIntHashMap();
    public static int DEFAULT_ENERGY = 30000;

    public static Set<ComparableItemStack> getFuels() {
        return ImmutableSet.copyOf((Collection)fuelMap.keySet());
    }

    public static Set<ComparableItemStack> getGemFuels() {
        return ImmutableSet.copyOf((Collection)gemFuelMap.keySet());
    }

    public static int getFuelEnergy(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return fuelMap.get((Object)new ComparableItemStack(stack));
    }

    public static int getGemFuelEnergy(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return gemFuelMap.get((Object)new ComparableItemStack(stack));
    }

    public static void initialize() {
        NumismaticManager.addFuel(ItemCoin.coinIron, 30000);
        NumismaticManager.addFuel(ItemCoin.coinGold, 40000);
        NumismaticManager.addFuel(ItemCoin.coinCopper, 30000);
        NumismaticManager.addFuel(ItemCoin.coinTin, 30000);
        NumismaticManager.addFuel(ItemCoin.coinSilver, 40000);
        NumismaticManager.addFuel(ItemCoin.coinLead, 40000);
        NumismaticManager.addFuel(ItemCoin.coinAluminum, 40000);
        NumismaticManager.addFuel(ItemCoin.coinNickel, 60000);
        NumismaticManager.addFuel(ItemCoin.coinPlatinum, 80000);
        NumismaticManager.addFuel(ItemCoin.coinIridium, 100000);
        NumismaticManager.addFuel(ItemCoin.coinMithril, 150000);
        NumismaticManager.addFuel(ItemCoin.coinSteel, 40000);
        NumismaticManager.addFuel(ItemCoin.coinElectrum, 40000);
        NumismaticManager.addFuel(ItemCoin.coinInvar, 40000);
        NumismaticManager.addFuel(ItemCoin.coinBronze, 30000);
        NumismaticManager.addFuel(ItemCoin.coinConstantan, 45000);
        NumismaticManager.addFuel(ItemCoin.coinSignalum, 100000);
        NumismaticManager.addFuel(ItemCoin.coinLumium, 100000);
        NumismaticManager.addFuel(ItemCoin.coinEnderium, 150000);
        NumismaticManager.addFuel(new ItemStack(Items.field_151166_bC), 200000);
        NumismaticManager.addGemFuel(new ItemStack(Items.field_151128_bU), 40000);
        NumismaticManager.addGemFuel(new ItemStack(Items.field_151100_aR, 1, 4), 80000);
        NumismaticManager.addGemFuel(new ItemStack(Items.field_179562_cC), 150000);
        NumismaticManager.addGemFuel(new ItemStack(Items.field_151166_bC), 200000);
        NumismaticManager.addGemFuel(new ItemStack(Items.field_151045_i), 1200000);
        NumismaticManager.loadFuels();
    }

    public static void loadFuels() {
        if (ItemHelper.oreNameExists((String)"gemAmethyst")) {
            NumismaticManager.addGemFuel(ItemHelper.getOre((String)"gemAmethyst"), 200000);
        }
        if (ItemHelper.oreNameExists((String)"gemRuby")) {
            NumismaticManager.addGemFuel(ItemHelper.getOre((String)"gemRuby"), 200000);
        }
        if (ItemHelper.oreNameExists((String)"gemPeridot")) {
            NumismaticManager.addGemFuel(ItemHelper.getOre((String)"gemPeridot"), 200000);
        }
        if (ItemHelper.oreNameExists((String)"gemTopaz")) {
            NumismaticManager.addGemFuel(ItemHelper.getOre((String)"gemTopaz"), 200000);
        }
        if (ItemHelper.oreNameExists((String)"gemTanzanite")) {
            NumismaticManager.addGemFuel(ItemHelper.getOre((String)"gemTanzanite"), 200000);
        }
        if (ItemHelper.oreNameExists((String)"gemMalachite")) {
            NumismaticManager.addGemFuel(ItemHelper.getOre((String)"gemMalachite"), 200000);
        }
        if (ItemHelper.oreNameExists((String)"gemSapphire")) {
            NumismaticManager.addGemFuel(ItemHelper.getOre((String)"gemSapphire"), 200000);
        }
        if (ItemHelper.oreNameExists((String)"gemAmber")) {
            NumismaticManager.addGemFuel(ItemHelper.getOre((String)"gemAmber"), 200000);
        }
        if (ItemHelper.oreNameExists((String)"gemApatite")) {
            NumismaticManager.addGemFuel(ItemHelper.getOre((String)"gemApatite"), 40000);
        }
        if (ItemHelper.oreNameExists((String)"gemCrystalFlux")) {
            NumismaticManager.addGemFuel(ItemHelper.getOre((String)"gemCrystalFlux"), 1500000);
        }
        if (ItemHelper.oreNameExists((String)"gemRedGarnet")) {
            NumismaticManager.addGemFuel(ItemHelper.getOre((String)"gemRedGarnet"), 200000);
        }
        if (ItemHelper.oreNameExists((String)"gemYellowGarnet")) {
            NumismaticManager.addGemFuel(ItemHelper.getOre((String)"gemYellowGarnet"), 200000);
        }
    }

    public static void refresh() {
        TObjectIntHashMap tempMap = new TObjectIntHashMap(fuelMap.size());
        TObjectIntHashMap tempMap2 = new TObjectIntHashMap(gemFuelMap.size());
        TObjectIntIterator it = fuelMap.iterator();
        while (it.hasNext()) {
            it.advance();
            tempMap.put((Object)new ComparableItemStack(((ComparableItemStack)it.key()).toItemStack()), it.value());
        }
        it = gemFuelMap.iterator();
        while (it.hasNext()) {
            it.advance();
            tempMap2.put((Object)new ComparableItemStack(((ComparableItemStack)it.key()).toItemStack()), it.value());
        }
        fuelMap.clear();
        fuelMap = tempMap;
        gemFuelMap.clear();
        gemFuelMap = tempMap2;
    }

    public static boolean addFuel(ItemStack stack, int energy) {
        if (stack.func_190926_b() || energy < 1000 || energy > 200000000) {
            return false;
        }
        fuelMap.put((Object)new ComparableItemStack(stack), energy);
        return true;
    }

    public static boolean addGemFuel(ItemStack stack, int energy) {
        if (stack.func_190926_b() || energy < 1000 || energy > 200000000) {
            return false;
        }
        gemFuelMap.put((Object)new ComparableItemStack(stack), energy);
        return true;
    }

    public static boolean removeFuel(ItemStack stack) {
        fuelMap.remove((Object)new ComparableItemStack(stack));
        return true;
    }

    public static boolean removeGemFuel(ItemStack stack) {
        gemFuelMap.remove((Object)new ComparableItemStack(stack));
        return true;
    }
}

