/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.dynamo;

import cofh.core.inventory.ComparableItemStack;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalfoundation.block.BlockStorageResource;
import cofh.thermalfoundation.item.ItemMaterial;
import com.google.common.collect.ImmutableSet;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collection;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class SteamManager {
    private static TObjectIntHashMap<ComparableItemStack> fuelMap = new TObjectIntHashMap();
    public static int DEFAULT_ENERGY = 16000;

    public static Set<ComparableItemStack> getFuels() {
        return ImmutableSet.copyOf((Collection)fuelMap.keySet());
    }

    public static int getFuelEnergy(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b().hasContainerItem(stack)) {
            return 0;
        }
        int energy = fuelMap.get((Object)new ComparableItemStack(stack));
        if (energy > 0) {
            return energy;
        }
        energy = TileEntityFurnace.func_145952_a((ItemStack)stack) * 10;
        if (energy >= 3000) {
            return energy;
        }
        return 0;
    }

    public static void initialize() {
        SteamManager.addFuel(new ItemStack(Items.field_151044_h, 1, 0), 24000);
        SteamManager.addFuel(new ItemStack(Blocks.field_150402_ci), 240000);
        SteamManager.addFuel(new ItemStack(Items.field_151044_h, 1, 1), 16000);
        SteamManager.addFuel(ItemHelper.cloneStack((ItemStack)BlockStorageResource.blockCharcoal, (int)1), 160000);
        SteamManager.addFuel(ItemHelper.cloneStack((ItemStack)ItemMaterial.fuelCoke, (int)1), 40000);
        SteamManager.addFuel(ItemHelper.cloneStack((ItemStack)BlockStorageResource.blockCoke, (int)1), 400000);
        SteamManager.loadFuels();
    }

    public static void loadFuels() {
    }

    public static void refresh() {
        TObjectIntHashMap tempMap = new TObjectIntHashMap(fuelMap.size());
        TObjectIntIterator it = fuelMap.iterator();
        while (it.hasNext()) {
            it.advance();
            tempMap.put((Object)new ComparableItemStack(((ComparableItemStack)it.key()).toItemStack()), it.value());
        }
        fuelMap.clear();
        fuelMap = tempMap;
    }

    public static boolean addFuel(ItemStack stack, int energy) {
        if (stack.func_190926_b() || energy < 1000 || energy > 200000000) {
            return false;
        }
        fuelMap.put((Object)new ComparableItemStack(stack), energy);
        return true;
    }

    public static boolean removeFuel(ItemStack stack) {
        fuelMap.remove((Object)new ComparableItemStack(stack));
        return true;
    }
}

