/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackSafe;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.block.BlockStorage;
import cofh.thermalfoundation.block.BlockStorageAlloy;
import cofh.thermalfoundation.item.ItemCoin;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class CompactorManager {
    private static Map<ComparableItemStackSafe, CompactorRecipe> recipeMapPress = new THashMap();
    private static Map<ComparableItemStackSafe, CompactorRecipe> recipeMapStorage = new THashMap();
    private static Map<ComparableItemStackSafe, CompactorRecipe> recipeMapMint = new THashMap();
    private static Map<ComparableItemStackSafe, CompactorRecipe> recipeMapGear = new THashMap();
    private static Set<ComparableItemStackSafe> validationSet = new THashSet();
    public static final int DEFAULT_ENERGY = 4000;
    public static final int DEFAULT_ENERGY_STORAGE = 400;

    public static CompactorRecipe getRecipe(ItemStack input, Mode mode) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackSafe query = new ComparableItemStackSafe(input);
        CompactorRecipe recipe = null;
        switch (mode) {
            case PRESS: {
                recipe = recipeMapPress.get(query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapPress.get(query);
                break;
            }
            case STORAGE: {
                recipe = recipeMapStorage.get(query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapStorage.get(query);
                break;
            }
            case MINT: {
                recipe = recipeMapMint.get(query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapMint.get(query);
                break;
            }
            case GEAR: {
                recipe = recipeMapGear.get(query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapGear.get(query);
            }
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input, Mode mode) {
        return CompactorManager.getRecipe(input, mode) != null;
    }

    public static CompactorRecipe[] getRecipeList(Mode mode) {
        switch (mode) {
            case PRESS: {
                return recipeMapPress.values().toArray(new CompactorRecipe[recipeMapPress.size()]);
            }
            case STORAGE: {
                return recipeMapStorage.values().toArray(new CompactorRecipe[recipeMapStorage.size()]);
            }
            case MINT: {
                return recipeMapMint.values().toArray(new CompactorRecipe[recipeMapMint.size()]);
            }
        }
        return recipeMapGear.values().toArray(new CompactorRecipe[recipeMapGear.size()]);
    }

    public static boolean isItemValid(ItemStack input) {
        return !input.func_190926_b() && validationSet.contains(new ComparableItemStackSafe(input));
    }

    public static void initialize() {
        CompactorManager.addRecipe(4000, new ItemStack(Items.field_151065_br, 5), new ItemStack(Items.field_151072_bj), Mode.PRESS);
        CompactorManager.addRecipe(4000, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBlizz, (int)5), ItemMaterial.rodBlizz, Mode.PRESS);
        CompactorManager.addRecipe(4000, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBlitz, (int)5), ItemMaterial.rodBlitz, Mode.PRESS);
        CompactorManager.addRecipe(4000, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBasalz, (int)5), ItemMaterial.rodBasalz, Mode.PRESS);
        CompactorManager.addDefaultPlateRecipe("Iron", ItemMaterial.plateIron);
        CompactorManager.addDefaultPlateRecipe("Gold", ItemMaterial.plateGold);
        CompactorManager.addDefaultPlateRecipe("Copper", ItemMaterial.plateCopper);
        CompactorManager.addDefaultPlateRecipe("Tin", ItemMaterial.plateTin);
        CompactorManager.addDefaultPlateRecipe("Silver", ItemMaterial.plateSilver);
        CompactorManager.addDefaultPlateRecipe("Lead", ItemMaterial.plateLead);
        CompactorManager.addDefaultPlateRecipe("Aluminum", ItemMaterial.plateAluminum);
        CompactorManager.addDefaultPlateRecipe("Nickel", ItemMaterial.plateNickel);
        CompactorManager.addDefaultPlateRecipe("Platinum", ItemMaterial.platePlatinum);
        CompactorManager.addDefaultPlateRecipe("Iridium", ItemMaterial.plateIridium);
        CompactorManager.addDefaultPlateRecipe("Mithril", ItemMaterial.plateMithril);
        CompactorManager.addDefaultPlateRecipe("Steel", ItemMaterial.plateSteel);
        CompactorManager.addDefaultPlateRecipe("Electrum", ItemMaterial.plateElectrum);
        CompactorManager.addDefaultPlateRecipe("Invar", ItemMaterial.plateInvar);
        CompactorManager.addDefaultPlateRecipe("Bronze", ItemMaterial.plateBronze);
        CompactorManager.addDefaultPlateRecipe("Constantan", ItemMaterial.plateConstantan);
        CompactorManager.addDefaultPlateRecipe("Signalum", ItemMaterial.plateSignalum);
        CompactorManager.addDefaultPlateRecipe("Lumium", ItemMaterial.plateLumium);
        CompactorManager.addDefaultPlateRecipe("Enderium", ItemMaterial.plateEnderium);
        CompactorManager.addDefaultGearRecipe("Iron", ItemMaterial.gearIron);
        CompactorManager.addDefaultGearRecipe("Gold", ItemMaterial.gearGold);
        CompactorManager.addDefaultGearRecipe("Copper", ItemMaterial.gearCopper);
        CompactorManager.addDefaultGearRecipe("Tin", ItemMaterial.gearTin);
        CompactorManager.addDefaultGearRecipe("Silver", ItemMaterial.gearSilver);
        CompactorManager.addDefaultGearRecipe("Lead", ItemMaterial.gearLead);
        CompactorManager.addDefaultGearRecipe("Aluminum", ItemMaterial.gearAluminum);
        CompactorManager.addDefaultGearRecipe("Nickel", ItemMaterial.gearNickel);
        CompactorManager.addDefaultGearRecipe("Platinum", ItemMaterial.gearPlatinum);
        CompactorManager.addDefaultGearRecipe("Iridium", ItemMaterial.gearIridium);
        CompactorManager.addDefaultGearRecipe("Mithril", ItemMaterial.gearMithril);
        CompactorManager.addDefaultGearRecipe("Steel", ItemMaterial.gearSteel);
        CompactorManager.addDefaultGearRecipe("Electrum", ItemMaterial.gearElectrum);
        CompactorManager.addDefaultGearRecipe("Invar", ItemMaterial.gearInvar);
        CompactorManager.addDefaultGearRecipe("Bronze", ItemMaterial.gearBronze);
        CompactorManager.addDefaultGearRecipe("Constantan", ItemMaterial.gearConstantan);
        CompactorManager.addDefaultGearRecipe("Signalum", ItemMaterial.gearSignalum);
        CompactorManager.addDefaultGearRecipe("Lumium", ItemMaterial.gearLumium);
        CompactorManager.addDefaultGearRecipe("Enderium", ItemMaterial.gearEnderium);
        CompactorManager.addDefaultCoinRecipe("Iron", ItemCoin.coinIron);
        CompactorManager.addDefaultCoinRecipe("Gold", ItemCoin.coinGold);
        CompactorManager.addDefaultCoinRecipe("Copper", ItemCoin.coinCopper);
        CompactorManager.addDefaultCoinRecipe("Tin", ItemCoin.coinTin);
        CompactorManager.addDefaultCoinRecipe("Silver", ItemCoin.coinSilver);
        CompactorManager.addDefaultCoinRecipe("Lead", ItemCoin.coinLead);
        CompactorManager.addDefaultCoinRecipe("Aluminum", ItemCoin.coinAluminum);
        CompactorManager.addDefaultCoinRecipe("Nickel", ItemCoin.coinNickel);
        CompactorManager.addDefaultCoinRecipe("Platinum", ItemCoin.coinPlatinum);
        CompactorManager.addDefaultCoinRecipe("Iridium", ItemCoin.coinIridium);
        CompactorManager.addDefaultCoinRecipe("Mithril", ItemCoin.coinMithril);
        CompactorManager.addDefaultCoinRecipe("Steel", ItemCoin.coinSteel);
        CompactorManager.addDefaultCoinRecipe("Electrum", ItemCoin.coinElectrum);
        CompactorManager.addDefaultCoinRecipe("Invar", ItemCoin.coinInvar);
        CompactorManager.addDefaultCoinRecipe("Bronze", ItemCoin.coinBronze);
        CompactorManager.addDefaultCoinRecipe("Constantan", ItemCoin.coinConstantan);
        CompactorManager.addDefaultCoinRecipe("Signalum", ItemCoin.coinSignalum);
        CompactorManager.addDefaultCoinRecipe("Lumium", ItemCoin.coinLumium);
        CompactorManager.addDefaultCoinRecipe("Enderium", ItemCoin.coinEnderium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotIron, new ItemStack(Blocks.field_150339_S));
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotGold, new ItemStack(Blocks.field_150340_R));
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.gemDiamond, new ItemStack(Blocks.field_150484_ah));
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.gemEmerald, new ItemStack(Blocks.field_150475_bE));
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotCopper, BlockStorage.blockCopper);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotTin, BlockStorage.blockTin);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotSilver, BlockStorage.blockSilver);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotLead, BlockStorage.blockLead);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotAluminum, BlockStorage.blockAluminum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotNickel, BlockStorage.blockNickel);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotPlatinum, BlockStorage.blockPlatinum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotIridium, BlockStorage.blockIridium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotMithril, BlockStorage.blockMithril);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotSteel, BlockStorageAlloy.blockSteel);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotElectrum, BlockStorageAlloy.blockElectrum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotInvar, BlockStorageAlloy.blockInvar);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotBronze, BlockStorageAlloy.blockBronze);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotConstantan, BlockStorageAlloy.blockConstantan);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotSignalum, BlockStorageAlloy.blockSignalum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotLumium, BlockStorageAlloy.blockLumium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotEnderium, BlockStorageAlloy.blockEnderium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetIron, ItemMaterial.ingotIron);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetGold, ItemMaterial.ingotGold);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetDiamond, ItemMaterial.gemDiamond);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetEmerald, ItemMaterial.gemEmerald);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetCopper, ItemMaterial.ingotCopper);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetTin, ItemMaterial.ingotTin);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetSilver, ItemMaterial.ingotSilver);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetLead, ItemMaterial.ingotLead);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetAluminum, ItemMaterial.ingotAluminum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetNickel, ItemMaterial.ingotNickel);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetPlatinum, ItemMaterial.ingotPlatinum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetIridium, ItemMaterial.ingotIridium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetMithril, ItemMaterial.ingotMithril);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetSteel, ItemMaterial.ingotSteel);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetElectrum, ItemMaterial.ingotElectrum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetInvar, ItemMaterial.ingotInvar);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetBronze, ItemMaterial.ingotBronze);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetConstantan, ItemMaterial.ingotConstantan);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetSignalum, ItemMaterial.ingotSignalum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetLumium, ItemMaterial.ingotLumium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetEnderium, ItemMaterial.ingotEnderium);
        CompactorManager.loadRecipes();
    }

    public static void loadRecipes() {
        String[] oreNames = OreDictionary.getOreNames();
        for (String oreName : oreNames) {
            String oreType;
            if (oreName.startsWith("plate")) {
                oreType = oreName.substring(5, oreName.length());
                CompactorManager.addDefaultPlateRecipe(oreType);
                continue;
            }
            if (oreName.startsWith("gear")) {
                oreType = oreName.substring(4, oreName.length());
                CompactorManager.addDefaultGearRecipe(oreType);
                continue;
            }
            if (!oreName.startsWith("coin")) continue;
            oreType = oreName.substring(4, oreName.length());
            CompactorManager.addDefaultCoinRecipe(oreType);
        }
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            if (!(recipe instanceof ShapedRecipes)) continue;
            ShapedRecipes target = (ShapedRecipes)recipe;
            if (target.field_77574_d.size() != 4 && target.field_77574_d.size() != 9 || ((Ingredient)target.field_77574_d.get(0)).func_193365_a().length <= 0) continue;
            boolean match = true;
            for (int i = 1; i < target.field_77574_d.size(); ++i) {
                match &= ((Ingredient)target.field_77574_d.get(i)).func_193365_a().length > 0 && ItemHelper.itemsIdentical((ItemStack)((Ingredient)target.field_77574_d.get(0)).func_193365_a()[0], (ItemStack)((Ingredient)target.field_77574_d.get(i)).func_193365_a()[0]);
            }
            if (!match) continue;
            CompactorManager.addDefaultStorageRecipe(((Ingredient)target.field_77574_d.get(0)).func_193365_a()[0], target.func_77571_b(), target.field_77574_d.size());
        }
    }

    public static void refresh() {
        ComparableItemStackSafe input;
        CompactorRecipe tempRecipe;
        THashMap tempPress = new THashMap(recipeMapPress.size());
        THashMap tempStorage = new THashMap(recipeMapStorage.size());
        THashMap tempMint = new THashMap(recipeMapMint.size());
        THashMap tempGear = new THashMap(recipeMapGear.size());
        THashSet tempSet = new THashSet();
        for (Map.Entry<ComparableItemStackSafe, CompactorRecipe> entry : recipeMapPress.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackSafe(tempRecipe.input);
            tempPress.put(input, tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<ComparableItemStackSafe, CompactorRecipe> entry : recipeMapStorage.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackSafe(tempRecipe.input);
            tempStorage.put(input, tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<ComparableItemStackSafe, CompactorRecipe> entry : recipeMapMint.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackSafe(tempRecipe.input);
            tempMint.put(input, tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<ComparableItemStackSafe, CompactorRecipe> entry : recipeMapGear.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackSafe(tempRecipe.input);
            tempGear.put(input, tempRecipe);
            tempSet.add(input);
        }
        recipeMapPress.clear();
        recipeMapStorage.clear();
        recipeMapMint.clear();
        recipeMapGear.clear();
        recipeMapPress = tempPress;
        recipeMapStorage = tempStorage;
        recipeMapMint = tempMint;
        recipeMapGear = tempGear;
        validationSet.clear();
        validationSet = tempSet;
    }

    public static CompactorRecipe addRecipe(int energy, ItemStack input, ItemStack output, Mode mode) {
        if (input.func_190926_b() || output.func_190926_b() || energy <= 0 || CompactorManager.recipeExists(input, mode)) {
            return null;
        }
        CompactorRecipe recipe = new CompactorRecipe(input, output, energy);
        switch (mode) {
            case PRESS: {
                recipeMapPress.put(new ComparableItemStackSafe(input), recipe);
                break;
            }
            case STORAGE: {
                recipeMapStorage.put(new ComparableItemStackSafe(input), recipe);
                break;
            }
            case MINT: {
                recipeMapMint.put(new ComparableItemStackSafe(input), recipe);
                break;
            }
            case GEAR: {
                recipeMapGear.put(new ComparableItemStackSafe(input), recipe);
            }
        }
        validationSet.add(new ComparableItemStackSafe(input));
        return recipe;
    }

    public static CompactorRecipe removeRecipe(ItemStack input, Mode mode) {
        switch (mode) {
            case PRESS: {
                return recipeMapPress.remove(new ComparableItemStackSafe(input));
            }
            case STORAGE: {
                return recipeMapStorage.remove(new ComparableItemStackSafe(input));
            }
            case MINT: {
                return recipeMapMint.remove(new ComparableItemStackSafe(input));
            }
        }
        return recipeMapGear.remove(new ComparableItemStackSafe(input));
    }

    private static void addDefaultPlateRecipe(String oreType) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String plateName = "plate" + StringHelper.titleCase((String)oreType);
        NonNullList registeredPlate = OreDictionary.getOres((String)plateName, (boolean)false);
        if (registeredPlate.isEmpty()) {
            return;
        }
        CompactorManager.addDefaultPlateRecipe(oreType, (ItemStack)registeredPlate.get(0));
    }

    private static void addDefaultPlateRecipe(String oreType, ItemStack plate) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String ingotName = "ingot" + StringHelper.titleCase((String)oreType);
        String gemName = "gem" + StringHelper.titleCase((String)oreType);
        String blockName = "block" + StringHelper.titleCase((String)oreType);
        NonNullList registeredIngot = OreDictionary.getOres((String)ingotName, (boolean)false);
        NonNullList registeredGem = OreDictionary.getOres((String)gemName, (boolean)false);
        NonNullList registeredBlock = OreDictionary.getOres((String)blockName, (boolean)false);
        if (!registeredIngot.isEmpty()) {
            CompactorManager.addRecipe(4000, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredIngot.get(0)), (int)1), ItemHelper.cloneStack((ItemStack)plate, (int)1), Mode.PRESS);
        }
        if (!registeredGem.isEmpty()) {
            CompactorManager.addRecipe(4000, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredGem.get(0)), (int)1), ItemHelper.cloneStack((ItemStack)plate, (int)1), Mode.PRESS);
        }
        if (!registeredBlock.isEmpty()) {
            CompactorManager.addRecipe(32000, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredBlock.get(0)), (int)1), ItemHelper.cloneStack((ItemStack)plate, (int)9), Mode.PRESS);
        }
    }

    private static void addDefaultGearRecipe(String oreType) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String plateName = "gear" + StringHelper.titleCase((String)oreType);
        NonNullList registeredGear = OreDictionary.getOres((String)plateName, (boolean)false);
        if (registeredGear.isEmpty()) {
            return;
        }
        CompactorManager.addDefaultGearRecipe(oreType, (ItemStack)registeredGear.get(0));
    }

    private static void addDefaultGearRecipe(String oreType, ItemStack gear) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String ingotName = "ingot" + StringHelper.titleCase((String)oreType);
        String gemName = "gem" + StringHelper.titleCase((String)oreType);
        String blockName = "block" + StringHelper.titleCase((String)oreType);
        NonNullList registeredIngot = OreDictionary.getOres((String)ingotName, (boolean)false);
        NonNullList registeredGem = OreDictionary.getOres((String)gemName, (boolean)false);
        NonNullList registeredBlock = OreDictionary.getOres((String)blockName, (boolean)false);
        if (!registeredIngot.isEmpty()) {
            CompactorManager.addRecipe(4000, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredIngot.get(0)), (int)4), ItemHelper.cloneStack((ItemStack)gear, (int)1), Mode.GEAR);
        }
        if (!registeredGem.isEmpty()) {
            CompactorManager.addRecipe(4000, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredGem.get(0)), (int)4), ItemHelper.cloneStack((ItemStack)gear, (int)1), Mode.GEAR);
        }
        if (!registeredBlock.isEmpty()) {
            CompactorManager.addRecipe(32000, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredBlock.get(0)), (int)4), ItemHelper.cloneStack((ItemStack)gear, (int)9), Mode.GEAR);
        }
    }

    private static void addDefaultCoinRecipe(String oreType) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String plateName = "coin" + StringHelper.titleCase((String)oreType);
        NonNullList registeredCoin = OreDictionary.getOres((String)plateName, (boolean)false);
        if (registeredCoin.isEmpty()) {
            return;
        }
        CompactorManager.addDefaultCoinRecipe(oreType, (ItemStack)registeredCoin.get(0));
    }

    private static void addDefaultCoinRecipe(String oreType, ItemStack coin) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String nuggetName = "nugget" + StringHelper.titleCase((String)oreType);
        String ingotName = "ingot" + StringHelper.titleCase((String)oreType);
        String blockName = "block" + StringHelper.titleCase((String)oreType);
        NonNullList registeredNugget = OreDictionary.getOres((String)nuggetName, (boolean)false);
        NonNullList registeredIngot = OreDictionary.getOres((String)ingotName, (boolean)false);
        NonNullList registeredBlock = OreDictionary.getOres((String)blockName, (boolean)false);
        if (!registeredNugget.isEmpty()) {
            CompactorManager.addRecipe(2000, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredNugget.get(0)), (int)3), ItemHelper.cloneStack((ItemStack)coin, (int)1), Mode.MINT);
        }
        if (!registeredIngot.isEmpty()) {
            CompactorManager.addRecipe(4000, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredIngot.get(0)), (int)1), ItemHelper.cloneStack((ItemStack)coin, (int)3), Mode.MINT);
        }
        if (!registeredBlock.isEmpty()) {
            CompactorManager.addRecipe(24000, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredBlock.get(0)), (int)1), ItemHelper.cloneStack((ItemStack)coin, (int)27), Mode.MINT);
        }
    }

    public static void addDefaultPressRecipe(ItemStack input, ItemStack output) {
        CompactorManager.addRecipe(4000, input, output, Mode.PRESS);
    }

    public static void addDefaultStorageRecipe(ItemStack input, ItemStack output, int count) {
        ItemStack inputStack = ItemHelper.cloneStack((ItemStack)input, (int)count);
        if (!CompactorManager.recipeExists(inputStack, Mode.STORAGE)) {
            CompactorManager.addRecipe(400, inputStack, output, Mode.STORAGE);
        }
    }

    public static void addDefaultStorageRecipe(ItemStack input, ItemStack output) {
        CompactorManager.addDefaultStorageRecipe(input, output, 9);
    }

    public static enum Mode {
        PRESS,
        STORAGE,
        MINT,
        GEAR;

    }

    public static class CompactorRecipe {
        final ItemStack input;
        final ItemStack output;
        final int energy;

        CompactorRecipe(ItemStack input, ItemStack output, int energy) {
            this.input = input;
            this.output = output;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

