/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.util.ItemWrapper;
import cofh.core.util.helpers.ItemHelper;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ExtruderManager {
    private static Map<ItemWrapper, ExtruderRecipe> recipeMap = new THashMap();
    private static List<ItemStack> outputList = new ArrayList<ItemStack>();
    public static final int DEFAULT_ENERGY = 800;

    public static ExtruderRecipe getRecipe(ItemStack input) {
        return input.func_190926_b() ? null : recipeMap.get(new ItemWrapper(input));
    }

    public static boolean recipeExists(ItemStack input) {
        return ExtruderManager.getRecipe(input) != null;
    }

    public static ItemStack getOutput(int index) {
        return outputList.get(index);
    }

    public static int getOutputListSize() {
        return outputList.size();
    }

    public static int getIndex(ItemStack output) {
        for (int i = 0; i < outputList.size(); ++i) {
            if (!ItemHelper.itemsIdentical((ItemStack)output, (ItemStack)outputList.get(i))) continue;
            return i;
        }
        return 0;
    }

    public static ExtruderRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new ExtruderRecipe[recipeMap.size()]);
    }

    public static void initialize() {
        ExtruderManager.addRecipe(400, new ItemStack(Blocks.field_150347_e), new FluidStack(FluidRegistry.LAVA, 0), new FluidStack(FluidRegistry.WATER, 0));
        ExtruderManager.addRecipe(800, new ItemStack(Blocks.field_150348_b), new FluidStack(FluidRegistry.LAVA, 0), new FluidStack(FluidRegistry.WATER, 1000));
        ExtruderManager.addRecipe(1600, new ItemStack(Blocks.field_150343_Z), new FluidStack(FluidRegistry.LAVA, 1000), new FluidStack(FluidRegistry.WATER, 1000));
        ExtruderManager.addRecipe(800, new ItemStack(Blocks.field_150348_b, 1, 1), new FluidStack(FluidRegistry.LAVA, 0), new FluidStack(FluidRegistry.WATER, 1000));
        ExtruderManager.addRecipe(800, new ItemStack(Blocks.field_150348_b, 1, 3), new FluidStack(FluidRegistry.LAVA, 0), new FluidStack(FluidRegistry.WATER, 1000));
        ExtruderManager.addRecipe(800, new ItemStack(Blocks.field_150348_b, 1, 5), new FluidStack(FluidRegistry.LAVA, 0), new FluidStack(FluidRegistry.WATER, 1000));
        ExtruderManager.loadRecipes();
    }

    public static void loadRecipes() {
    }

    public static void refresh() {
        THashMap tempMap = new THashMap(recipeMap.size());
        for (Map.Entry<ItemWrapper, ExtruderRecipe> entry : recipeMap.entrySet()) {
            ExtruderRecipe tempRecipe = entry.getValue();
            ItemWrapper output = new ItemWrapper(tempRecipe.output);
            tempMap.put(output, tempRecipe);
        }
        recipeMap.clear();
        recipeMap = tempMap;
    }

    public static ExtruderRecipe addRecipe(int energy, ItemStack output, FluidStack inputHot, FluidStack inputCold) {
        if (output.func_190926_b() || inputHot == null || inputCold == null || inputHot.amount > 1000 || inputCold.amount > 1000 || energy <= 0 || ExtruderManager.recipeExists(output)) {
            return null;
        }
        ExtruderRecipe recipe = new ExtruderRecipe(output, inputHot, inputCold, energy);
        recipeMap.put(new ItemWrapper(output), recipe);
        outputList.add(output);
        return recipe;
    }

    public static class ExtruderRecipe {
        final ItemStack output;
        final FluidStack inputHot;
        final FluidStack inputCold;
        final int energy;

        ExtruderRecipe(ItemStack output, FluidStack inputHot, FluidStack inputCold, int energy) {
            this.inputHot = inputHot;
            this.inputCold = inputCold;
            this.output = output;
            this.energy = energy;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public FluidStack getInputHot() {
            return this.inputHot;
        }

        public FluidStack getInputCold() {
            return this.inputCold;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

