/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackSafe;
import cofh.core.inventory.InventoryCraftingFalse;
import cofh.core.util.helpers.ColorHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class SawmillManager {
    private static Map<ComparableItemStackSawmill, SawmillRecipe> recipeMap = new THashMap();
    static final float LOG_MULTIPLIER = 1.5f;
    public static final int DEFAULT_ENERGY = 1600;

    public static SawmillRecipe getRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackSawmill query = new ComparableItemStackSawmill(input);
        SawmillRecipe recipe = recipeMap.get((Object)query);
        if (recipe == null) {
            query.metadata = Short.MAX_VALUE;
            recipe = recipeMap.get((Object)query);
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input) {
        return SawmillManager.getRecipe(input) != null;
    }

    public static SawmillRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new SawmillRecipe[recipeMap.size()]);
    }

    public static void initialize() {
        int energy = 800;
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150364_r, 1, 0), new ItemStack(Blocks.field_150344_f, 6, 0), ItemMaterial.dustWood);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150364_r, 1, 1), new ItemStack(Blocks.field_150344_f, 6, 1), ItemMaterial.dustWood);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150364_r, 1, 2), new ItemStack(Blocks.field_150344_f, 6, 2), ItemMaterial.dustWood);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150364_r, 1, 3), new ItemStack(Blocks.field_150344_f, 6, 3), ItemMaterial.dustWood);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150363_s, 1, 0), new ItemStack(Blocks.field_150344_f, 6, 4), ItemMaterial.dustWood);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150363_s, 1, 1), new ItemStack(Blocks.field_150344_f, 6, 5), ItemMaterial.dustWood);
        energy = 2400;
        SawmillManager.addRecipe(energy, new ItemStack((Block)Blocks.field_150486_ae), new ItemStack(Blocks.field_150344_f, 4), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150447_bR), new ItemStack(Blocks.field_150344_f, 4), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150462_ai), new ItemStack(Blocks.field_150344_f, 2), ItemMaterial.dustWood);
        SawmillManager.addRecipe(energy / 2, new ItemStack(Blocks.field_150471_bO, 2), new ItemStack(Blocks.field_150344_f), ItemMaterial.dustWood, 25);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150452_aw), new ItemStack(Blocks.field_150344_f), ItemMaterial.dustWood, 50);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150415_aT, 2), new ItemStack(Blocks.field_150344_f), ItemMaterial.dustWood, 75);
        SawmillManager.addRecipe(energy / 2, new ItemStack(Items.field_151054_z, 2), new ItemStack(Blocks.field_150344_f), ItemMaterial.dustWood, 25);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_151155_ap), new ItemStack(Blocks.field_150344_f), ItemMaterial.dustWood, 50);
        energy = 2400;
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_179570_aq), new ItemStack(Blocks.field_150344_f, 1, 0), ItemMaterial.dustWood, 50);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_179569_ar), new ItemStack(Blocks.field_150344_f, 1, 1), ItemMaterial.dustWood, 50);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_179568_as), new ItemStack(Blocks.field_150344_f, 1, 2), ItemMaterial.dustWood, 50);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_179567_at), new ItemStack(Blocks.field_150344_f, 1, 3), ItemMaterial.dustWood, 50);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_179572_au), new ItemStack(Blocks.field_150344_f, 1, 4), ItemMaterial.dustWood, 50);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_179571_av), new ItemStack(Blocks.field_150344_f, 1, 5), ItemMaterial.dustWood, 50);
        energy = 2400;
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_180407_aO), new ItemStack(Blocks.field_150344_f, 1, 0), ItemMaterial.dustWood, 25);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_180408_aP), new ItemStack(Blocks.field_150344_f, 1, 1), ItemMaterial.dustWood, 25);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_180404_aQ), new ItemStack(Blocks.field_150344_f, 1, 2), ItemMaterial.dustWood, 25);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_180403_aR), new ItemStack(Blocks.field_150344_f, 1, 3), ItemMaterial.dustWood, 25);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_180405_aT), new ItemStack(Blocks.field_150344_f, 1, 4), ItemMaterial.dustWood, 25);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_180406_aS), new ItemStack(Blocks.field_150344_f, 1, 5), ItemMaterial.dustWood, 25);
        energy = 2400;
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_180390_bo), new ItemStack(Blocks.field_150344_f, 1, 0), ItemMaterial.dustWood, 150);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_180391_bp), new ItemStack(Blocks.field_150344_f, 1, 1), ItemMaterial.dustWood, 150);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_180392_bq), new ItemStack(Blocks.field_150344_f, 1, 2), ItemMaterial.dustWood, 150);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_180386_br), new ItemStack(Blocks.field_150344_f, 1, 3), ItemMaterial.dustWood, 150);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_180387_bt), new ItemStack(Blocks.field_150344_f, 1, 4), ItemMaterial.dustWood, 150);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_180385_bs), new ItemStack(Blocks.field_150344_f, 1, 5), ItemMaterial.dustWood, 150);
        energy = 2400;
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150476_ad, 2), new ItemStack(Blocks.field_150344_f, 1, 0), ItemMaterial.dustWood, 25);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150485_bF, 2), new ItemStack(Blocks.field_150344_f, 1, 1), ItemMaterial.dustWood, 25);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150487_bG, 2), new ItemStack(Blocks.field_150344_f, 1, 2), ItemMaterial.dustWood, 25);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150481_bH, 2), new ItemStack(Blocks.field_150344_f, 1, 3), ItemMaterial.dustWood, 25);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150400_ck, 2), new ItemStack(Blocks.field_150344_f, 1, 4), ItemMaterial.dustWood, 25);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150401_cl, 2), new ItemStack(Blocks.field_150344_f, 1, 5), ItemMaterial.dustWood, 25);
        energy = 2400;
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_151124_az), new ItemStack(Blocks.field_150344_f, 2, 0), ItemMaterial.dustWood, 125);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_185150_aH), new ItemStack(Blocks.field_150344_f, 2, 1), ItemMaterial.dustWood, 125);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_185151_aI), new ItemStack(Blocks.field_150344_f, 2, 2), ItemMaterial.dustWood, 125);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_185152_aJ), new ItemStack(Blocks.field_150344_f, 2, 3), ItemMaterial.dustWood, 125);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_185153_aK), new ItemStack(Blocks.field_150344_f, 2, 4), ItemMaterial.dustWood, 125);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_185154_aL), new ItemStack(Blocks.field_150344_f, 2, 5), ItemMaterial.dustWood, 125);
        energy = 1600;
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_151041_m), new ItemStack(Blocks.field_150344_f), ItemMaterial.dustWood, 75);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_151038_n), new ItemStack(Blocks.field_150344_f), ItemMaterial.dustWood, 75);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_151039_o), new ItemStack(Blocks.field_150344_f), ItemMaterial.dustWood, 125);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_151053_p), new ItemStack(Blocks.field_150344_f), ItemMaterial.dustWood, 125);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_151017_I), new ItemStack(Blocks.field_150344_f), ItemMaterial.dustWood);
        energy = 1600;
        SawmillManager.addRecipe(energy, new ItemStack((Item)Items.field_151024_Q), new ItemStack(Items.field_151116_aA, 2), new ItemStack(Items.field_151116_aA), 50);
        SawmillManager.addRecipe(energy, new ItemStack((Item)Items.field_151027_R), new ItemStack(Items.field_151116_aA, 4), new ItemStack(Items.field_151116_aA), 80);
        SawmillManager.addRecipe(energy, new ItemStack((Item)Items.field_151026_S), new ItemStack(Items.field_151116_aA, 3), new ItemStack(Items.field_151116_aA), 70);
        SawmillManager.addRecipe(energy, new ItemStack((Item)Items.field_151021_T), new ItemStack(Items.field_151116_aA, 2), new ItemStack(Items.field_151116_aA), 40);
        energy = 2400;
        for (int i = 0; i < ColorHelper.WOOL_COLOR_CONFIG.length; ++i) {
            SawmillManager.addRecipe(energy, new ItemStack(Items.field_151104_aV, 1, i), new ItemStack(Blocks.field_150344_f, 2), new ItemStack(Blocks.field_150325_L, 2, i));
        }
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150342_X), new ItemStack(Blocks.field_150344_f, 3), new ItemStack(Items.field_151122_aG, 3), 25);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150421_aI), new ItemStack(Blocks.field_150344_f, 4), new ItemStack(Items.field_151045_i), 25);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150323_B), new ItemStack(Blocks.field_150344_f, 4), new ItemStack(Items.field_151137_ax), 25);
        energy = 1200;
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150440_ba), new ItemStack(Items.field_151127_ba, 9));
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150442_at), new ItemStack(Blocks.field_150347_e), ItemMaterial.dustWood, 25);
        SawmillManager.addRecipe(energy, new ItemStack(Blocks.field_150429_aA), new ItemStack(Items.field_151137_ax), ItemMaterial.dustWood, 25);
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_151159_an), new ItemStack(Blocks.field_150325_L), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
        SawmillManager.addRecipe(energy, new ItemStack(Items.field_151160_bD), new ItemStack(Items.field_151116_aA), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
        SawmillManager.loadRecipes();
    }

    public static void loadRecipes() {
        SawmillManager.addAllLogs();
    }

    public static void refresh() {
        THashMap tempMap = new THashMap(recipeMap.size());
        for (Map.Entry<ComparableItemStackSawmill, SawmillRecipe> entry : recipeMap.entrySet()) {
            SawmillRecipe tempRecipe = entry.getValue();
            tempMap.put(new ComparableItemStackSawmill(tempRecipe.input), tempRecipe);
        }
        recipeMap.clear();
        recipeMap = tempMap;
    }

    public static SawmillRecipe addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input.func_190926_b() || primaryOutput.func_190926_b() || energy <= 0 || SawmillManager.recipeExists(input)) {
            return null;
        }
        SawmillRecipe recipe = new SawmillRecipe(input, primaryOutput, secondaryOutput, secondaryOutput.func_190926_b() ? 0 : secondaryChance, energy);
        recipeMap.put(new ComparableItemStackSawmill(input), recipe);
        return recipe;
    }

    public static SawmillRecipe addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return SawmillManager.addRecipe(energy, input, primaryOutput, secondaryOutput, 100);
    }

    public static SawmillRecipe addRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        return SawmillManager.addRecipe(energy, input, primaryOutput, ItemStack.field_190927_a, 0);
    }

    public static SawmillRecipe removeRecipe(ItemStack input) {
        return recipeMap.remove((Object)new ComparableItemStackSawmill(input));
    }

    private static void addAllLogs() {
        InventoryCraftingFalse tempCrafting = new InventoryCraftingFalse(3, 3);
        for (int i = 0; i < 9; ++i) {
            tempCrafting.func_70299_a(i, ItemStack.field_190927_a);
        }
        NonNullList registeredOres = OreDictionary.getOres((String)"logWood", (boolean)false);
        for (ItemStack logEntry : registeredOres) {
            Block logBlock = Block.func_149634_a((Item)logEntry.func_77973_b());
            if (Blocks.field_150364_r.equals(logBlock) || Blocks.field_150363_s.equals(logBlock)) continue;
            if (ItemHelper.getItemDamage((ItemStack)logEntry) == Short.MAX_VALUE) {
                NonNullList logList = NonNullList.func_191196_a();
                logBlock.func_149666_a(logBlock.func_149708_J(), logList);
                for (ItemStack log : logList) {
                    tempCrafting.func_70299_a(0, log);
                    ItemStack resultEntry = ItemHelper.getCraftingResult((InventoryCrafting)tempCrafting, null);
                    if (resultEntry.func_190926_b()) continue;
                    ItemStack result = resultEntry.func_77946_l();
                    result.func_190920_e((int)((float)result.func_190916_E() * 1.5f));
                    SawmillManager.addRecipe(800, log, result, ItemMaterial.dustWood);
                }
                continue;
            }
            ItemStack log = ItemHelper.cloneStack((ItemStack)logEntry, (int)1);
            tempCrafting.func_70299_a(0, log);
            ItemStack resultEntry = ItemHelper.getCraftingResult((InventoryCrafting)tempCrafting, null);
            if (resultEntry.func_190926_b()) continue;
            ItemStack result = resultEntry.func_77946_l();
            result.func_190920_e((int)((float)result.func_190916_E() * 1.5f));
            SawmillManager.addRecipe(800, log, result, ItemMaterial.dustWood);
        }
    }

    public static class ComparableItemStackSawmill
    extends ComparableItemStackSafe {
        public boolean safeOreType(String oreName) {
            return oreName.startsWith("ore") || oreName.startsWith("ingot") || oreName.startsWith("nugget");
        }

        public ComparableItemStackSawmill(ItemStack stack) {
            super(stack);
        }
    }

    public static class SawmillRecipe {
        final ItemStack input;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        SawmillRecipe(ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, int energy) {
            this.input = input;
            this.primaryOutput = primaryOutput;
            this.secondaryOutput = secondaryOutput;
            this.secondaryChance = secondaryChance;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getPrimaryOutput() {
            return this.primaryOutput;
        }

        public ItemStack getSecondaryOutput() {
            return this.secondaryOutput;
        }

        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

