/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackSafeNBT;
import cofh.core.util.ItemWrapper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.block.storage.BlockCell;
import cofh.thermalexpansion.item.ItemFrame;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemFertilizer;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TransposerManager {
    private static Map<List<Integer>, TransposerRecipe> recipeMapFill = new THashMap();
    private static Map<ComparableItemStackTransposer, TransposerRecipe> recipeMapExtract = new THashMap();
    private static Map<ItemWrapper, ContainerOverride> containerOverrides = new THashMap();
    private static Set<ComparableItemStackTransposer> validationSet = new THashSet();
    public static final int DEFAULT_ENERGY = 400;

    public static TransposerRecipe getFillRecipe(ItemStack input, FluidStack fluid) {
        return input.func_190926_b() || fluid == null ? null : recipeMapFill.get(Arrays.asList(new ComparableItemStackTransposer(input).hashCode(), FluidHelper.getFluidHash((FluidStack)fluid)));
    }

    public static TransposerRecipe getExtractRecipe(ItemStack input) {
        return input.func_190926_b() ? null : recipeMapExtract.get((Object)new ComparableItemStackTransposer(input));
    }

    public static ContainerOverride getContainerOverride(ItemStack input) {
        return input.func_190926_b() ? null : containerOverrides.get(new ItemWrapper(input));
    }

    public static boolean fillRecipeExists(ItemStack input, FluidStack fluid) {
        return TransposerManager.getFillRecipe(input, fluid) != null;
    }

    public static boolean extractRecipeExists(ItemStack input) {
        return TransposerManager.getExtractRecipe(input) != null;
    }

    public static boolean containerOverrideExists(ItemStack input) {
        return TransposerManager.getContainerOverride(input) != null;
    }

    public static TransposerRecipe[] getFillRecipeList() {
        return recipeMapFill.values().toArray(new TransposerRecipe[recipeMapFill.size()]);
    }

    public static TransposerRecipe[] getExtractRecipeList() {
        return recipeMapExtract.values().toArray(new TransposerRecipe[recipeMapExtract.size()]);
    }

    public static boolean isItemValid(ItemStack input) {
        return !input.func_190926_b() && validationSet.contains((Object)new ComparableItemStackTransposer(input));
    }

    public static void initialize() {
        TransposerManager.addFillRecipe(4000, new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150341_Y), new FluidStack(FluidRegistry.WATER, 250), false);
        TransposerManager.addFillRecipe(4000, new ItemStack(Blocks.field_150417_aV), new ItemStack(Blocks.field_150417_aV, 1, 1), new FluidStack(FluidRegistry.WATER, 250), false);
        TransposerManager.addFillRecipe(4000, new ItemStack(Blocks.field_150322_A), new ItemStack(Blocks.field_150377_bs), new FluidStack(TFFluids.fluidEnder, 250), false);
        TransposerManager.addFillRecipe(4000, new ItemStack(Items.field_151118_aC), new ItemStack(Items.field_151130_bT), new FluidStack(FluidRegistry.LAVA, 250), false);
        TransposerManager.addExtractRecipe(2400, new ItemStack((Block)Blocks.field_150434_aF), ItemStack.field_190927_a, new FluidStack(FluidRegistry.WATER, 500), 0, false);
        TransposerManager.addExtractRecipe(2400, new ItemStack((Block)Blocks.field_150436_aH), new ItemStack(Items.field_151102_aT, 2), new FluidStack(FluidRegistry.WATER, 250), 0, false);
        FluidStack water = new FluidStack(FluidRegistry.WATER, 1000);
        for (int i = 0; i < 16; ++i) {
            TransposerManager.addFillRecipe(400, new ItemStack(Blocks.field_192444_dS, 1, i), new ItemStack(Blocks.field_192443_dR, 1, i), water, false);
        }
        int energy = 2000;
        FluidStack cryoFluid = new FluidStack(TFFluids.fluidCryotheum, 200);
        TransposerManager.addFillRecipe(energy, ItemMaterial.crystalRedstone, new ItemStack(Items.field_151137_ax, 2), cryoFluid, false);
        TransposerManager.addFillRecipe(energy, ItemMaterial.crystalGlowstone, new ItemStack(Items.field_151114_aO), cryoFluid, false);
        TransposerManager.addFillRecipe(energy, ItemMaterial.crystalEnder, new ItemStack(Items.field_151079_bi), cryoFluid, false);
        energy = 400;
        TransposerManager.addFillRecipe(energy, new ItemStack(Blocks.field_150432_aD), new ItemStack(Blocks.field_150403_cj), cryoFluid, false);
        TransposerManager.addFillRecipe(energy, ItemMaterial.dustCryotheum, new ItemStack(Blocks.field_150432_aD), new FluidStack(FluidRegistry.WATER, 1000), false);
        TransposerManager.addFillRecipe(energy, ItemMaterial.dustCryotheum, new ItemStack(Items.field_151137_ax, 10), new FluidStack(TFFluids.fluidRedstone, 1000), false);
        TransposerManager.addFillRecipe(energy, ItemMaterial.dustCryotheum, new ItemStack(Items.field_151114_aO, 4), new FluidStack(TFFluids.fluidGlowstone, 1000), false);
        TransposerManager.addFillRecipe(energy, ItemMaterial.dustCryotheum, new ItemStack(Items.field_151079_bi, 4), new FluidStack(TFFluids.fluidEnder, 1000), false);
        FluidStack redstoneFluid = new FluidStack(TFFluids.fluidRedstone, 200);
        TransposerManager.addFillRecipe(4000, new ItemStack(Items.field_151114_aO), new ItemStack(Items.field_151065_br), redstoneFluid, false);
        TransposerManager.addFillRecipe(4000, new ItemStack(Items.field_151126_ay), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBlizz, (int)1), redstoneFluid, false);
        TransposerManager.addFillRecipe(4000, new ItemStack((Block)Blocks.field_150354_m), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBlitz), redstoneFluid, false);
        TransposerManager.addFillRecipe(4000, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustObsidian), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBasalz), redstoneFluid, false);
        redstoneFluid = new FluidStack(TFFluids.fluidRedstone, 4000);
        if (BlockCell.enableClassicRecipes) {
            TransposerManager.addFillRecipe(16000, ItemFrame.frameCell2, ItemFrame.frameCell2Filled, redstoneFluid, false);
            TransposerManager.addFillRecipe(16000, ItemFrame.frameCell3, ItemFrame.frameCell3Filled, redstoneFluid, false);
            TransposerManager.addFillRecipe(16000, ItemFrame.frameCell4, ItemFrame.frameCell4Filled, redstoneFluid, false);
        }
        TransposerManager.addFillRecipe(4000, new ItemStack(Blocks.field_150360_v, 1, 0), new ItemStack(Blocks.field_150360_v, 1, 1), new FluidStack(FluidRegistry.WATER, 1000), true);
        TransposerManager.addFillRecipe(2000, ItemHelper.cloneStack((ItemStack)ItemFertilizer.fertilizerBasic), ItemHelper.cloneStack((ItemStack)ItemFertilizer.fertilizerRich), new FluidStack(TFFluids.fluidSap, 200), false);
        TransposerManager.addFillRecipe(400, new ItemStack(Items.field_151054_z), new ItemStack(Items.field_151009_A), new FluidStack(TFFluids.fluidMushroomStew, 250), true);
        TransposerManager.addFillRecipe(400, new ItemStack(Items.field_151069_bo), new ItemStack(Items.field_151062_by), new FluidStack(TFFluids.fluidExperience, 250), false);
        TransposerManager.addContainerOverride(new ItemStack(Items.field_151131_as), new ItemStack(Items.field_151133_ar), 100);
        TransposerManager.addContainerOverride(new ItemStack(Items.field_151129_at), new ItemStack(Items.field_151133_ar), 100);
        TransposerManager.addContainerOverride(new ItemStack(Items.field_151117_aB), new ItemStack(Items.field_151133_ar), 100);
        TransposerManager.addContainerOverride(new ItemStack((Item)ForgeModContainer.getInstance().universalBucket), new ItemStack(Items.field_151133_ar), 100);
        TransposerManager.loadPotions();
        TransposerManager.loadRecipes();
    }

    public static void loadPotions() {
        for (PotionType type : PotionType.field_185176_a) {
            if (type == PotionTypes.field_185229_a) continue;
            TransposerManager.addDefaultPotionRecipes(type);
        }
    }

    public static void loadRecipes() {
        FluidStack cryoStack = new FluidStack(TFFluids.fluidCryotheum, 200);
        TransposerManager.addFillRecipe(2000, ItemHelper.getOre((String)"oreCinnabar"), ItemHelper.cloneStack((ItemStack)ItemMaterial.crystalCinnabar, (int)2), cryoStack, false);
        if (FluidRegistry.isFluidRegistered((String)"essence")) {
            TransposerManager.addFillRecipe(400, new ItemStack(Items.field_151069_bo), new ItemStack(Items.field_151062_by), new FluidStack(FluidRegistry.getFluid((String)"essence"), 250), false);
        }
        if (FluidRegistry.isFluidRegistered((String)"xpjuice")) {
            TransposerManager.addFillRecipe(400, new ItemStack(Items.field_151069_bo), new ItemStack(Items.field_151062_by), new FluidStack(FluidRegistry.getFluid((String)"xpjuice"), 250), false);
        }
    }

    public static void refresh() {
        ComparableItemStackTransposer input;
        TransposerRecipe tempRecipe;
        THashMap tempFill = new THashMap(recipeMapFill.size());
        THashMap tempExtract = new THashMap(recipeMapExtract.size());
        THashMap tempOverrides = new THashMap(containerOverrides.size());
        THashSet tempSet = new THashSet();
        for (Map.Entry<List<Integer>, TransposerRecipe> entry : recipeMapFill.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackTransposer(tempRecipe.input);
            tempFill.put(Arrays.asList(input.hashCode(), FluidHelper.getFluidHash((FluidStack)tempRecipe.fluid)), tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<Object, TransposerRecipe> entry : recipeMapExtract.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackTransposer(tempRecipe.input);
            tempExtract.put(input, tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<Object, Object> entry : containerOverrides.entrySet()) {
            ContainerOverride tempOverride = (ContainerOverride)entry.getValue();
            input = new ItemWrapper(tempOverride.input);
            tempOverrides.put(input, tempOverride);
        }
        recipeMapFill.clear();
        recipeMapExtract.clear();
        recipeMapFill = tempFill;
        recipeMapExtract = tempExtract;
        validationSet.clear();
        validationSet = tempSet;
        containerOverrides.clear();
        containerOverrides = tempOverrides;
    }

    public static TransposerRecipe addFillRecipe(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible) {
        if (input.func_190926_b() || output.func_190926_b() || fluid == null || fluid.amount <= 0 || energy <= 0) {
            return null;
        }
        if (TransposerManager.fillRecipeExists(input, fluid)) {
            return null;
        }
        TransposerRecipe recipeFill = new TransposerRecipe(input, output, fluid, energy, 100);
        recipeMapFill.put(Arrays.asList(new ComparableItemStackTransposer(input).hashCode(), FluidHelper.getFluidHash((FluidStack)fluid)), recipeFill);
        validationSet.add(new ComparableItemStackTransposer(input));
        if (reversible) {
            TransposerManager.addExtractRecipe(energy, output, input, fluid, 100, false);
        }
        return recipeFill;
    }

    public static TransposerRecipe addExtractRecipe(int energy, ItemStack input, ItemStack output, FluidStack fluid, int chance, boolean reversible) {
        if (input.func_190926_b() || fluid == null || fluid.amount <= 0 || energy <= 0) {
            return null;
        }
        if (TransposerManager.extractRecipeExists(input)) {
            return null;
        }
        if (output.func_190926_b() && reversible || output.func_190926_b() && chance != 0) {
            return null;
        }
        TransposerRecipe recipeExtraction = new TransposerRecipe(input, output, fluid, energy, chance);
        recipeMapExtract.put(new ComparableItemStackTransposer(input), recipeExtraction);
        validationSet.add(new ComparableItemStackTransposer(input));
        if (reversible) {
            TransposerManager.addFillRecipe(energy, output, input, fluid, false);
        }
        return recipeExtraction;
    }

    public static TransposerRecipe removeFillRecipe(ItemStack input, FluidStack fluid) {
        return recipeMapFill.remove(Arrays.asList(new ComparableItemStackTransposer(input).hashCode(), FluidHelper.getFluidHash((FluidStack)fluid)));
    }

    public static TransposerRecipe removeExtractRecipe(ItemStack input) {
        return recipeMapExtract.remove((Object)new ComparableItemStackTransposer(input));
    }

    public static ContainerOverride addContainerOverride(ItemStack input, ItemStack output, int chance) {
        if (input.func_190926_b() || output.func_190926_b() || chance <= 0) {
            return null;
        }
        if (TransposerManager.containerOverrideExists(input)) {
            return null;
        }
        ContainerOverride override = new ContainerOverride(input, output, chance);
        containerOverrides.put(new ItemWrapper(input), override);
        return override;
    }

    public static void addDefaultPotionRecipes(PotionType type) {
        TransposerManager.addFillRecipe(800, new ItemStack(Items.field_151069_bo), PotionUtils.func_185188_a((ItemStack)ItemHelper.cloneStack((Item)Items.field_151068_bn, (int)1), (PotionType)type), TransposerManager.getPotion(250, type), true);
        TransposerManager.addFillRecipe(800, new ItemStack(Items.field_151069_bo), PotionUtils.func_185188_a((ItemStack)ItemHelper.cloneStack((Item)Items.field_185155_bH, (int)1), (PotionType)type), TransposerManager.getSplashPotion(250, type), true);
        TransposerManager.addFillRecipe(800, new ItemStack(Items.field_151069_bo), PotionUtils.func_185188_a((ItemStack)ItemHelper.cloneStack((Item)Items.field_185156_bI, (int)1), (PotionType)type), TransposerManager.getLingeringPotion(250, type), true);
        TransposerManager.addFillRecipe(400, new ItemStack(Items.field_151032_g), PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)type), TransposerManager.getLingeringPotion(25, type), false);
    }

    public static FluidStack getPotion(int amount, PotionType type) {
        if (type == PotionTypes.field_185230_b) {
            return new FluidStack(FluidRegistry.WATER, amount);
        }
        return TransposerManager.addPotionToFluidStack(new FluidStack(TFFluids.fluidPotion, amount), type);
    }

    public static FluidStack getSplashPotion(int amount, PotionType type) {
        return TransposerManager.addPotionToFluidStack(new FluidStack(TFFluids.fluidPotionSplash, amount), type);
    }

    public static FluidStack getLingeringPotion(int amount, PotionType type) {
        return TransposerManager.addPotionToFluidStack(new FluidStack(TFFluids.fluidPotionLingering, amount), type);
    }

    public static FluidStack addPotionToFluidStack(FluidStack stack, PotionType type) {
        ResourceLocation resourcelocation = (ResourceLocation)PotionType.field_185176_a.func_177774_c((Object)type);
        if (type == PotionTypes.field_185229_a) {
            if (stack.tag != null) {
                stack.tag.func_82580_o("Potion");
                if (stack.tag.func_82582_d()) {
                    stack.tag = null;
                }
            }
        } else {
            if (stack.tag == null) {
                stack.tag = new NBTTagCompound();
            }
            stack.tag.func_74778_a("Potion", resourcelocation.toString());
        }
        return stack;
    }

    public static class ComparableItemStackTransposer
    extends ComparableItemStackSafeNBT {
        public static final String CROP = "crop";
        public static final String SEED = "seed";
        public static final String GEM = "gem";

        public boolean safeOreType(String oreName) {
            return oreName.startsWith(CROP) || oreName.startsWith(SEED) || oreName.startsWith(GEM) || oreName.startsWith("ore") || oreName.startsWith("dust") || oreName.startsWith("ingot") || oreName.startsWith("nugget");
        }

        public ComparableItemStackTransposer(ItemStack stack) {
            super(stack);
        }
    }

    public static class ContainerOverride {
        final ItemStack input;
        final ItemStack output;
        final int chance;

        public ContainerOverride(ItemStack input, ItemStack output, int chance) {
            this.input = input;
            this.output = output;
            this.chance = chance;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public int getChance() {
            return this.chance;
        }
    }

    public static class TransposerRecipe {
        final ItemStack input;
        final ItemStack output;
        final FluidStack fluid;
        final int energy;
        final int chance;

        public TransposerRecipe(ItemStack input, ItemStack output, FluidStack fluid, int energy, int chance) {
            this.input = input;
            this.output = output;
            this.fluid = fluid;
            this.energy = energy;
            this.chance = chance;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getChance() {
            return this.chance;
        }
    }
}

