/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.block;

import elucent.elulib.ELRegistry;
import elucent.elulib.block.CustomStateMapper;
import elucent.elulib.block.IBlock;
import elucent.elulib.block.INoCullBlock;
import elucent.elulib.model.CustomModelBlock;
import elucent.elulib.model.CustomModelLoader;
import elucent.elulib.model.ICustomModeledObject;
import elucent.elulib.model.IModeledObject;
import elucent.elulib.model.block.BakedModelCube;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBase
extends Block
implements IBlock,
IModeledObject,
ICustomModeledObject,
INoCullBlock {
    protected Item itemBlock = null;
    public List<ItemStack> drops = null;
    protected boolean isOpaque = true;
    protected boolean hasCustomModel = false;
    protected boolean hasItems = true;
    protected boolean noCull = false;
    BlockRenderLayer layer = BlockRenderLayer.SOLID;
    public String name = "";

    public BlockBase(Material mat, SoundType type, float hardness, String name) {
        super(mat);
        this.name = name;
        this.func_149663_c(name);
        this.setRegistryName(ELRegistry.getActiveModid(), name);
        this.func_149672_a(type);
        this.func_149713_g(15);
        this.func_149711_c(hardness);
        this.itemBlock = (Item)new ItemBlock((Block)this).setRegistryName(ELRegistry.getActiveModid(), name);
    }

    public BlockBase setNoCull(boolean noCull) {
        this.noCull = noCull;
        return this;
    }

    @Override
    public boolean noCull() {
        return this.noCull;
    }

    public BlockBase setModelCustom(boolean custom) {
        this.hasCustomModel = custom;
        return this;
    }

    public BlockBase setHarvestReqs(String tool, int level) {
        this.setHarvestLevel(tool, level);
        return this;
    }

    public BlockBase setOpacity(boolean isOpaque) {
        this.isOpaque = isOpaque;
        return this;
    }

    public BlockBase setHasItem(boolean hasItem) {
        this.hasItems = hasItem;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockBase setLayer(BlockRenderLayer layer) {
        this.layer = layer;
        return this;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.isOpaque;
    }

    public boolean hasCustomModel() {
        return this.hasCustomModel;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.isOpaque;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        if (this.hasCustomModel) {
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new CustomStateMapper());
        }
        if (!this.hasCustomModel) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initCustomModel() {
        if (this.hasCustomModel) {
            ResourceLocation defaultTex = new ResourceLocation(this.getRegistryName().func_110624_b() + ":blocks/" + this.name);
            CustomModelLoader.blockmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":models/block/" + this.name), new CustomModelBlock(BakedModelCube.class, defaultTex, defaultTex));
            CustomModelLoader.itemmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":" + this.name + "#inventory"), new CustomModelBlock(BakedModelCube.class, defaultTex, defaultTex));
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.hasItems) {
            super.func_149666_a(tab, items);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.layer;
    }

    @Override
    public Item getItemBlock() {
        return this.itemBlock;
    }
}

