/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.model;

import elucent.elulib.model.CustomModelBase;
import elucent.elulib.model.block.BakedModelBlock;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class CustomModelBlock
extends CustomModelBase {
    Constructor<? extends BakedModelBlock> ctor;

    public CustomModelBlock(Class<? extends BakedModelBlock> block, ResourceLocation particle, ResourceLocation all) {
        try {
            this.ctor = block.getConstructor(IModelState.class, VertexFormat.class, Function.class, CustomModelBase.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        this.addTexture("particle", particle);
        this.addTexture("north", all);
        this.addTexture("south", all);
        this.addTexture("east", all);
        this.addTexture("west", all);
        this.addTexture("up", all);
        this.addTexture("down", all);
    }

    public CustomModelBlock(Class<? extends BakedModelBlock> block, ResourceLocation particle, ResourceLocation west, ResourceLocation east, ResourceLocation down, ResourceLocation up, ResourceLocation north, ResourceLocation south) {
        try {
            this.ctor = block.getConstructor(IModelState.class, VertexFormat.class, Function.class, CustomModelBase.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        this.addTexture("particle", particle);
        this.addTexture("north", north);
        this.addTexture("south", south);
        this.addTexture("east", east);
        this.addTexture("west", west);
        this.addTexture("up", up);
        this.addTexture("down", down);
    }

    public CustomModelBlock(Class<? extends BakedModelBlock> block, ResourceLocation particle, Pair<String, ResourceLocation> ... textures) {
        try {
            this.ctor = block.getConstructor(IModelState.class, VertexFormat.class, Function.class, CustomModelBase.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        this.addTexture("particle", particle);
        for (Pair<String, ResourceLocation> p : textures) {
            this.addTexture((String)p.getLeft(), (ResourceLocation)p.getRight());
        }
    }

    @Override
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        try {
            IBakedModel m = this.ctor.newInstance(state, format, bakedTextureGetter, this);
            return m;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return new BakedModelBlock(state, DefaultVertexFormats.field_176600_a, bakedTextureGetter, this);
        }
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

