/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.model;

import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraftforge.common.model.TRSRTransformation;

public class DefaultTransformations {
    public static Map<ItemCameraTransforms.TransformType, TRSRTransformation> itemTransforms = new HashMap<ItemCameraTransforms.TransformType, TRSRTransformation>();
    public static Map<ItemCameraTransforms.TransformType, TRSRTransformation> blockTransforms = new HashMap<ItemCameraTransforms.TransformType, TRSRTransformation>();
    public static Map<ItemCameraTransforms.TransformType, TRSRTransformation> handheldTransforms = new HashMap<ItemCameraTransforms.TransformType, TRSRTransformation>();
    public static TRSRTransformation ITEM_GROUND = DefaultTransformations.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f);
    public static TRSRTransformation ITEM_HEAD = DefaultTransformations.create(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f);
    public static TRSRTransformation ITEM_THIRD_PERSON_RIGHT = DefaultTransformations.create(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
    public static TRSRTransformation ITEM_THIRD_PERSON_LEFT = DefaultTransformations.create(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
    public static TRSRTransformation ITEM_FIRST_PERSON_RIGHT = DefaultTransformations.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
    public static TRSRTransformation ITEM_FIRST_PERSON_LEFT = DefaultTransformations.create(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f);
    public static TRSRTransformation HANDHELD_THIRD_PERSON_RIGHT = DefaultTransformations.create(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f);
    public static TRSRTransformation HANDHELD_THIRD_PERSON_LEFT = DefaultTransformations.create(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f);
    public static TRSRTransformation BLOCK_GUI = DefaultTransformations.create(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f);
    public static TRSRTransformation BLOCK_GROUND = DefaultTransformations.create(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f);
    public static TRSRTransformation BLOCK_FIXED = DefaultTransformations.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f);
    public static TRSRTransformation BLOCK_HEAD = DefaultTransformations.create(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f);
    public static TRSRTransformation BLOCK_THIRD_PERSON_RIGHT = DefaultTransformations.create(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
    public static TRSRTransformation BLOCK_THIRD_PERSON_LEFT = DefaultTransformations.create(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
    public static TRSRTransformation BLOCK_FIRST_PERSON_RIGHT = DefaultTransformations.create(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f);
    public static TRSRTransformation BLOCK_FIRST_PERSON_LEFT = DefaultTransformations.create(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f);

    public static TRSRTransformation create(float translateX, float translateY, float translateZ, float rotateX, float rotateY, float rotateZ, float scale) {
        return new TRSRTransformation(new Vector3f(translateX / 16.0f, translateY / 16.0f, translateZ / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(rotateX, rotateY, rotateZ)), new Vector3f(scale, scale, scale), null);
    }

    static {
        itemTransforms.put(ItemCameraTransforms.TransformType.GROUND, ITEM_GROUND);
        itemTransforms.put(ItemCameraTransforms.TransformType.HEAD, ITEM_HEAD);
        itemTransforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, ITEM_THIRD_PERSON_RIGHT);
        itemTransforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, ITEM_THIRD_PERSON_LEFT);
        itemTransforms.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, ITEM_FIRST_PERSON_RIGHT);
        itemTransforms.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, ITEM_FIRST_PERSON_LEFT);
        handheldTransforms.put(ItemCameraTransforms.TransformType.GROUND, ITEM_GROUND);
        handheldTransforms.put(ItemCameraTransforms.TransformType.HEAD, ITEM_HEAD);
        handheldTransforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HANDHELD_THIRD_PERSON_RIGHT);
        handheldTransforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HANDHELD_THIRD_PERSON_LEFT);
        handheldTransforms.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, ITEM_FIRST_PERSON_RIGHT);
        handheldTransforms.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, ITEM_FIRST_PERSON_LEFT);
        blockTransforms.put(ItemCameraTransforms.TransformType.GUI, BLOCK_GUI);
        blockTransforms.put(ItemCameraTransforms.TransformType.GROUND, BLOCK_GROUND);
        blockTransforms.put(ItemCameraTransforms.TransformType.FIXED, BLOCK_FIXED);
        blockTransforms.put(ItemCameraTransforms.TransformType.HEAD, BLOCK_HEAD);
        blockTransforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, BLOCK_THIRD_PERSON_RIGHT);
        blockTransforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, BLOCK_THIRD_PERSON_LEFT);
        blockTransforms.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, BLOCK_FIRST_PERSON_RIGHT);
        blockTransforms.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, BLOCK_FIRST_PERSON_LEFT);
    }
}

