/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.tile;

import elucent.elulib.tile.CableNetwork;
import elucent.elulib.tile.CableWorldData;
import elucent.elulib.tile.TileModular;
import elucent.elulib.tile.module.FaceConfig;
import elucent.elulib.tile.module.Module;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileCable
extends TileModular {
    public float u = 0.0f;
    public float v = 0.0f;
    public boolean passOn = true;
    public BlockPos from = null;
    public String type = null;
    public CableNetwork network = null;

    public TileCable(String type) {
        this.hasGui = false;
        this.canModifyIO = false;
        this.from = this.func_174877_v();
        this.type = type;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("from", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.from));
        if (this.network != null) {
            tag.func_74768_a("network", this.network.ID);
        }
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.from = NBTUtil.func_186861_c((NBTTagCompound)tag.func_74775_l("from"));
        if (tag.func_74764_b("network") && this.field_145850_b != null) {
            CableWorldData.get(this.field_145850_b);
            this.network = CableWorldData.networks.get(tag.func_74762_e("network"));
        }
    }

    public boolean canConnect(EnumFacing f) {
        for (Module m : this.modules.values()) {
            TileEntity t = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f));
            if (t == null || !t.hasCapability(m.getCapabilityType(), f.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    public void updateConnections(IBlockState state) {
        this.config.setAllIO(FaceConfig.FaceIO.NEUTRAL);
        this.config.setIO(EnumFacing.NORTH, this.canConnect(EnumFacing.NORTH) ? FaceConfig.FaceIO.IN : FaceConfig.FaceIO.NEUTRAL);
        this.config.setIO(EnumFacing.SOUTH, this.canConnect(EnumFacing.SOUTH) ? FaceConfig.FaceIO.IN : FaceConfig.FaceIO.NEUTRAL);
        this.config.setIO(EnumFacing.EAST, this.canConnect(EnumFacing.EAST) ? FaceConfig.FaceIO.IN : FaceConfig.FaceIO.NEUTRAL);
        this.config.setIO(EnumFacing.WEST, this.canConnect(EnumFacing.WEST) ? FaceConfig.FaceIO.IN : FaceConfig.FaceIO.NEUTRAL);
        this.config.setIO(EnumFacing.UP, this.canConnect(EnumFacing.UP) ? FaceConfig.FaceIO.IN : FaceConfig.FaceIO.NEUTRAL);
        this.config.setIO(EnumFacing.DOWN, this.canConnect(EnumFacing.DOWN) ? FaceConfig.FaceIO.IN : FaceConfig.FaceIO.NEUTRAL);
        if (!this.field_145850_b.field_72995_K) {
            this.updateNetwork();
        }
        this.func_70296_d();
    }

    public CableNetwork constructNetwork(CableWorldData data) {
        return new CableNetwork(data);
    }

    public void updateNetwork() {
        if (this.network == null) {
            this.network = this.constructNetwork(CableWorldData.get(this.field_145850_b));
            this.network.cables.add(this.func_174877_v());
            this.func_70296_d();
        }
        for (EnumFacing f : EnumFacing.values()) {
            TileEntity t = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f));
            if (!(t instanceof TileCable) || t.func_145837_r() || !((TileCable)t).type.equalsIgnoreCase(this.type)) continue;
            TileCable c = (TileCable)t;
            if (c.network == null) {
                c.network = this.network;
                this.network.tryAddPos(c.func_174877_v());
                c.func_70296_d();
                c.updateNetwork();
                continue;
            }
            if (c.network.ID == this.network.ID) continue;
            c.network.invalidate();
            c.network = this.network;
            this.network.tryAddPos(c.func_174877_v());
            c.func_70296_d();
            c.updateNetwork();
        }
        this.network.dirty = true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return newState.func_177230_c() != oldState.func_177230_c();
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            if (this.network != null) {
                this.network.invalidate();
            }
            for (EnumFacing f : EnumFacing.values()) {
                TileEntity t = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f));
                if (!(t instanceof TileCable) || ((TileCable)t).type != this.type) continue;
                TileCable c = (TileCable)t;
                c.network = null;
                c.updateNetwork();
            }
        }
    }
}

