/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.tile;

import elucent.elulib.EluLib;
import elucent.elulib.gui.GuiHandler;
import elucent.elulib.tile.TileBase;
import elucent.elulib.tile.module.FaceConfig;
import elucent.elulib.tile.module.Module;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileModular
extends TileBase {
    public Map<String, Module> modules = new HashMap<String, Module>();
    public FaceConfig config = new FaceConfig();
    protected boolean hasGui = true;
    public boolean canModifyIO = true;
    public Set<String> validIOModules = new HashSet<String>();

    public TileModular addModule(Module module) {
        this.modules.put(module.getModuleName(), module);
        this.validIOModules.add(module.getModuleName());
        return this;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        for (Module m : this.modules.values()) {
            tag.func_74782_a(m.getModuleName(), (NBTBase)m.writeToNBT());
        }
        tag.func_74782_a("faceConfig", (NBTBase)this.config.writeToNBT());
        NBTTagList validIO = new NBTTagList();
        for (String s : this.validIOModules) {
            validIO.func_74742_a((NBTBase)new NBTTagString(s));
        }
        tag.func_74782_a("validIO", (NBTBase)validIO);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (Module m : this.modules.values()) {
            if (!tag.func_74764_b(m.getModuleName())) continue;
            m.readFromNBT(tag.func_74775_l(m.getModuleName()));
        }
        this.validIOModules.clear();
        NBTTagList validIO = tag.func_150295_c("validIO", 8);
        for (int i = 0; i < validIO.func_74745_c(); ++i) {
            this.validIOModules.add(validIO.func_150307_f(i));
        }
        this.config.readFromNBT(tag.func_74775_l("faceConfig"));
    }

    public boolean hasCapability(Capability capability, EnumFacing facing) {
        for (Module m : this.modules.values()) {
            if (!m.hasCapability(capability, facing)) continue;
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        for (Module m : this.modules.values()) {
            if (!m.hasCapability(capability, facing)) continue;
            return (T)m.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.hasGui && GuiHandler.hasGui(TileModular.getTileName(this.getClass()))) {
            player.openGui((Object)EluLib.INSTANCE, GuiHandler.getGuiID(TileModular.getTileName(this.getClass())), world, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        for (Module m : this.modules.values()) {
            m.onBroken(world, pos, player);
        }
        super.breakBlock(world, pos, state, player);
    }
}

