/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.tile.module;

import elucent.elulib.ELEvents;
import elucent.elulib.fluid.ExtendedFluidTank;
import elucent.elulib.tile.TileModular;
import elucent.elulib.tile.module.FaceConfig;
import elucent.elulib.tile.module.Module;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class ModuleFluid
extends Module {
    public List<ExtendedFluidTank> tanks = new ArrayList<ExtendedFluidTank>();
    public Map<EnumFacing, FluidIOProxy> ioProxies = new HashMap<EnumFacing, FluidIOProxy>();
    public TileModular tile = null;
    public int receiveLimit;
    public int giveLimit = 0;
    public FluidManager manager = new FluidManager();

    public ModuleFluid(String name, TileModular tile, int giveLimit) {
        super(name);
        this.tile = tile;
        this.giveLimit = giveLimit;
        for (EnumFacing f : EnumFacing.values()) {
            this.ioProxies.put(f, this.constructIOProxy(f));
        }
    }

    public ModuleFluid addTank(ExtendedFluidTank tank) {
        this.tanks.add(tank);
        return this;
    }

    public FluidTank constructTank(int capacity) {
        return new FluidTank(capacity);
    }

    public int getInputLimit() {
        return this.receiveLimit;
    }

    public int getOutputLimit() {
        return this.giveLimit;
    }

    public FluidIOProxy constructIOProxy(EnumFacing face) {
        return new FluidIOProxy(face);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing face) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public Object getCapability(Capability<?> capability, EnumFacing face) {
        if (face != null) {
            return this.ioProxies.get(face);
        }
        return this.manager;
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList tanks = new NBTTagList();
        for (ExtendedFluidTank t : this.tanks) {
            tanks.func_74742_a((NBTBase)t.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("tanks", (NBTBase)tanks);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("tanks", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.tanks.get(i).readFromNBT(list.func_150305_b(i));
        }
    }

    @Override
    public void onUpdate() {
        block0: for (EnumFacing f : EnumFacing.values()) {
            if (!this.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f) || this.tile.config.ioConfig.get(f) != FaceConfig.FaceIO.OUT || this.tile.func_145831_w().field_72995_K || !this.tile.validIOModules.contains(this.getModuleName())) continue;
            for (ExtendedFluidTank tank : this.tanks) {
                int amount;
                IFluidHandler s;
                TileEntity t;
                if (!tank.canOutput() || tank.getFluid() == null || tank.getFluid().getFluid() == null || (t = this.tile.func_145831_w().func_175625_s(this.tile.func_174877_v().func_177972_a(f))) == null || !t.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d()) || (s = (IFluidHandler)t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d())) == null || (amount = s.fill(new FluidStack(tank.getFluid().getFluid(), Math.min(this.giveLimit, tank.getFluidAmount())), false)) <= 0) continue;
                FluidStack fl = tank.getFluid().copy();
                s.fill(new FluidStack(tank.getFluid(), amount), true);
                tank.drainInternal(new FluidStack(fl.getFluid(), amount), true);
                this.tile.func_70296_d();
                t.func_70296_d();
                ELEvents.markForUpdate(this.tile.func_174877_v().func_177972_a(f), t);
                continue block0;
            }
        }
    }

    @Override
    public Capability getCapabilityType() {
        return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public class FluidIOProxy
    extends FluidManager {
        EnumFacing face;

        public FluidIOProxy(EnumFacing face) {
            this.face = EnumFacing.NORTH;
            this.face = face;
        }

        @Override
        public IFluidTankProperties[] getTankProperties() {
            return ModuleFluid.this.manager.getTankProperties();
        }

        @Override
        public FluidStack drain(FluidStack stack, boolean simulate) {
            if (ModuleFluid.this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.OUT || ModuleFluid.this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.INOUT || ModuleFluid.this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.NEUTRAL) {
                ModuleFluid.this.tile.func_70296_d();
                return ModuleFluid.this.manager.drain(stack, simulate);
            }
            return null;
        }

        @Override
        public int fill(FluidStack stack, boolean simulate) {
            if (ModuleFluid.this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.IN || ModuleFluid.this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.INOUT) {
                ModuleFluid.this.tile.func_70296_d();
                return ModuleFluid.this.manager.fill(stack, simulate);
            }
            return 0;
        }

        @Override
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (ModuleFluid.this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.OUT || ModuleFluid.this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.INOUT) {
                return ModuleFluid.this.manager.drain(maxDrain, doDrain);
            }
            return null;
        }
    }

    public class FluidManager
    implements IFluidHandler {
        public IFluidTankProperties[] getTankProperties() {
            ArrayList<IFluidTankProperties> props = new ArrayList<IFluidTankProperties>();
            for (ExtendedFluidTank t : ModuleFluid.this.tanks) {
                IFluidTankProperties[] tprops;
                for (IFluidTankProperties p : tprops = t.getTankProperties()) {
                    props.add(p);
                }
            }
            return props.toArray(new IFluidTankProperties[props.size()]);
        }

        public int fill(FluidStack resource, boolean doFill) {
            for (ExtendedFluidTank t : ModuleFluid.this.tanks) {
                if (!t.appliesTo(resource)) continue;
                return t.fill(resource, doFill);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            for (ExtendedFluidTank t : ModuleFluid.this.tanks) {
                if (!t.appliesTo(resource)) continue;
                return t.drain(resource, doDrain);
            }
            return new FluidStack(resource.getFluid(), 0);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            Iterator<ExtendedFluidTank> iterator = ModuleFluid.this.tanks.iterator();
            if (iterator.hasNext()) {
                ExtendedFluidTank t = iterator.next();
                return t.drain(maxDrain, doDrain);
            }
            return null;
        }
    }
}

