/*
 * Decompiled with CFR 0.152.
 */
package elucent.elulib.tile.module;

import elucent.elulib.ELEvents;
import elucent.elulib.inventory.IExtendedInventory;
import elucent.elulib.inventory.InventoryHandler;
import elucent.elulib.predicates.PredicateTrue;
import elucent.elulib.tile.TileModular;
import elucent.elulib.tile.module.FaceConfig;
import elucent.elulib.tile.module.Module;
import elucent.elulib.util.InventoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ModuleInventory
extends Module
implements IExtendedInventory {
    public InventoryHandler inventory;
    public TileModular tile = null;
    public ArrayList<Predicate<ItemStack>> predicates = new ArrayList();
    public int slotCount = 0;
    String name = "";
    Set<Integer> inputSlots = new HashSet<Integer>();
    Set<Integer> outputSlots = new HashSet<Integer>();
    public Map<EnumFacing, ItemIOProxy> ioProxies = new HashMap<EnumFacing, ItemIOProxy>();

    /*
     * WARNING - void declaration
     */
    public ModuleInventory(String name, TileModular tile, int slotCount, String containerName, int[] inputSlots, int[] outputSlots) {
        super(name);
        void var7_8;
        this.slotCount = slotCount;
        this.inventory = new InventoryHandler(slotCount, this);
        this.tile = tile;
        name = containerName;
        boolean bl = false;
        while (var7_8 < slotCount) {
            this.predicates.add(new PredicateTrue());
            ++var7_8;
        }
        for (int i : inputSlots) {
            this.inputSlots.add(i);
        }
        for (int i : outputSlots) {
            this.outputSlots.add(i);
        }
        for (EnumFacing f : EnumFacing.values()) {
            this.ioProxies.put(f, this.constructIOProxy(f, slotCount));
        }
    }

    public ModuleInventory(String name, TileModular tile, int slotCount, String containerName, Collection<Integer> inputSlots, Collection<Integer> outputSlots) {
        super(name);
        int i;
        this.slotCount = slotCount;
        this.inventory = new InventoryHandler(slotCount, this);
        this.tile = tile;
        name = containerName;
        for (int i2 = 0; i2 < slotCount; ++i2) {
            this.predicates.add(new PredicateTrue());
        }
        EnumFacing[] enumFacingArray = inputSlots.iterator();
        while (enumFacingArray.hasNext()) {
            i = enumFacingArray.next();
            this.inputSlots.add(i);
        }
        enumFacingArray = outputSlots.iterator();
        while (enumFacingArray.hasNext()) {
            i = enumFacingArray.next();
            this.outputSlots.add(i);
        }
        for (EnumFacing f : EnumFacing.values()) {
            this.ioProxies.put(f, this.constructIOProxy(f, slotCount));
        }
    }

    public ItemIOProxy constructIOProxy(EnumFacing face, int capacity) {
        return new ItemIOProxy(face, capacity, this);
    }

    public ModuleInventory setSlotPredicate(int slot, Predicate<ItemStack> predicate) {
        this.predicates.set(slot, predicate);
        return this;
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.slotCount;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i) == ItemStack.field_190927_a) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack toReturn = this.inventory.extractItem(index, count, false);
        this.func_70296_d();
        return toReturn;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack toReturn = this.inventory.getStackInSlot(index).func_77946_l();
        this.inventory.setStackInSlot(index, ItemStack.field_190927_a);
        this.func_70296_d();
        return toReturn;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.setStackInSlot(index, stack);
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.predicates.get(index).test(stack);
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(I18n.func_135052_a((String)("elmodule.inventory." + this.func_70005_c_() + ".name"), (Object[])new Object[0]));
    }

    public void func_70296_d() {
        if (this.tile != null) {
            this.tile.func_70296_d();
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing face) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public Object getCapability(Capability<?> capability, EnumFacing face) {
        if (face != null) {
            return this.ioProxies.get(face);
        }
        return this.inventory;
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
    }

    @Override
    public boolean canExtractFromSlot(int slot) {
        return true;
    }

    @Override
    public boolean canInsertToSlot(int slot) {
        return true;
    }

    @Override
    public void onBroken(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.func_70301_a(i)));
            }
        }
    }

    @Override
    public void onUpdate() {
        for (EnumFacing f : EnumFacing.values()) {
            TileEntity t;
            if (!this.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f) || this.tile.config.ioConfig.get(f) != FaceConfig.FaceIO.OUT || this.tile.func_145831_w().field_72995_K || !this.tile.validIOModules.contains(this.getModuleName()) || (t = this.tile.func_145831_w().func_175625_s(this.tile.func_174877_v().func_177972_a(f))) == null || !t.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d())) continue;
            IItemHandler inv = (IItemHandler)t.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d());
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                int amount;
                if (this.inventory.getStackInSlot(i).func_190926_b() || !this.canExtractFromSlot(i) || !this.outputSlots.contains(i) || (amount = InventoryUtil.attemptInsert(this.inventory.getStackInSlot(i), inv, true)) <= 0) continue;
                InventoryUtil.attemptInsert(this.inventory.getStackInSlot(i), inv, false);
                this.func_70298_a(i, amount);
                this.tile.func_70296_d();
                t.func_70296_d();
                ELEvents.markForUpdate(this.tile.func_174877_v().func_177972_a(f), t);
            }
        }
    }

    @Override
    public Capability getCapabilityType() {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public class ItemIOProxy
    extends InventoryHandler {
        EnumFacing face;

        public ItemIOProxy(EnumFacing face, int size, IExtendedInventory inventory) {
            super(size, inventory);
            this.face = EnumFacing.NORTH;
            this.face = face;
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if ((ModuleInventory.this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.IN || ModuleInventory.this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.INOUT) && ModuleInventory.this.inputSlots.contains(slot)) {
                return ModuleInventory.this.inventory.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if ((ModuleInventory.this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.OUT || ModuleInventory.this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.NEUTRAL || ModuleInventory.this.tile.config.ioConfig.get(this.face) == FaceConfig.FaceIO.INOUT) && ModuleInventory.this.outputSlots.contains(slot)) {
                return ModuleInventory.this.inventory.extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack getStackInSlot(int slot) {
            return ModuleInventory.this.inventory.getStackInSlot(slot);
        }

        public int getSlotLimit(int slot) {
            return ModuleInventory.this.inventory.getSlotLimit(slot);
        }
    }
}

