/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks.crops;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import rustic.common.blocks.IColoredBlock;
import rustic.common.blocks.ModBlocks;
import rustic.core.ClientProxy;
import rustic.core.Rustic;

public class BlockLeavesApple
extends BlockLeaves
implements IColoredBlock,
IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"apple_age", (int)0, (int)3);

    public BlockLeavesApple() {
        this.setRegistryName("leaves_apple");
        this.func_149663_c("rustic.leaves_apple");
        this.func_149647_a(Rustic.farmingTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
        GameRegistry.findRegistry(Block.class).register((IForgeRegistryEntry)this);
        GameRegistry.findRegistry(Item.class).register(new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
        Blocks.field_150480_ab.func_180686_a((Block)this, 30, 60);
    }

    public int getMaxAge() {
        return 3;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        float f;
        super.func_180650_b(worldIn, pos, state, rand);
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        if (i < this.getMaxAge() && BlockLeavesApple.isAirAdjacent(worldIn, pos, state) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(50.0f / (f = BlockLeavesApple.getGrowthChance((Block)this, worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    protected static float getGrowthChance(Block blockIn, World worldIn, BlockPos pos) {
        return 1.0f;
    }

    protected static boolean isAirAdjacent(World world, BlockPos pos, IBlockState state) {
        return world.func_175623_d(pos.func_177977_b()) || world.func_175623_d(pos.func_177978_c()) || world.func_175623_d(pos.func_177968_d()) || world.func_175623_d(pos.func_177976_e()) || world.func_175623_d(pos.func_177974_f());
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) < this.getMaxAge() && BlockLeavesApple.isAirAdjacent(worldIn, pos, state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) < this.getMaxAge() && BlockLeavesApple.isAirAdjacent(worldIn, pos, state);
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int j;
        int i = (Integer)state.func_177229_b((IProperty)AGE) + this.getBonemealAgeIncrease(worldIn);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if ((Integer)state.func_177229_b((IProperty)AGE) >= this.getMaxAge()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), 3);
            state.func_177230_c();
            Block.func_180635_a((World)world, (BlockPos)pos.func_177972_a(side), (ItemStack)new ItemStack(Items.field_151034_e));
            return true;
        }
        return false;
    }

    protected void func_176234_a(World worldIn, BlockPos pos, IBlockState state, int chance) {
        if ((Integer)state.func_177229_b((IProperty)AGE) >= this.getMaxAge()) {
            BlockLeavesApple.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_151034_e));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.APPLE_SAPLING);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack drop;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int chance = this.func_176232_d(state);
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (rand.nextInt(chance) == 0 && !(drop = new ItemStack(this.func_180660_a(state, rand, fortune), 1, this.func_180651_a(state))).func_190926_b()) {
            ret.add(drop);
        }
        this.captureDrops(true);
        if (world instanceof World) {
            this.func_176234_a((World)world, pos, state, chance);
        }
        ret.addAll((Collection<ItemStack>)this.captureDrops(false));
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        StateMap custom_mapper = new StateMap.Builder().func_178442_a(new IProperty[]{field_176236_b, field_176237_a}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)custom_mapper);
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ClientProxy.addColoredBlock((Block)this);
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)Blocks.field_150362_t, 1, BlockPlanks.EnumType.OAK.func_176839_a()));
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)Blocks.field_150362_t, 1, BlockPlanks.EnumType.OAK.func_176839_a());
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(StatList.func_188055_a((Block)Blocks.field_150362_t));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    protected int func_176232_d(IBlockState state) {
        return 20;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(state, world, pos, side);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, 0);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta & 3)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((Integer)state.func_177229_b((IProperty)AGE)).intValue();
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a, AGE});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                if (worldIn != null && pos != null && tintIndex == 0) {
                    return BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos);
                }
                return ColorizerFoliage.func_77468_c();
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (!(stack.func_77973_b() instanceof ItemBlock)) {
                    return 0xFFFFFF;
                }
                IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                IBlockColor blockColor = ((IColoredBlock)state.func_177230_c()).getBlockColor();
                return blockColor == null ? 0xFFFFFF : blockColor.func_186720_a(state, null, null, tintIndex);
            }
        };
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }
}

