/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.crafting;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import rustic.common.Config;
import rustic.common.blocks.BlockLeavesRustic;
import rustic.common.blocks.BlockLogRustic;
import rustic.common.blocks.BlockPlanksRustic;
import rustic.common.blocks.BlockSaplingRustic;
import rustic.common.blocks.ModBlocks;
import rustic.common.blocks.crops.Herbs;
import rustic.common.blocks.fluids.ModFluids;
import rustic.common.crafting.AdvancedCondenserRecipe;
import rustic.common.crafting.BasicCondenserRecipe;
import rustic.common.crafting.BrewingBarrelRecipe;
import rustic.common.crafting.CondenserRecipe;
import rustic.common.crafting.CrushingTubRecipe;
import rustic.common.crafting.EvaporatingBasinRecipe;
import rustic.common.crafting.RecipeNonIngredientReturn;
import rustic.common.crafting.RecipeOliveOil;
import rustic.common.items.ModItems;
import rustic.common.potions.PotionsRustic;

public class Recipes {
    public static List<CrushingTubRecipe> crushingTubRecipes = new ArrayList<CrushingTubRecipe>();
    public static List<EvaporatingBasinRecipe> evaporatingRecipes = new ArrayList<EvaporatingBasinRecipe>();
    public static List<CondenserRecipe> condenserRecipes = new ArrayList<CondenserRecipe>();
    public static List<BrewingBarrelRecipe> brewingRecipes = new ArrayList<BrewingBarrelRecipe>();

    public static void initOres() {
        Recipes.addOreDictEntries();
    }

    public static void init() {
        Recipes.addCraftingRecipes();
        Recipes.addSmeltingRecipes();
        Recipes.addFuels();
        Recipes.addCrushingTubRecipes();
        Recipes.addEvaporatingRecipes();
        Recipes.addCondenserRecipes();
        Recipes.addBrewingRecipes();
    }

    private static void addSmeltingRecipes() {
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)ModItems.HONEYCOMB), (ItemStack)new ItemStack((Item)ModItems.BEESWAX), (float)0.3f);
        for (int i = 0; i < BlockPlanksRustic.EnumType.values().length; ++i) {
            IBlockState state = ModBlocks.LOG.func_176223_P().func_177226_a(BlockLogRustic.VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.byMetadata(i)));
            int meta = ModBlocks.LOG.func_176201_c(state);
            GameRegistry.addSmelting((ItemStack)new ItemStack((Block)ModBlocks.LOG, 1, meta), (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        }
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)ModItems.IRON_DUST_TINY), (ItemStack)new ItemStack(Items.field_191525_da), (float)0.15f);
        if (Config.FLESH_SMELTING) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(Items.field_151078_bh), (ItemStack)new ItemStack((Item)ModItems.TALLOW), (float)0.3f);
        }
    }

    private static void addFuels() {
        IFuelHandler rusticFuels = new IFuelHandler(){

            public int getBurnTime(ItemStack fuel) {
                Item item = fuel.func_77973_b();
                if (item == Item.func_150898_a((Block)ModBlocks.SAPLING) || item == Item.func_150898_a((Block)ModBlocks.APPLE_SAPLING)) {
                    return 100;
                }
                if (item == Item.func_150898_a((Block)ModBlocks.WILDBERRY_BUSH)) {
                    return 150;
                }
                return 0;
            }
        };
        GameRegistry.registerFuelHandler((IFuelHandler)rusticFuels);
    }

    private static void addOreDictEntries() {
        OreDictionary.registerOre((String)"cropOlive", (ItemStack)new ItemStack((Item)ModItems.OLIVES));
        OreDictionary.registerOre((String)"cropIronberry", (ItemStack)new ItemStack((Item)ModItems.IRONBERRIES));
        OreDictionary.registerOre((String)"listAllfruit", (ItemStack)new ItemStack((Item)ModItems.OLIVES));
        OreDictionary.registerOre((String)"listAllfruit", (ItemStack)new ItemStack((Item)ModItems.IRONBERRIES));
        OreDictionary.registerOre((String)"listAllfruit", (ItemStack)new ItemStack((Item)ModItems.GRAPES));
        OreDictionary.registerOre((String)"listAllberry", (ItemStack)new ItemStack((Item)ModItems.GRAPES));
        OreDictionary.registerOre((String)"listAllberry", (ItemStack)new ItemStack((Item)ModItems.IRONBERRIES));
        OreDictionary.registerOre((String)"listAllberry", (ItemStack)new ItemStack((Item)ModItems.WILDBERRIES));
        OreDictionary.registerOre((String)"listAllfruit", (ItemStack)new ItemStack((Item)ModItems.WILDBERRIES));
        OreDictionary.registerOre((String)"cropWildberry", (ItemStack)new ItemStack((Item)ModItems.WILDBERRIES));
        OreDictionary.registerOre((String)"cropGrape", (ItemStack)new ItemStack((Item)ModItems.GRAPES));
        OreDictionary.registerOre((String)"cropChilipepper", (ItemStack)new ItemStack((Item)ModItems.CHILI_PEPPER));
        OreDictionary.registerOre((String)"listAllpepper", (ItemStack)new ItemStack((Item)ModItems.CHILI_PEPPER));
        OreDictionary.registerOre((String)"cropTomato", (ItemStack)new ItemStack((Item)ModItems.TOMATO));
        OreDictionary.registerOre((String)"listAllveggie", (ItemStack)new ItemStack((Item)ModItems.TOMATO));
        for (int i = 0; i < BlockPlanksRustic.EnumType.values().length; ++i) {
            IBlockState state = ModBlocks.LOG.func_176223_P().func_177226_a(BlockLogRustic.VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.byMetadata(i)));
            int meta = ModBlocks.LOG.func_176201_c(state);
            OreDictionary.registerOre((String)"treeWood", (ItemStack)new ItemStack((Block)ModBlocks.LOG, 1, meta));
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack((Block)ModBlocks.LOG, 1, meta));
            state = ModBlocks.LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeavesRustic.VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.byMetadata(i)));
            meta = ModBlocks.LEAVES.func_176201_c(state);
            OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack((Block)ModBlocks.LEAVES, 1, meta));
            state = ModBlocks.SAPLING.func_176223_P().func_177226_a(BlockSaplingRustic.VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.byMetadata(i)));
            meta = ModBlocks.SAPLING.func_176201_c(state);
            OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack((Block)ModBlocks.SAPLING, 1, meta));
            state = ModBlocks.PLANKS.func_176223_P().func_177226_a(BlockPlanksRustic.VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.byMetadata(i)));
            meta = ModBlocks.PLANKS.func_176201_c(state);
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PLANKS, 1, meta));
        }
        OreDictionary.registerOre((String)"slabWood", (ItemStack)new ItemStack((Item)ModBlocks.OLIVE_SLAB_ITEM));
        OreDictionary.registerOre((String)"slabWood", (ItemStack)new ItemStack((Item)ModBlocks.IRONWOOD_SLAB_ITEM));
        OreDictionary.registerOre((String)"stairWood", (ItemStack)new ItemStack((Block)ModBlocks.OLIVE_STAIRS));
        OreDictionary.registerOre((String)"stairWood", (ItemStack)new ItemStack((Block)ModBlocks.IRONWOOD_STAIRS));
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack((Block)ModBlocks.APPLE_SAPLING));
        OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack((Block)ModBlocks.APPLE_LEAVES));
        OreDictionary.registerOre((String)"wax", (ItemStack)new ItemStack((Item)ModItems.BEESWAX));
        OreDictionary.registerOre((String)"wax", (ItemStack)new ItemStack((Item)ModItems.TALLOW));
        OreDictionary.registerOre((String)"tallow", (ItemStack)new ItemStack((Item)ModItems.BEESWAX));
        OreDictionary.registerOre((String)"tallow", (ItemStack)new ItemStack((Item)ModItems.TALLOW));
        OreDictionary.registerOre((String)"dustTinyIron", (ItemStack)new ItemStack((Item)ModItems.IRON_DUST_TINY));
        OreDictionary.registerOre((String)"dyeRed", (ItemStack)new ItemStack((Item)ModItems.WILDBERRIES));
    }

    private static void addCraftingRecipes() {
        if (Config.ENABLE_PILLARS) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "pillar_stone"), null, (ItemStack)new ItemStack((Block)ModBlocks.STONE_PILLAR, 6), (Object[])new Object[]{"SS ", "SS ", "SS ", Character.valueOf('S'), new ItemStack(Blocks.field_150348_b, 1, 0)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "pillar_andesite"), null, (ItemStack)new ItemStack((Block)ModBlocks.ANDESITE_PILLAR, 6), (Object[])new Object[]{"SS ", "SS ", "SS ", Character.valueOf('S'), new ItemStack(Blocks.field_150348_b, 1, 5)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "pillar_diorite"), null, (ItemStack)new ItemStack((Block)ModBlocks.DIORITE_PILLAR, 6), (Object[])new Object[]{"SS ", "SS ", "SS ", Character.valueOf('S'), new ItemStack(Blocks.field_150348_b, 1, 3)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "pillar_granite"), null, (ItemStack)new ItemStack((Block)ModBlocks.GRANITE_PILLAR, 6), (Object[])new Object[]{"SS ", "SS ", "SS ", Character.valueOf('S'), new ItemStack(Blocks.field_150348_b, 1, 1)});
            if (Config.ENABLE_SLATE) {
                GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "pillar_slate"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_PILLAR, 6), (Object[])new Object[]{"SS", "SS", "SS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE_TILE)});
            }
        }
        if (Config.ENABLE_SLATE) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_roof"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_ROOF, 4), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_roof_stairs"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_ROOF_STAIRS, 4), (Object[])new Object[]{"S  ", "SS ", "SSS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE_ROOF)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_roof_slab"), null, (ItemStack)new ItemStack((Item)ModBlocks.SLATE_ROOF_SLAB_ITEM, 6), (Object[])new Object[]{"SSS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE_ROOF)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_brick_stairs"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_BRICK_STAIRS, 4), (Object[])new Object[]{"S  ", "SS ", "SSS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE_BRICK)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_brick_slab"), null, (ItemStack)new ItemStack((Item)ModBlocks.SLATE_BRICK_SLAB_ITEM, 6), (Object[])new Object[]{"SSS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE_BRICK)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_tile"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_TILE), (Object[])new Object[]{"S", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_tile_1"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_TILE), (Object[])new Object[]{"S", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE_BRICK)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_brick"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_BRICK, 4), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE_TILE)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_chiseled"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_CHISELED, 4), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE_BRICK)});
        }
        if (Config.ENABLE_CLAY_WALLS) {
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.CLAY_WALL, 8), new Object[]{" P ", "PCP", " P ", Character.valueOf('P'), "plankWood", Character.valueOf('C'), Blocks.field_150435_aG}).setRegistryName(new ResourceLocation("rustic", "clay_wall")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.CLAY_WALL_CROSS), new Object[]{"P P", " C ", "P P", Character.valueOf('P'), "plankWood", Character.valueOf('C'), ModBlocks.CLAY_WALL}).setRegistryName(new ResourceLocation("rustic", "clay_wall_cross")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.CLAY_WALL_DIAG), new Object[]{"P  ", " C ", "  P", Character.valueOf('P'), "plankWood", Character.valueOf('C'), ModBlocks.CLAY_WALL}).setRegistryName(new ResourceLocation("rustic", "clay_wall_diag")));
        }
        if (Config.ENABLE_CHAIRS) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "acacia_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_ACACIA, 4), (Object[])new Object[]{"P  ", "PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 4), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "big_oak_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_BIG_OAK, 4), (Object[])new Object[]{"P  ", "PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 5), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "birch_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_BIRCH, 4), (Object[])new Object[]{"P  ", "PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 2), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "jungle_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_JUNGLE, 4), (Object[])new Object[]{"P  ", "PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 3), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "oak_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_OAK, 4), (Object[])new Object[]{"P  ", "PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 0), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "spruce_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_SPRUCE, 4), (Object[])new Object[]{"P  ", "PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 1), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "olive_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_OLIVE, 4), (Object[])new Object[]{"p  ", "ppp", "s s", Character.valueOf('p'), new ItemStack((Block)ModBlocks.PLANKS, 1, BlockPlanksRustic.EnumType.OLIVE.getMetadata()), Character.valueOf('s'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "ironwood_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_IRONWOOD, 4), (Object[])new Object[]{"p  ", "ppp", "s s", Character.valueOf('p'), new ItemStack((Block)ModBlocks.PLANKS, 1, BlockPlanksRustic.EnumType.IRONWOOD.getMetadata()), Character.valueOf('s'), new ItemStack(Items.field_151055_y)});
        }
        if (Config.ENABLE_TABLES) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "acacia_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_ACACIA, 2), (Object[])new Object[]{"PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 4), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "big_oak_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_BIG_OAK, 2), (Object[])new Object[]{"PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 5), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "birch_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_BIRCH, 2), (Object[])new Object[]{"PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 2), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "jungle_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_JUNGLE, 2), (Object[])new Object[]{"PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 3), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "oak_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_OAK, 2), (Object[])new Object[]{"PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 0), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "spruce_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_SPRUCE, 2), (Object[])new Object[]{"PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 1), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "olive_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_OLIVE, 2), (Object[])new Object[]{"ppp", "s s", Character.valueOf('p'), new ItemStack((Block)ModBlocks.PLANKS, 1, BlockPlanksRustic.EnumType.OLIVE.getMetadata()), Character.valueOf('s'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "ironwood_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_IRONWOOD, 2), (Object[])new Object[]{"ppp", "s s", Character.valueOf('p'), new ItemStack((Block)ModBlocks.PLANKS, 1, BlockPlanksRustic.EnumType.IRONWOOD.getMetadata()), Character.valueOf('s'), new ItemStack(Items.field_151055_y)});
        }
        if (Config.ENABLE_LATTICE) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "iron_lattice"), null, (ItemStack)new ItemStack((Block)ModBlocks.IRON_LATTICE, 16), (Object[])new Object[]{" I ", "III", " I ", Character.valueOf('I'), new ItemStack(Items.field_151042_j)});
        }
        if (Config.ENABLE_PAINTED_WOOD) {
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_WHITE, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeWhite"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_white")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_ORANGE, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeOrange"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_orange")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_MAGENTA, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeMagenta"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_magenta")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_LIGHT_BLUE, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeLightBlue"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_light_blue")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_YELLOW, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeYellow"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_yellow")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_LIME, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeLime"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_lime")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_PINK, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyePink"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_pink")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_GRAY, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeGray"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_gray")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_SILVER, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeLightGray"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_silver")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_CYAN, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeCyan"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_cyan")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_PURPLE, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyePurple"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_purple")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_BLUE, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeBlue"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_blue")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_BROWN, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeBrown"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_brown")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_GREEN, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeGreen"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_green")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_RED, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeRed"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_red")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_BLACK, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeBlack"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_black")));
        }
        RecipeSorter.register((String)"rustic:shapeless_nonreturn", RecipeNonIngredientReturn.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        ItemStack aleWortBucket = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)ModFluids.ALE_WORT);
        GameRegistry.findRegistry(IRecipe.class).register(new RecipeNonIngredientReturn(null, aleWortBucket, new ItemStack(Items.field_151025_P), new ItemStack(Items.field_151102_aT), new ItemStack(Items.field_151131_as)).setRegistryName(new ResourceLocation("rustic", "ale_wort")));
        GameRegistry.findRegistry(IRecipe.class).register(new RecipeNonIngredientReturn(null, new ItemStack(Items.field_151069_bo), new ItemStack((Item)ModItems.FLUID_BOTTLE)).setRegistryName(new ResourceLocation("rustic", "bottle_emptying")));
        if (Config.ENABLE_OLIVE_OILING) {
            RecipeSorter.register((String)"rustic:olive_oil", RecipeOliveOil.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            GameRegistry.findRegistry(IRecipe.class).register(new RecipeOliveOil().setRegistryName(new ResourceLocation("rustic", "olive_oiling")));
        }
    }

    private static void addCrushingTubRecipes() {
        crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluids.OLIVE_OIL, 250), new ItemStack((Item)ModItems.OLIVES)));
        crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluids.IRONBERRY_JUICE, 250), new ItemStack((Item)ModItems.IRONBERRIES)));
        crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(FluidRegistry.WATER, 250), new ItemStack(Items.field_151120_aE), new ItemStack(Items.field_151102_aT, 2)));
        crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluids.WILDBERRY_JUICE, 250), new ItemStack((Item)ModItems.WILDBERRIES)));
        crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluids.GRAPE_JUICE, 250), new ItemStack((Item)ModItems.GRAPES)));
        crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluids.APPLE_JUICE, 250), new ItemStack(Items.field_151034_e), new ItemStack((Block)ModBlocks.APPLE_SEEDS)));
        crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluids.HONEY, 250), new ItemStack((Item)ModItems.HONEYCOMB)));
    }

    private static void addEvaporatingRecipes() {
        evaporatingRecipes.add(new EvaporatingBasinRecipe(new ItemStack((Item)ModItems.IRON_DUST_TINY, 1), new FluidStack(ModFluids.IRONBERRY_JUICE, 500)));
    }

    private static void addCondenserRecipes() {
        condenserRecipes.add(new BasicCondenserRecipe(new PotionEffect(MobEffects.field_76432_h, 1), new ItemStack((Block)Herbs.CHAMOMILE), new ItemStack(Items.field_151082_bd)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76432_h, 1, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Block)Herbs.CHAMOMILE), new ItemStack(Items.field_151082_bd)));
        condenserRecipes.add(new BasicCondenserRecipe(new PotionEffect(MobEffects.field_76428_l, 900), new ItemStack((Block)Herbs.COHOSH), new ItemStack((Item)ModItems.HONEYCOMB)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76428_l, 1800), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Block)Herbs.COHOSH), new ItemStack((Item)ModItems.HONEYCOMB)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76428_l, 450, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Block)Herbs.COHOSH), new ItemStack((Item)ModItems.HONEYCOMB)));
        condenserRecipes.add(new BasicCondenserRecipe(new PotionEffect(MobEffects.field_82731_v, 900), new ItemStack((Block)Herbs.DEATHSTALK), new ItemStack(Blocks.field_150425_aM)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_82731_v, 1800), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Block)Herbs.DEATHSTALK), new ItemStack(Blocks.field_150425_aM)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_82731_v, 450, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Block)Herbs.DEATHSTALK), new ItemStack(Blocks.field_150425_aM)));
        condenserRecipes.add(new BasicCondenserRecipe(new PotionEffect(MobEffects.field_76439_r, 3600), new ItemStack((Block)Herbs.MOONCAP), new ItemStack(Items.field_151070_bp)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76439_r, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Block)Herbs.MOONCAP), new ItemStack(Items.field_151070_bp)));
        condenserRecipes.add(new BasicCondenserRecipe(new PotionEffect(MobEffects.field_76424_c, 3600), new ItemStack((Block)Herbs.WIND_THISTLE), new ItemStack(Items.field_151102_aT)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76424_c, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Block)Herbs.WIND_THISTLE), new ItemStack(Items.field_151102_aT)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76424_c, 1800, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Block)Herbs.WIND_THISTLE), new ItemStack(Items.field_151102_aT)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76426_n, 3600), ItemStack.field_190927_a, new ItemStack((Block)Herbs.ALOE_VERA), new ItemStack(Items.field_151118_aC), new ItemStack(Items.field_151044_h)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76426_n, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Block)Herbs.ALOE_VERA), new ItemStack(Items.field_151118_aC), new ItemStack(Items.field_151044_h)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_180152_w, 3600), ItemStack.field_190927_a, new ItemStack((Block)Herbs.BLOOD_ORCHID), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151137_ax)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_180152_w, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Block)Herbs.BLOOD_ORCHID), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151137_ax)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_180152_w, 1800, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Block)Herbs.BLOOD_ORCHID), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151137_ax)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76422_e, 3600), ItemStack.field_190927_a, new ItemStack((Item)Herbs.CORE_ROOT), new ItemStack(Items.field_191525_da), new ItemStack(Items.field_151137_ax)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76422_e, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Item)Herbs.CORE_ROOT), new ItemStack(Items.field_191525_da), new ItemStack(Items.field_151137_ax)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76422_e, 1800, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Item)Herbs.CORE_ROOT), new ItemStack(Items.field_191525_da), new ItemStack(Items.field_151137_ax)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76420_g, 3600), ItemStack.field_190927_a, new ItemStack((Item)Herbs.GINSENG), new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151016_H)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76420_g, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Item)Herbs.GINSENG), new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151016_H)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76420_g, 1800, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Item)Herbs.GINSENG), new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151016_H)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(PotionsRustic.IRON_SKIN_POTION, 3600), ItemStack.field_190927_a, new ItemStack((Item)ModItems.IRONBERRIES), new ItemStack(Items.field_151116_aA), new ItemStack(Items.field_151119_aD)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(PotionsRustic.IRON_SKIN_POTION, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Item)ModItems.IRONBERRIES), new ItemStack(Items.field_151116_aA), new ItemStack(Items.field_151119_aD)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(PotionsRustic.IRON_SKIN_POTION, 1800, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Item)ModItems.IRONBERRIES), new ItemStack(Items.field_151116_aA), new ItemStack(Items.field_151119_aD)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(PotionsRustic.FEATHER_POTION, 3600), ItemStack.field_190927_a, new ItemStack((Item)Herbs.CLOUDSBLUFF), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151121_aF)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(PotionsRustic.FEATHER_POTION, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Item)Herbs.CLOUDSBLUFF), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151121_aF)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(PotionsRustic.BLAZING_TRAIL_POTION, 3600), ItemStack.field_190927_a, new ItemStack((Item)ModItems.CHILI_PEPPER), new ItemStack(Items.field_151065_br), new ItemStack(Blocks.field_150424_aL)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(PotionsRustic.BLAZING_TRAIL_POTION, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Item)ModItems.CHILI_PEPPER), new ItemStack(Items.field_151065_br), new ItemStack(Blocks.field_150424_aL)));
    }

    private static void addBrewingRecipes() {
        brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluids.ALE, 1), new FluidStack(ModFluids.ALE_WORT, 1)));
        brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluids.CIDER, 1), new FluidStack(ModFluids.APPLE_JUICE, 1)));
        brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluids.IRON_WINE, 1), new FluidStack(ModFluids.IRONBERRY_JUICE, 1)));
        brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluids.MEAD, 1), new FluidStack(FluidRegistry.getFluid((String)ModFluids.HONEY.getName()), 1)));
        if (FluidRegistry.isFluidRegistered((String)"for.honey")) {
            brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluids.MEAD, 1), new FluidStack(FluidRegistry.getFluid((String)"for.honey"), 1)));
        }
        brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluids.WILDBERRY_WINE, 1), new FluidStack(ModFluids.WILDBERRY_JUICE, 1)));
        brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluids.WINE, 1), new FluidStack(ModFluids.GRAPE_JUICE, 1)));
    }
}

