/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import rustic.common.blocks.BlockCondenser;
import rustic.common.blocks.ModBlocks;
import rustic.common.crafting.BasicCondenserRecipe;
import rustic.common.crafting.CondenserRecipe;
import rustic.common.crafting.Recipes;
import rustic.common.inventory.ExternalItemHandler;
import rustic.core.Rustic;

public class TileEntityCondenser
extends TileFluidHandler
implements ITickable {
    private int capacity = 8000;
    private ItemStackHandler internalStackHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            IBlockState state = TileEntityCondenser.this.field_145850_b.func_180495_p(TileEntityCondenser.this.field_174879_c);
            TileEntityCondenser.this.field_145850_b.func_175641_c(TileEntityCondenser.this.field_174879_c, TileEntityCondenser.this.func_145838_q(), 1, 0);
            TileEntityCondenser.this.func_145831_w().func_184138_a(TileEntityCondenser.this.field_174879_c, state, state, 3);
            TileEntityCondenser.this.field_145850_b.func_175685_c(TileEntityCondenser.this.field_174879_c, TileEntityCondenser.this.func_145838_q(), true);
            TileEntityCondenser.this.func_70296_d();
        }
    };
    private ExternalItemHandler externalStackHandler = new ExternalItemHandler(this.internalStackHandler){

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot == 2 && !TileEntityFurnace.func_145954_b((ItemStack)stack)) {
                return stack;
            }
            if (slot == 3 && stack.func_77973_b() != Items.field_151069_bo) {
                return stack;
            }
            if (slot == 4) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    public int condenserBurnTime;
    public int currentItemBurnTime;
    public int brewTime;
    public int totalBrewTime;

    public TileEntityCondenser() {
        this.tank = new FluidTank(this.capacity){

            protected void onContentsChanged() {
                TileEntityCondenser.this.func_70296_d();
            }
        };
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(true);
    }

    public void func_73660_a() {
        if (this.isBurning()) {
            --this.condenserBurnTime;
        }
        if (this.totalBrewTime <= 0) {
            this.totalBrewTime = this.getBrewTime();
        }
        ItemStack fuelStack = this.internalStackHandler.getStackInSlot(2);
        if (this.isBurning() || !fuelStack.func_190926_b()) {
            if (!this.isBurning() && this.canBrew() && this.getRecipe() != null) {
                this.currentItemBurnTime = this.condenserBurnTime = TileEntityFurnace.func_145952_a((ItemStack)fuelStack);
                if (this.isBurning() && !fuelStack.func_190926_b() && !this.field_145850_b.field_72995_K) {
                    Item item = fuelStack.func_77973_b();
                    this.internalStackHandler.getStackInSlot(2).func_190918_g(1);
                    if (fuelStack.func_190926_b()) {
                        ItemStack item1 = item.getContainerItem(fuelStack);
                        this.internalStackHandler.setStackInSlot(2, item1);
                    }
                }
            }
            if (this.isBurning() && this.canBrew() && this.getRecipe() != null) {
                ++this.brewTime;
                if (this.field_145850_b.field_72995_K && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == ModBlocks.CONDENSER) {
                    EnumFacing blockFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCondenser.FACING);
                    double yVel = 0.125;
                    if (blockFacing == EnumFacing.NORTH || blockFacing == EnumFacing.SOUTH) {
                        Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() - 0.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, yVel, 0.0);
                        Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() + 1.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, yVel, 0.0);
                    } else if (blockFacing == EnumFacing.EAST || blockFacing == EnumFacing.WEST) {
                        Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() - 0.5, 0.0, yVel, 0.0);
                        Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() + 1.5, 0.0, yVel, 0.0);
                    }
                }
                if (this.brewTime >= this.totalBrewTime) {
                    this.brewTime = 0;
                    this.totalBrewTime = this.getBrewTime();
                    if (!this.field_145850_b.field_72995_K) {
                        this.brew();
                    }
                }
            } else {
                this.brewTime = 0;
            }
        } else if (!this.isBurning() && this.brewTime > 0) {
            this.brewTime = MathHelper.func_76125_a((int)(this.brewTime - 2), (int)0, (int)this.totalBrewTime);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != ModBlocks.CONDENSER || !((BlockCondenser)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).hasRetorts(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c))) {
            return false;
        }
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != ModBlocks.CONDENSER || !((BlockCondenser)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).hasRetorts(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c))) {
            return null;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.externalStackHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("items")) {
            this.internalStackHandler.deserializeNBT((NBTTagCompound)tag.func_74781_a("items"));
        }
        this.condenserBurnTime = tag.func_74762_e("BurnTime");
        this.brewTime = tag.func_74762_e("BrewTime");
        this.totalBrewTime = tag.func_74762_e("BrewTimeTotal");
        this.currentItemBurnTime = tag.func_74762_e("ItemBurnTime");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74782_a("items", (NBTBase)this.internalStackHandler.serializeNBT());
        tag.func_74768_a("BurnTime", (int)((short)this.condenserBurnTime));
        tag.func_74768_a("BrewTime", (int)((short)this.brewTime));
        tag.func_74768_a("BrewTimeTotal", (int)((short)this.totalBrewTime));
        tag.func_74768_a("ItemBurnTime", this.currentItemBurnTime);
        return tag;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.func_70296_d();
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        this.func_145843_s();
        if (this.internalStackHandler != null && !world.field_72995_K) {
            for (int i = 0; i < this.internalStackHandler.getSlots(); ++i) {
                if (this.internalStackHandler.getStackInSlot(i) == null) continue;
                state.func_177230_c();
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.internalStackHandler.getStackInSlot(i));
            }
        }
        world.func_175690_a(pos, null);
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem != ItemStack.field_190927_a) {
            boolean didFill;
            if ((heldItem.func_77973_b() instanceof ItemBucket || heldItem.func_77973_b() instanceof UniversalBucket) && (didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side))))) {
                this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
                this.func_145831_w().func_184138_a(pos, state, state, 3);
                this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
                this.func_70296_d();
                return true;
            }
        } else if (player.func_70093_af() && this.tank.getFluidAmount() > 0) {
            FluidStack drained = this.tank.drainInternal(this.capacity, true);
            SoundEvent soundevent = drained.getFluid().getEmptySound(drained);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
            this.func_145831_w().func_184138_a(pos, state, state, 3);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public String getName() {
        return "container.rustic.condenser";
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public int getAmount() {
        return this.tank.getFluidAmount();
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public Fluid getFluid() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public int getBrewTime() {
        return 400;
    }

    public boolean isBurning() {
        return this.condenserBurnTime > 0;
    }

    public boolean canBrew() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != ModBlocks.CONDENSER || !((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCondenser.BOTTOM)).booleanValue()) {
            return false;
        }
        if (!((BlockCondenser)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).hasRetorts(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c))) {
            return false;
        }
        if (this.internalStackHandler.getStackInSlot(0).func_190926_b() && this.internalStackHandler.getStackInSlot(1).func_190926_b()) {
            return false;
        }
        if (this.internalStackHandler.getStackInSlot(3).func_190926_b() || this.internalStackHandler.getStackInSlot(3).func_77973_b() != Items.field_151069_bo || this.internalStackHandler.getStackInSlot(3).func_190916_E() < 1) {
            return false;
        }
        if (this.getAmount() < 125) {
            return false;
        }
        return this.getFluid() == FluidRegistry.WATER;
    }

    private BasicCondenserRecipe getRecipe() {
        for (CondenserRecipe recipe : Recipes.condenserRecipes) {
            if (!(recipe instanceof BasicCondenserRecipe)) continue;
            BasicCondenserRecipe basicRecipe = (BasicCondenserRecipe)recipe;
            if (!basicRecipe.matches(ItemStack.field_190927_a, new ItemStack[]{this.internalStackHandler.getStackInSlot(0), this.internalStackHandler.getStackInSlot(1)}) || !this.internalStackHandler.insertItem(4, recipe.getResult(), true).func_190926_b()) continue;
            return basicRecipe;
        }
        return null;
    }

    private void brew() {
        if (!this.canBrew()) {
            return;
        }
        BasicCondenserRecipe recipe = this.getRecipe();
        if (recipe != null) {
            this.internalStackHandler.insertItem(4, recipe.getResult(), false);
            this.internalStackHandler.extractItem(0, 1, false);
            this.internalStackHandler.extractItem(1, 1, false);
            this.internalStackHandler.extractItem(3, 1, false);
            this.tank.drain(125, true);
        }
    }
}

