/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import rustic.common.crafting.EvaporatingBasinRecipe;
import rustic.common.crafting.Recipes;

public class TileEntityEvaporatingBasin
extends TileFluidHandler
implements ITickable {
    private int capacity = 6000;
    private FluidStack evaporatedFluid;
    private int age = 0;
    private ItemStackHandler itemStackHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            IBlockState state = TileEntityEvaporatingBasin.this.field_145850_b.func_180495_p(TileEntityEvaporatingBasin.this.field_174879_c);
            TileEntityEvaporatingBasin.this.field_145850_b.func_175641_c(TileEntityEvaporatingBasin.this.field_174879_c, TileEntityEvaporatingBasin.this.func_145838_q(), 1, 0);
            TileEntityEvaporatingBasin.this.func_145831_w().func_184138_a(TileEntityEvaporatingBasin.this.field_174879_c, state, state, 3);
            TileEntityEvaporatingBasin.this.field_145850_b.func_175685_c(TileEntityEvaporatingBasin.this.field_174879_c, TileEntityEvaporatingBasin.this.func_145838_q(), true);
            TileEntityEvaporatingBasin.this.func_70296_d();
        }
    };

    public TileEntityEvaporatingBasin() {
        this.tank = new FluidTank(this.capacity);
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(true);
        this.evaporatedFluid = null;
    }

    public void func_73660_a() {
        ++this.age;
        if (this.age >= 1000000) {
            this.age = 0;
        }
        if (this.age % 20 == 0) {
            FluidStack drained = this.tank.drain(20, true);
            if (this.evaporatedFluid == null) {
                if (drained != null) {
                    this.evaporatedFluid = drained;
                    this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
                    this.func_70296_d();
                }
            } else if (drained != null) {
                if (!this.evaporatedFluid.getFluid().equals(drained.getFluid())) {
                    this.evaporatedFluid = drained;
                    this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
                    this.func_70296_d();
                } else {
                    this.evaporatedFluid.amount += drained.amount;
                    this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
                    this.func_70296_d();
                }
            }
            if (this.evaporatedFluid != null && this.evaporatedFluid.amount > 0) {
                for (EvaporatingBasinRecipe recipe : Recipes.evaporatingRecipes) {
                    ItemStack result = recipe.getResult().func_77946_l();
                    if (!recipe.matches(this.evaporatedFluid) || !this.itemStackHandler.insertItem(0, result, true).func_190926_b()) continue;
                    this.evaporatedFluid.amount -= recipe.getInput().amount;
                    this.itemStackHandler.insertItem(0, result, false);
                    this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
                    this.func_70296_d();
                }
            }
        }
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public int getAmount() {
        return this.tank.getFluidAmount();
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public Fluid getFluid() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemStackHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("items")) {
            this.itemStackHandler.deserializeNBT((NBTTagCompound)tag.func_74781_a("items"));
        }
        if (tag.func_74764_b("EvaporatedFluid")) {
            this.evaporatedFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("EvaporatedFluid"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74782_a("items", (NBTBase)this.itemStackHandler.serializeNBT());
        if (this.evaporatedFluid != null) {
            tag.func_74782_a("EvaporatedFluid", (NBTBase)this.evaporatedFluid.writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.func_70296_d();
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        this.func_145843_s();
        if (this.itemStackHandler != null && !world.field_72995_K) {
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                if (this.itemStackHandler.getStackInSlot(i) == null) continue;
                state.func_177230_c();
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.itemStackHandler.getStackInSlot(i));
            }
        }
        world.func_175690_a(pos, null);
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem != ItemStack.field_190927_a) {
            boolean didFill;
            if ((heldItem.func_77973_b() instanceof ItemBucket || heldItem.func_77973_b() instanceof UniversalBucket) && (didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side))))) {
                this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
                this.func_145831_w().func_184138_a(pos, state, state, 3);
                this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
                this.func_70296_d();
                return true;
            }
        } else if (player.func_70093_af() && this.getAmount() > 0) {
            FluidStack drained = this.tank.drainInternal(this.capacity, true);
            SoundEvent soundevent = drained.getFluid().getEmptySound(drained);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
            this.func_145831_w().func_184138_a(pos, state, state, 3);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.func_70296_d();
            return true;
        }
        if (this.itemStackHandler.getStackInSlot(0) != ItemStack.field_190927_a && !world.field_72995_K) {
            world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.itemStackHandler.getStackInSlot(0)));
            this.itemStackHandler.setStackInSlot(0, ItemStack.field_190927_a);
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
            this.func_145831_w().func_184138_a(pos, state, state, 3);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.func_70296_d();
            return true;
        }
        return false;
    }
}

