/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import rustic.common.Config;
import rustic.common.blocks.ModBlocks;
import rustic.common.blocks.crops.BlockBerryBush;

public class WorldGenWildberries
extends WorldGenerator {
    public static List<BiomeDictionary.Type> biomeBlacklist = new ArrayList<BiomeDictionary.Type>();

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        for (BiomeDictionary.Type type : biomeBlacklist) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type)) continue;
            return false;
        }
        boolean ret = false;
        for (int i = 0; i < Config.MAX_WILDBERRY_ATTEMPTS; ++i) {
            int z;
            int x = pos.func_177958_n() + rand.nextInt(7) - rand.nextInt(7);
            BlockPos genPos = world.func_175672_r(new BlockPos(x, 0, z = pos.func_177952_p() + rand.nextInt(7) - rand.nextInt(7)));
            if (!this.generateBush(world, rand, genPos)) continue;
            ret = true;
        }
        return ret;
    }

    private boolean generateBush(World world, Random rand, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        if (ModBlocks.WILDBERRY_BUSH.func_176196_c(world, pos)) {
            world.func_175656_a(pos, ModBlocks.WILDBERRY_BUSH.func_176223_P().func_177226_a((IProperty)BlockBerryBush.BERRIES, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    static {
        biomeBlacklist.add(BiomeDictionary.Type.COLD);
        biomeBlacklist.add(BiomeDictionary.Type.SNOWY);
        biomeBlacklist.add(BiomeDictionary.Type.SANDY);
        biomeBlacklist.add(BiomeDictionary.Type.SAVANNA);
        biomeBlacklist.add(BiomeDictionary.Type.MESA);
        biomeBlacklist.add(BiomeDictionary.Type.MUSHROOM);
        biomeBlacklist.add(BiomeDictionary.Type.NETHER);
        biomeBlacklist.add(BiomeDictionary.Type.END);
        biomeBlacklist.add(BiomeDictionary.Type.DEAD);
        biomeBlacklist.add(BiomeDictionary.Type.WASTELAND);
    }
}

