/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.world;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import rustic.common.Config;
import rustic.common.blocks.ModBlocks;
import rustic.common.world.WorldGenAllTrees;
import rustic.common.world.WorldGenBeehive;
import rustic.common.world.WorldGenCaveHerbs;
import rustic.common.world.WorldGenNetherHerbs;
import rustic.common.world.WorldGenSurfaceHerbs;
import rustic.common.world.WorldGenWildberries;

public class WorldGeneratorRustic
implements IWorldGenerator {
    private WorldGenMinable slate = !Config.ENABLE_SLATE ? null : (Config.NETHER_SLATE ? new WorldGenMinable(ModBlocks.SLATE.func_176223_P(), Config.SLATE_VEIN_SIZE, (Predicate)new NetherPredicate()) : new WorldGenMinable(ModBlocks.SLATE.func_176223_P(), Config.SLATE_VEIN_SIZE));
    private WorldGenBeehive beehives = new WorldGenBeehive();
    private WorldGenAllTrees trees = new WorldGenAllTrees();
    private WorldGenSurfaceHerbs surfaceHerbs = new WorldGenSurfaceHerbs();
    private WorldGenCaveHerbs caveHerbs = new WorldGenCaveHerbs();
    private WorldGenNetherHerbs netherHerbs = new WorldGenNetherHerbs();
    private WorldGenWildberries wildberries = new WorldGenWildberries();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        block10: {
            BlockPos chunkCenter;
            block9: {
                chunkCenter = new BlockPos(chunkX * 16 + 8, world.func_189649_b(chunkX * 16 + 8, chunkZ * 16 + 8), chunkZ * 16 + 8);
                if (world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD || world.func_175624_G() == WorldType.field_77138_c && !world.func_72912_H().func_82571_y().contains("decoration")) break block9;
                if (random.nextFloat() < Config.WILDBERRY_GEN_CHANCE) {
                    this.wildberries.func_180709_b(world, random, chunkCenter);
                }
                if (random.nextFloat() < Config.HERB_GEN_CHANCE) {
                    this.surfaceHerbs.func_180709_b(world, random, chunkCenter);
                }
                if (random.nextFloat() < Config.HERB_GEN_CHANCE) {
                    this.caveHerbs.func_180709_b(world, random, chunkCenter);
                }
                this.trees.func_180709_b(world, random, chunkCenter);
                if (!world.func_180494_b(chunkCenter).func_150559_j() && random.nextFloat() < Config.BEEHIVE_GEN_CHANCE) {
                    this.beehives.func_180709_b(world, random, chunkCenter);
                }
                if (!Config.ENABLE_SLATE || Config.NETHER_SLATE) break block10;
                for (int i = 0; i < Config.SLATE_VEINS_PER_CHUNK; ++i) {
                    int x = chunkX * 16 + random.nextInt(16);
                    int y = random.nextInt(80) + 4;
                    int z = chunkZ * 16 + random.nextInt(16);
                    this.slate.func_180709_b(world, random, new BlockPos(x, y, z));
                }
                break block10;
            }
            if (world.field_73011_w.func_186058_p() == DimensionType.NETHER) {
                if (random.nextFloat() < Config.HERB_GEN_CHANCE) {
                    this.netherHerbs.func_180709_b(world, random, chunkCenter);
                }
                if (Config.ENABLE_SLATE && Config.NETHER_SLATE) {
                    for (int i = 0; i < Config.SLATE_VEINS_PER_CHUNK; ++i) {
                        int x = chunkX * 16 + random.nextInt(16);
                        int y = random.nextInt(112) + 8;
                        int z = chunkZ * 16 + random.nextInt(16);
                        this.slate.func_180709_b(world, random, new BlockPos(x, y, z));
                    }
                }
            }
        }
    }

    static class NetherPredicate
    implements Predicate<IBlockState> {
        private NetherPredicate() {
        }

        public boolean apply(IBlockState state) {
            return state != null && state.func_177230_c() == Blocks.field_150424_aL;
        }
    }
}

