/*
 * Decompiled with CFR 0.152.
 */
package rustic.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import rustic.client.models.FluidBottleModel;
import rustic.client.models.LatticeModel;
import rustic.client.renderer.LayerIronSkin;
import rustic.common.blocks.IColoredBlock;
import rustic.common.blocks.ModBlocks;
import rustic.common.blocks.fluids.ModFluids;
import rustic.common.entities.ModEntities;
import rustic.common.items.IColoredItem;
import rustic.common.items.ModItems;
import rustic.core.CommonProxy;

public class ClientProxy
extends CommonProxy {
    private static List<Block> coloredBlocks = new ArrayList<Block>();
    private static List<Item> coloredItems = new ArrayList<Item>();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new LatticeModel.LatticeModelLoader());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)FluidBottleModel.LoaderFluidBottle.INSTANCE);
        ModFluids.initModels();
        ModBlocks.initModels();
        ModItems.initModels();
        ModEntities.initRenderers();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        Collection renderers = Minecraft.func_71410_x().func_175598_ae().field_78729_o.values();
        Collection playerRenderers = Minecraft.func_71410_x().func_175598_ae().getSkinMap().values();
        for (Render renderer : renderers) {
            if (!(renderer instanceof RenderLivingBase)) continue;
            RenderLivingBase renderLivingBase = (RenderLivingBase)renderer;
            renderLivingBase.func_177094_a(new LayerIronSkin<ModelBase>(renderLivingBase, renderLivingBase.func_177087_b()));
        }
        for (RenderPlayer renderPlayer : playerRenderers) {
            renderPlayer.func_177094_a(new LayerIronSkin<ModelPlayer>((RenderLivingBase)renderPlayer, renderPlayer.func_177087_b()));
        }
        this.initColorizer();
    }

    public static void addColoredBlock(Block block) {
        if (block instanceof IColoredBlock) {
            coloredBlocks.add(block);
        }
    }

    public static void addColoredItem(Item item) {
        if (item instanceof IColoredItem) {
            coloredItems.add(item);
        }
    }

    private void initColorizer() {
        for (Block block : coloredBlocks) {
            if (!(block instanceof IColoredBlock)) continue;
            IColoredBlock coloredBlock = (IColoredBlock)block;
            if (coloredBlock.getBlockColor() != null) {
                Minecraft.func_71410_x().func_184125_al().func_186722_a(coloredBlock.getBlockColor(), new Block[]{block});
            }
            if (coloredBlock.getItemColor() == null) continue;
            Minecraft.func_71410_x().getItemColors().func_186731_a(coloredBlock.getItemColor(), new Block[]{block});
        }
        for (Item item : coloredItems) {
            IColoredItem coloredItem;
            if (!(item instanceof IColoredItem) || (coloredItem = (IColoredItem)item).getItemColor() == null) continue;
            Minecraft.func_71410_x().getItemColors().func_186730_a(coloredItem.getItemColor(), new Item[]{item});
        }
    }

    @Override
    public void spawnAlchemySmokeFX(World world, int brewTime, double x, double y, double z, double xVel, double yVel, double zVel) {
        Particle smoke = new ParticleSmokeNormal.Factory().func_178902_a(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), world, x, y, z, xVel, yVel, zVel, new int[0]);
        float colorScale = 0.4f;
        float r = colorScale * (MathHelper.func_76126_a((float)(30.0f + (float)brewTime / 16.0f)) * 0.5f + 0.5f);
        float g = colorScale * (MathHelper.func_76126_a((float)((float)brewTime / 16.0f)) * 0.5f + 0.5f);
        float b = colorScale * (MathHelper.func_76126_a((float)(60.0f + (float)brewTime / 16.0f)) * 0.5f + 0.5f);
        smoke.func_70538_b(r, g, b);
        smoke.func_187114_a(10);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(smoke);
    }
}

