/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.api.autocrafting;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternChain;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public interface ICraftingManager {
    public List<ICraftingTask> getTasks();

    public void add(@Nonnull ICraftingTask var1);

    public void cancel(@Nonnull ICraftingTask var1);

    public ICraftingTask create(@Nullable ItemStack var1, ICraftingPattern var2, int var3, boolean var4);

    public ICraftingTask create(@Nullable ItemStack var1, ICraftingPatternChain var2, int var3, boolean var4);

    @Nullable
    public ICraftingTask schedule(ItemStack var1, int var2, int var3);

    public void track(ItemStack var1, int var2);

    public List<ICraftingPattern> getPatterns();

    public void rebuild();

    public List<ICraftingPattern> getPatterns(ItemStack var1, int var2);

    @Nullable
    default public ICraftingPattern getPattern(ItemStack pattern, int flags) {
        ICraftingPatternChain chain = this.getPatternChain(pattern, flags);
        return chain == null ? null : chain.cycle();
    }

    @Nullable
    default public ICraftingPattern getPattern(ItemStack pattern, int flags, IStackList<ItemStack> itemList) {
        ICraftingPatternChain chain = this.getPatternChain(pattern, flags, itemList);
        return chain == null ? null : chain.cycle();
    }

    @Nullable
    default public ICraftingPattern getPattern(ItemStack pattern) {
        return this.getPattern(pattern, 3);
    }

    @Nullable
    public ICraftingPatternChain getPatternChain(ItemStack var1, int var2);

    @Nullable
    public ICraftingPatternChain getPatternChain(ItemStack var1, int var2, IStackList<ItemStack> var3);

    @Nullable
    default public ICraftingPatternChain getPatternChain(ItemStack pattern) {
        return this.getPatternChain(pattern, 3);
    }

    default public boolean hasPattern(ItemStack stack) {
        return this.hasPattern(stack, 3);
    }

    public boolean hasPattern(ItemStack var1, int var2);

    public void update();

    public void readFromNBT(NBTTagCompound var1);

    public NBTTagCompound writeToNBT(NBTTagCompound var1);
}

