/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingStep;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingStep;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CraftingStepProcess
extends CraftingStep {
    public static final String ID = "process";

    public CraftingStepProcess(INetwork network, ICraftingPattern pattern, List<ICraftingStep> preliminarySteps) {
        super(network, pattern, preliminarySteps);
    }

    public CraftingStepProcess(INetwork network) {
        super(network);
    }

    @Override
    public boolean canStartProcessing(IStackList<ItemStack> items, IStackList<FluidStack> fluids) {
        if (!super.canStartProcessing()) {
            return false;
        }
        IItemHandler inventory = this.getPattern().getContainer().getFacingInventory();
        int compare = 0x13 | (this.pattern.isOredict() ? 8 : 0);
        if (inventory != null) {
            LinkedList<ItemStack> toInsert = new LinkedList<ItemStack>();
            for (ItemStack stack : this.getInputs()) {
                compare = stack.func_77984_f() ? (compare &= 0xFFFFFFFE) : (compare |= 1);
                ItemStack actualStack = items.get(stack, compare);
                CraftingStep.AvailableType type = this.isItemAvailable(items, fluids, stack, actualStack, compare);
                if (type == CraftingStep.AvailableType.ITEM) {
                    toInsert.add(ItemHandlerHelper.copyStackWithSize((ItemStack)actualStack, (int)stack.func_190916_E()));
                    continue;
                }
                if (type == CraftingStep.AvailableType.FLUID) {
                    toInsert.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.func_190916_E()));
                    continue;
                }
                items.undo();
                fluids.undo();
                return false;
            }
            items.undo();
            fluids.undo();
            return CraftingStepProcess.insertItems(inventory, toInsert, true);
        }
        return false;
    }

    @Override
    public boolean canStartProcessing() {
        if (!super.canStartProcessing()) {
            return false;
        }
        IItemHandler inventory = this.getPattern().getContainer().getFacingInventory();
        return inventory != null && CraftingStepProcess.insertItems(inventory, new LinkedList<ItemStack>(this.getInputs()), true);
    }

    @Override
    public void execute(Deque<ItemStack> toInsertItems, Deque<FluidStack> toInsertFluids) {
        LinkedList<ItemStack> extracted = new LinkedList<ItemStack>();
        int compare = 0x13 | (this.getPattern().isOredict() ? 8 : 0);
        if (this.extractItems(extracted, compare, toInsertItems)) {
            IItemHandler inventory = this.getPattern().getContainer().getFacingInventory();
            if (CraftingStepProcess.insertItems(inventory, new ArrayDeque<ItemStack>(extracted), true)) {
                CraftingStepProcess.insertItems(inventory, extracted, false);
            } else {
                toInsertItems.addAll(extracted);
                this.startedProcessing = false;
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("CraftingStepType", ID);
        return super.writeToNBT(tag);
    }

    private static boolean insertItems(IItemHandler inventory, Deque<ItemStack> stacks, boolean simulate) {
        ItemStack current = stacks.poll();
        List availableSlots = IntStream.range(0, inventory.getSlots()).boxed().collect(Collectors.toList());
        while (current != null && !availableSlots.isEmpty()) {
            ItemStack remainder = null;
            for (Integer slot : availableSlots) {
                remainder = inventory.insertItem(slot.intValue(), current, simulate);
                if (!remainder.func_190926_b() && current.func_190916_E() == remainder.func_190916_E()) continue;
                availableSlots.remove(slot);
                break;
            }
            if (remainder == null || remainder.func_190926_b()) {
                current = stacks.poll();
                continue;
            }
            if (current.func_190916_E() == remainder.func_190916_E()) break;
            current = remainder;
        }
        return current == null && stacks.isEmpty();
    }
}

