/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network;

import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeFactory;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class NetworkNodeManager
extends WorldSavedData
implements INetworkNodeManager {
    public static final String NAME = "refinedstorage_nodes";
    private static final String NBT_NODES = "Nodes";
    private static final String NBT_NODE_ID = "Id";
    private static final String NBT_NODE_DATA = "Data";
    private static final String NBT_NODE_POS = "Pos";
    private boolean canReadNodes;
    private NBTTagList nodesTag;
    private ConcurrentHashMap<BlockPos, INetworkNode> nodes = new ConcurrentHashMap();

    public NetworkNodeManager(String s) {
        super(s);
    }

    public void func_76184_a(NBTTagCompound tag) {
        ConcurrentHashMap newNodes = new ConcurrentHashMap();
        if (tag.func_74764_b(NBT_NODES)) {
            this.nodesTag = tag.func_150295_c(NBT_NODES, 10);
            this.canReadNodes = true;
        }
        this.nodes = newNodes;
    }

    public void tryReadNodes(World world) {
        if (this.canReadNodes) {
            this.canReadNodes = false;
            this.nodes.clear();
            for (int i = 0; i < this.nodesTag.func_74745_c(); ++i) {
                NBTTagCompound nodeTag = this.nodesTag.func_150305_b(i);
                String id = nodeTag.func_74779_i(NBT_NODE_ID);
                NBTTagCompound data = nodeTag.func_74775_l(NBT_NODE_DATA);
                BlockPos pos = BlockPos.func_177969_a((long)nodeTag.func_74763_f(NBT_NODE_POS));
                INetworkNodeFactory factory = API.instance().getNetworkNodeRegistry().get(id);
                if (factory == null) continue;
                INetworkNode node = null;
                try {
                    node = factory.create(data, world, pos);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (node == null) continue;
                this.nodes.put(pos, node);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (INetworkNode node : this.all()) {
            NBTTagCompound nodeTag = new NBTTagCompound();
            nodeTag.func_74778_a(NBT_NODE_ID, node.getId());
            nodeTag.func_74772_a(NBT_NODE_POS, node.getPos().func_177986_g());
            nodeTag.func_74782_a(NBT_NODE_DATA, (NBTBase)node.write(new NBTTagCompound()));
            list.func_74742_a((NBTBase)nodeTag);
        }
        tag.func_74782_a(NBT_NODES, (NBTBase)list);
        return tag;
    }

    @Override
    @Nullable
    public INetworkNode getNode(BlockPos pos) {
        return this.nodes.get(pos);
    }

    @Override
    public void removeNode(BlockPos pos) {
        this.nodes.remove(pos);
    }

    @Override
    public void setNode(BlockPos pos, INetworkNode node) {
        this.nodes.put(pos, node);
    }

    @Override
    public Collection<INetworkNode> all() {
        return this.nodes.values();
    }

    @Override
    public void markForSaving() {
        this.func_76185_a();
    }
}

