/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerListenerNetworkNode;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.tile.TileDestructor;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeDestructor
extends NetworkNode
implements IComparable,
IFilterable,
IType {
    public static final String ID = "destructor";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_PICKUP = "Pickup";
    private static final int BASE_SPEED = 20;
    private ItemHandlerBase itemFilters = new ItemHandlerBase(9, new ItemHandlerListenerNetworkNode(this), new Predicate[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(9, new ItemHandlerListenerNetworkNode(this));
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ItemHandlerListenerNetworkNode(this), 2, 6, 7, 8, 9);
    private int compare = 3;
    private int mode = 0;
    private int type = 0;
    private boolean pickupItem = false;

    public NetworkNodeDestructor(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.destructorUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        super.update();
        if (this.network != null && this.canUpdate() && this.ticks % this.upgrades.getSpeed(20, 4) == 0) {
            BlockPos front = this.pos.func_177972_a(this.getDirection());
            if (this.pickupItem && this.type == 0) {
                ArrayList droppedItems = new ArrayList();
                Chunk chunk = this.world.func_175726_f(front);
                chunk.func_177414_a(null, new AxisAlignedBB(front), droppedItems, null);
                for (Entity entity : droppedItems) {
                    ItemStack droppedItem;
                    if (!(entity instanceof EntityItem) || !IFilterable.canTake((IItemHandler)this.itemFilters, this.mode, this.compare, droppedItem = ((EntityItem)entity).func_92059_d()) || this.network.insertItem(droppedItem, droppedItem.func_190916_E(), true) != null) continue;
                    this.network.insertItemTracked(droppedItem.func_77946_l(), droppedItem.func_190916_E());
                    this.world.func_72900_e(entity);
                    break;
                }
            } else if (this.type == 0) {
                IBlockState frontBlockState = this.world.func_180495_p(front);
                Block frontBlock = frontBlockState.func_177230_c();
                ItemStack frontStack = frontBlock.getPickBlock(frontBlockState, null, this.world, front, null);
                if (!frontStack.func_190926_b() && IFilterable.canTake((IItemHandler)this.itemFilters, this.mode, this.compare, frontStack) && (double)frontBlockState.func_185887_b(this.world, front) != -1.0) {
                    NonNullList drops = NonNullList.func_191196_a();
                    if (frontBlock instanceof BlockShulkerBox) {
                        drops.add((Object)((BlockShulkerBox)frontBlock).func_185473_a(this.world, front, frontBlockState));
                        TileEntity shulkerBoxTile = this.world.func_175625_s(front);
                        if (shulkerBoxTile instanceof TileEntityShulkerBox) {
                            ((TileEntityShulkerBox)shulkerBoxTile).func_190579_a(true);
                            ((TileEntityShulkerBox)shulkerBoxTile).func_174888_l();
                        }
                    } else if (this.upgrades.hasUpgrade(6) && frontBlock.canSilkHarvest(this.world, front, frontBlockState, null)) {
                        drops.add((Object)frontStack);
                    } else {
                        frontBlock.getDrops(drops, (IBlockAccess)this.world, front, frontBlockState, this.upgrades.getFortuneLevel());
                    }
                    for (ItemStack drop : drops) {
                        if (this.network.insertItem(drop, drop.func_190916_E(), true) == null) continue;
                        return;
                    }
                    BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(this.world, front, frontBlockState, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.world)));
                    if (!MinecraftForge.EVENT_BUS.post((Event)e)) {
                        this.world.func_180498_a(null, 2001, front, Block.func_176210_f((IBlockState)frontBlockState));
                        this.world.func_175698_g(front);
                        for (ItemStack drop : drops) {
                            if (this.network == null) {
                                InventoryHelper.func_180173_a((World)this.world, (double)front.func_177958_n(), (double)front.func_177956_o(), (double)front.func_177952_p(), (ItemStack)drop);
                                continue;
                            }
                            this.network.insertItemTracked(drop, drop.func_190916_E());
                        }
                    }
                }
            } else if (this.type == 1) {
                FluidStack stack;
                Block frontBlock = this.world.func_180495_p(front).func_177230_c();
                BlockLiquidWrapper handler = null;
                if (frontBlock instanceof BlockLiquid) {
                    handler = new BlockLiquidWrapper((BlockLiquid)frontBlock, this.world, front);
                } else if (frontBlock instanceof IFluidBlock) {
                    handler = new FluidBlockWrapper((IFluidBlock)frontBlock, this.world, front);
                }
                if (handler != null && (stack = handler.drain(1000, false)) != null && IFilterable.canTakeFluids(this.fluidFilters, this.mode, this.compare, stack) && this.network.insertFluid(stack, stack.amount, true) == null) {
                    FluidStack drained = handler.drain(1000, true);
                    this.network.insertFluid(drained, drained.amount, false);
                }
            }
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74757_a(NBT_PICKUP, this.pickupItem);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        StackUtils.writeItems((IItemHandler)this.fluidFilters, 2, tag);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_PICKUP)) {
            this.pickupItem = tag.func_74767_n(NBT_PICKUP);
        }
        StackUtils.readItems((IItemHandlerModifiable)this.itemFilters, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.fluidFilters, 2, tag);
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getInventory() {
        return this.itemFilters;
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? TileDestructor.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }

    public boolean isPickupItem() {
        return this.pickupItem;
    }

    public void setPickupItem(boolean pickupItem) {
        this.pickupItem = pickupItem;
    }
}

