/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerListenerNetworkNode;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.item.ItemFilter;
import com.raoulvdberge.refinedstorage.tile.TileExporter;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class NetworkNodeExporter
extends NetworkNode
implements IComparable,
IType {
    public static final String ID = "exporter";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_REGULATOR = "Regulator";
    private ItemHandlerBase itemFilters = new ItemHandlerBase(9, new ItemHandlerListenerNetworkNode(this), new Predicate[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(9, new ItemHandlerListenerNetworkNode(this));
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ItemHandlerListenerNetworkNode(this), 2, 3, 4);
    private int compare = 3;
    private int type = 0;
    private boolean regulator = false;

    public NetworkNodeExporter(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.exporterUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        block8: {
            IFluidHandler handler;
            block9: {
                super.update();
                if (this.network == null || !this.canUpdate() || this.ticks % this.upgrades.getSpeed() != 0) break block8;
                if (this.type != 0) break block9;
                IItemHandler handler2 = WorldUtils.getItemHandler(this.getFacingTile(), this.getDirection().func_176734_d());
                if (handler2 == null) break block8;
                for (int i = 0; i < this.itemFilters.getSlots(); ++i) {
                    ItemStack slot = this.itemFilters.getStackInSlot(i);
                    if (slot.func_190926_b()) continue;
                    if (slot.func_77973_b() == RSItems.FILTER) {
                        for (ItemStack slotInFilter : ItemFilter.getFilterItemsFromCache(slot)) {
                            if (slotInFilter.func_190926_b()) continue;
                            this.doExport(handler2, slotInFilter);
                        }
                        continue;
                    }
                    this.doExport(handler2, slot);
                }
                break block8;
            }
            if (this.type == 1 && (handler = WorldUtils.getFluidHandler(this.getFacingTile(), this.getDirection().func_176734_d())) != null) {
                for (FluidStack stack : this.fluidFilters.getFluids()) {
                    int filled;
                    FluidStack took;
                    FluidStack stackInStorage;
                    if (stack == null || (stackInStorage = this.network.getFluidStorageCache().getList().get(stack, this.compare)) == null) continue;
                    int toExtract = Math.min(1000 * this.upgrades.getItemInteractCount(), stackInStorage.amount);
                    boolean skipSlot = false;
                    if (this.regulator) {
                        for (IFluidTankProperties tankProperty : handler.getTankProperties()) {
                            FluidStack exporterStack = tankProperty.getContents();
                            if (!API.instance().getComparer().isEqual(stackInStorage, exporterStack, this.compare)) continue;
                            if (exporterStack.amount >= stack.amount * 1000) {
                                skipSlot = true;
                                break;
                            }
                            toExtract = this.upgrades.hasUpgrade(4) ? stack.amount * 1000 - exporterStack.amount : 1000;
                            toExtract = Math.min(toExtract, stackInStorage.amount);
                        }
                    }
                    if (skipSlot || (took = this.network.extractFluid(stack, toExtract, this.compare, true)) == null || (filled = handler.fill(took, false)) <= 0) continue;
                    took = this.network.extractFluid(stack, filled, this.compare, false);
                    handler.fill(took, true);
                    break;
                }
            }
        }
    }

    private void doExport(IItemHandler handler, ItemStack slot) {
        ItemStack took;
        int stackSize = this.upgrades.getItemInteractCount();
        if (this.regulator) {
            int found = 0;
            for (int index = 0; index < handler.getSlots(); ++index) {
                ItemStack handlerStack = handler.getStackInSlot(index);
                if (!API.instance().getComparer().isEqual(slot, handlerStack, this.compare)) continue;
                found += handlerStack.func_190916_E();
            }
            int needed = 0;
            for (int i = 0; i < this.itemFilters.getSlots(); ++i) {
                if (!API.instance().getComparer().isEqualNoQuantity(slot, this.itemFilters.getStackInSlot(i))) continue;
                needed += this.itemFilters.getStackInSlot(i).func_190916_E();
            }
            stackSize = needed - found;
            if (stackSize <= 0) {
                return;
            }
            if (!this.upgrades.hasUpgrade(4)) {
                stackSize = 1;
            }
        }
        if ((took = this.network.extractItem(slot, Math.min(slot.func_77976_d(), stackSize), this.compare, true)) == null) {
            if (this.upgrades.hasUpgrade(3)) {
                this.network.getCraftingManager().schedule(slot, stackSize, this.compare);
            }
        } else if (ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)true).func_190926_b() && (took = this.network.extractItem(slot, Math.min(slot.func_77976_d(), stackSize), this.compare, false)) != null) {
            ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)false);
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74757_a(NBT_REGULATOR, this.regulator);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        StackUtils.writeItems((IItemHandler)this.fluidFilters, 2, tag);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_REGULATOR)) {
            this.regulator = tag.func_74767_n(NBT_REGULATOR);
        }
        StackUtils.readItems((IItemHandlerModifiable)this.itemFilters, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.fluidFilters, 2, tag);
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.upgrades;
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? TileExporter.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public void setRegulator(boolean regulator) {
        this.regulator = regulator;
    }

    public boolean isRegulator() {
        return this.world.field_72995_K ? TileExporter.REGULATOR.getValue() : this.regulator;
    }

    public ItemHandlerBase getItemFilters() {
        return this.itemFilters;
    }

    public ItemHandlerFluid getFluidFilters() {
        return this.fluidFilters;
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }
}

